//////////////////////////////////////////////////////////////////////////
//
// pgScript - PostgreSQL Tools
// RCS-ID:      $Id: pgsReferenceGen.cpp,v 1.1 2008/06/27 18:19:16 pgunittest Exp $
// Copyright (C) 2008 The pgScript Development Team
// This software is released under the Artistic Licence
//
//////////////////////////////////////////////////////////////////////////


#include "pgAdmin3.h"
#include "pgscript/generators/pgsReferenceGen.h"

#include "pgscript/expressions/pgsExecute.h"
#include "pgscript/utilities/pgsThread.h"

pgsReferenceGen::pgsReferenceGen(pgsThread * app, const wxString & table,
		const wxString & column, const bool & sequence, const long & seed) :
	pgsObjectGen(seed), m_app(app), m_table(table), m_column(column), m_sequence(sequence)
{
	// We need an empty symbol table for calling pgsExecute.eval(...)
	pgsVarMap vars;
	
	pgsOperand result = pgsExecute(wxString() << wxT("SELECT count(*) FROM ")
			<< m_table, 0, m_app).eval(vars);
	wxString value = result->value();
	if (!value.IsEmpty())
	{
		m_nb_rows = pgsMapm::pgs_str_mapm(value);
	}
	else
	{
		m_nb_rows = 0;
	}
	wxLogScriptVerbose(wxT("REFGEN: Number of rows in %s: %s"), m_table.c_str(),
			pgsMapm::pgs_mapm_str(m_nb_rows).c_str());
	m_randomizer = pgsRandomizer(pnew pgsIntegerGen(0, m_nb_rows - 1, is_sequence(), m_seed));
}

bool pgsReferenceGen::is_sequence() const
{
	return m_sequence;
}

wxString pgsReferenceGen::random()
{
	// We need an empty symbol table for calling pgsExecute.eval(...)
	pgsVarMap vars;
	
	pgsOperand result = pgsExecute(wxString() << wxT("SELECT ") << m_column
			<< wxT(" FROM ") << m_table << wxT(" LIMIT 1 OFFSET ")
			<< m_randomizer->random(), 0, m_app).eval(vars);
	
	return result->value();
}

pgsReferenceGen::~pgsReferenceGen()
{

}

pgsReferenceGen * pgsReferenceGen::clone()
{
	return pnew pgsReferenceGen(*this);
}
