<?php

class HtmlReportAggregator extends ReportAggregator {
	var $geshi;
	
	function HtmlReportAggregator(& $logReader) {
		$this->ReportAggregator($logReader);
		
		$this->geshi = new GeSHi('', 'sql');
		$this->geshi->enable_classes();
		$this->geshi->set_header_type(GESHI_HEADER_NONE);
	}
	
	function highlightSql($sql, $prepend = '', $append = '') {
		if(substr($sql, -1, 1) != ';') {
			$sql .= ';';
		}
		$this->geshi->set_source($sql);
		return '<div class="sql">'.$prepend.$this->geshi->parse_code().$append.'</div>';
	}
	
	function getHeader() {
		$header = '
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
	<head>
		<title>pgFouine: PostgreSQL log analysis report</title>
		<style type="text/css">
			'.$this->getStyles().'
		</style>
		<script type="text/javascript">
			function toggle(idButton, idDiv, label) {
				if(document.getElementById(idDiv)) {
					if(document.getElementById(idDiv).style.display == \'none\') {
						document.getElementById(idDiv).style.display = \'block\';
						document.getElementById(idButton).value = \'Hide \'+label;
					} else {
						document.getElementById(idDiv).style.display = \'none\';
						document.getElementById(idButton).value = \'Show \'+label;
					}
				}
			}
		</script>
	</head>
	<body>
		<div id="content">
			<h1 id="top">pgFouine: PostgreSQL log analysis report</h1>
		';
		return $header;
	}
	
	function getBody() {
		$count = count($this->reports);
		
		$reportsOutput = '';
		$menu = '<div class="menu">';
		
		for($i = 0; $i < $count; $i++) {
			$report =& $this->reports[$i];
			if($i > 0) {
				$menu .= ' | ';
			}
			$menu .= '<a href="#'.$report->getReportClass().'">'.$report->getTitle().'</a>';
			$reportsOutput .= $report->getHtmlTitle();
			$reportsOutput .= $report->getHtml();
			$reportsOutput .= "\n";
		}
		$menu .= '</div>';
		
		$output = $menu."\n";
		
		$output .= '<p>Normalized reports are marked with a "(N)".</p>';
		
		$output .= '<div class="information"><ul>'.
			'<li>Generated on '.date('Y-m-d H:i').'</li>'.
			'<li>Parsed '.$this->getFileName().' ('.$this->formatInteger($this->getLineParsedCount()).' lines) in '.$this->formatLongDuration($this->getTimeToParse(), 0).'</li>'.
			'<li>Executed on '.getenv('HOSTNAME').'</li>'.
			'</ul></div>';
		
		$output .= '<div class="reports">';
		$output .= $reportsOutput;
		$output .= '</div>';
		
		return $output;
	}
	
	function getFooter() {
		$footer = '
			<div class="footer">
				Report generated by <a href="http://pgfouine.projects.postgresql.org/">pgFouine</a> '.VERSION.'. pgFouine is free software.
			</div>
		</div>
	</body>
</html>
		';
		return $footer;
	}
	
	function getStyles() {
		$styles = '
			body { background-color: #FFFFFF; }
			* { font-family: Verdana, Arial, Helvetica; }
			div, p, th, td { font-size:12px; }
			h1 { font-size:16px; color:#FFFFFF; font-weight:normal; padding:6px; background-color:rgb(180, 80, 80); margin-bottom:0px; }
			h2 { margin-top:15px; margin-bottom:10px; font-weight:normal; font-size:14px; padding:2px 10px 2px 0px; border-bottom:1px solid #7B8CBE; color:#7B8CBE; }
			h2 a, h2 a:hover { color:black; text-decoration:none; }
			div.menu { background-color:rgb(220,230,252); padding:4px; margin-bottom:20px; }
			div.menu a { padding-right:3px; padding-left:3px; color:black; text-decoration:none; }
			div.menu a:hover { padding-right:3px; padding-left:3px; padding-top:2px; padding-bottom:2px; text-decoration:none; background-color:rgb(180, 80, 80); color:white; -moz-border-radius:3px; }
			div.information { border:1px solid #FFB462; -moz-border-radius:6px;	padding:10px; margin-top:5px; background-color:#FEE3C4; }
			ul { padding-left: 14px; padding-top: 0px; padding-bottom: 0px; margin-bottom: 0px; margin-top: 0px; }
			ul li { list-style-type: square; }
			div.reports { padding:4px; }
			table.queryList td, table.queryList th { padding: 2px; }
			table.queryList th { background-color: #DDDDDD; border:1px solid #CCCCCC; }
			table.queryList tr.row0 td { background-color: #FFFFFF; border: 1px solid #EEEEEE; }
			table.queryList tr.row1 td { background-color: #EEEEEE; }
			table.queryList td.top { vertical-align:top; }
			table.queryList td.right { text-align:right; }
			table.queryList td.center { text-align:center; }
			table.queryList td.relevantInformation { font-weight:bold; }
			table.queryList div.examples { background-color:#EBF0FC; border:1px solid #FFFFFF; -moz-border-radius:10px; padding:6px; margin:5px; }
			table.queryList div.examples div.example0 { padding:2px; }
			table.queryList div.examples div.example1 { background-color:#FFFFFF; padding:2px; border:1px solid #EBF0FC; -moz-border-radius:5px; }
			table.queryList div.error { color: #D53131; font-weight:bold; }
			table.queryList div.errorInformation { color: #8D8D8D; font-style:italic; }
			table.queryList input { border:1px solid black; background-color:#FFFFFF; padding:1px; font-size:11px; }
			div.footer { font-size:10px; margin-top:30px; background-color:rgb(180, 80, 80); padding:5px; text-align:right; color:white; }
			div.footer a, div.footer a:hover { color:white; text-decoration:underline; }
		';
		$styles .= $this->geshi->get_stylesheet();
		return $styles;
	}
}

?>