/*--------------------------------------------------------------------
 * FILE:
 *    send_conf.c
 *
 * NOTE:
 *
 * Portions Copyright (c) 2003-2009, Atsushi Mitani
 *--------------------------------------------------------------------
 */
#include "postgres.h"

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <fcntl.h>
#include <dirent.h>
#include <ctype.h>
#include <sys/stat.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>
#include <netdb.h>
#include <errno.h>
#include <sys/file.h>
#include <sys/wait.h>

#include "libpq-fe.h"
#include "libpq-int.h"
#include "fe-auth.h"

#include "replicate.h"
#include "libpgc/libpgc.h"
#include "pglb/pglb.h"
#include "pgrp/pgreplicate.h"
#include "admin/pgc_admin.h"

int PGRsend_pgc_admin_conf_file(char * path);
int PGRsend_pgc_probe_conf_file(char * path);
int PGRsend_conf_files(char * path);
#if 0
static Pglb_Info * get_pglb_server_rec(uint16_t physicalServerId);
static Cluster_Info * get_cluster_server_rec(uint16_t physicalServerId);
static Pgrp_Info * get_pgrp_server_rec(uint16_t physicalServerId);
static SSL_Server_Info * get_admin_server_rec(uint16_t physicalServerId);
static SSL_Server_Info * get_probe_server_rec(uint16_t physicalServerId);
#endif
static int send_conf_file(char * conf_dir, char * workPath, Physical_Server_Info * server);
static int exec_scp(char * src, char * dest);

int 
PGRsend_pgc_admin_conf_file(char * path)
{
	char conf_dir[512];
	int i;
	Physical_Server_Info * server = NULL;
	SSL_Server_Info * admin = AdminTbl;

	if (path == NULL) 
	{
		return STATUS_ERROR;
	}
	for (i = 0 ; i < RecordNumTbl->adminNum ; i ++, admin ++)
	{
		memset(conf_dir, 0, sizeof(conf_dir));
		server = PGRget_Physical_Server_Rec(admin->physicalServerId);
		if (PGRget_dir_name_with_hostname(conf_dir, path, server) == NULL)
		{
			continue;
		}
		strcpy(admin->workPath,DEFAULT_WORK_DIR_OF_ADMIN);
		send_conf_file(conf_dir, admin->workPath, server); 
	}
	return STATUS_OK;
}

int 
PGRsend_pgc_probe_conf_file(char * path)
{
	char conf_dir[512];
	int i;
	Physical_Server_Info * server = NULL;
	SSL_Server_Info * probe = ProbeTbl;

	if (path == NULL) 
	{
		return STATUS_ERROR;
	}
	for (i = 0 ; i < RecordNumTbl->probeNum ; i ++, probe ++)
	{
		memset(conf_dir, 0, sizeof(conf_dir));
		server = PGRget_Physical_Server_Rec(probe->physicalServerId);
		if (PGRget_dir_name_with_hostname(conf_dir, path, server) == NULL)
		{
			continue;
		}
		strcpy(probe->workPath,DEFAULT_WORK_DIR_OF_PROBE);
		send_conf_file(conf_dir, probe->workPath, server); 
	}
	return STATUS_OK;
}

int 
PGRsend_conf_files(char * path)
{
	char conf_dir[512];
	int i;
	Physical_Server_Info * server = NULL;
	Pglb_Info * pglb = NULL;
	Pgrp_Info * pgrp = NULL;
	Cluster_Info * cluster = NULL;
	SSL_Server_Info * admin = NULL;
	SSL_Server_Info * probe = NULL;
	char dest[512];

	if (path == NULL) 
	{
		return STATUS_ERROR;
	}
	
	/* send configuration files for admin */
	admin = AdminTbl;
	for (i = 0 ; i < RecordNumTbl->adminNum ; i ++, admin ++)
	{
		server = PGRget_Physical_Server_Rec(admin->physicalServerId);
		if (server != NULL)
		{
			memset(conf_dir, 0, sizeof(conf_dir));
			if (PGRget_dir_name_with_hostname(conf_dir, path, server) == NULL)
			{
				continue;
			}
			send_conf_file(conf_dir, admin->workPath, server); 
		}
	}

	/* send configuration files for probe */
	probe = ProbeTbl;
	for (i = 0 ; i < RecordNumTbl->probeNum ; i ++, probe ++)
	{
		server = PGRget_Physical_Server_Rec(probe->physicalServerId);
		if (server != NULL)
		{
			memset(conf_dir, 0, sizeof(conf_dir));
			if (PGRget_dir_name_with_hostname(conf_dir, path, server) == NULL)
			{
				continue;
			}
			send_conf_file(conf_dir, probe->workPath, server); 
		}
	}

	/* send configuration files for pglb */
	pglb = PglbTbl;
	for (i = 0 ; i < RecordNumTbl->pglbNum ; i ++, pglb ++)
	{
		server = PGRget_Physical_Server_Rec(pglb->physicalServerId);
		if (server != NULL)
		{
			memset(conf_dir, 0, sizeof(conf_dir));
			if (PGRget_dir_name_with_hostname(conf_dir, path, server) == NULL)
			{
				continue;
			}
			send_conf_file(conf_dir, pglb->workPath, server); 
		}
	}

	/* send configuration files for pgrp */
	pgrp = PgrpTbl;
	for (i = 0 ; i < RecordNumTbl->pgrpNum ; i ++, pgrp ++)
	{
		server = PGRget_Physical_Server_Rec(pgrp->physicalServerId);
		if (server != NULL)
		{
			memset(conf_dir, 0, sizeof(conf_dir));
			if (PGRget_dir_name_with_hostname(conf_dir, path, server) == NULL)
			{
				continue;
			}
			send_conf_file(conf_dir, pgrp->workPath, server); 
		}
	}

	/* send configuration files for cluster DB */
	cluster = ClusterDbTbl;
	for (i = 0 ; i < RecordNumTbl->clusterNum ; i ++, cluster ++)
	{
		server = PGRget_Physical_Server_Rec(cluster->physicalServerId);
		if (server != NULL)
		{
			memset(conf_dir, 0, sizeof(conf_dir));
			if (PGRget_dir_name_with_hostname(conf_dir, path, server) == NULL)
			{
				continue;
			}
			/* scp db cluster dir */
			send_conf_file(conf_dir, cluster->workPath, server); 
			/* scp bin dir */
			sprintf(dest,"%s@%s:%s",server->userName,server->hostName, cluster->binPath);
			exec_scp(cluster->binPath,  dest); 
			/* scp lib dir */
			sprintf(conf_dir,"%s/../lib",cluster->binPath);
			sprintf(dest,"%s@%s:%s",server->userName,server->hostName, conf_dir);
			exec_scp(conf_dir,  dest); 
			/* scp share dir */
			sprintf(conf_dir,"%s/../share",cluster->binPath);
			sprintf(dest,"%s@%s:%s",server->userName,server->hostName, conf_dir);
			exec_scp(conf_dir,  dest); 
		}

	}
	return STATUS_OK;
}

#if 0
static Pglb_Info *
get_pglb_server_rec(uint16_t physicalServerId)
{
	Pglb_Info * pglb = PglbTbl;
	int i;

	for (i = 0 ; i < RecordNumTbl->pglbNum ; i ++, pglb ++)
	{
		if (pglb->physicalServerId == physicalServerId)
		{
			return pglb;
		}
	}
	return NULL;
}

static Cluster_Info *
get_cluster_server_rec(uint16_t physicalServerId)
{
	Cluster_Info * cluster = ClusterDbTbl;
	int i;

	for (i = 0 ; i < RecordNumTbl->clusterNum ; i ++, cluster ++)
	{
		if (cluster->physicalServerId == physicalServerId)
		{
			return cluster;
		}
	}
	return NULL;
}

static Pgrp_Info *
get_pgrp_server_rec(uint16_t physicalServerId)
{
	Pgrp_Info * pgrp = PgrpTbl;
	int i;

	for (i = 0 ; i < RecordNumTbl->pgrpNum ; i ++, pgrp ++)
	{
		if (pgrp->physicalServerId == physicalServerId)
		{
			return pgrp;
		}
	}
	return NULL;
}

static SSL_Server_Info *
get_admin_server_rec(uint16_t physicalServerId)
{
	SSL_Server_Info * admin = AdminTbl;
	int i;

	for (i = 0 ; i < RecordNumTbl->adminNum ; i ++, admin ++)
	{
		if (admin->physicalServerId == physicalServerId)
		{
			return admin;
		}
	}
	return NULL;
}

static SSL_Server_Info *
get_probe_server_rec(uint16_t physicalServerId)
{
	SSL_Server_Info * probe = ProbeTbl;
	int i;

	for (i = 0 ; i < RecordNumTbl->probeNum ; i ++, probe ++)
	{
		if (probe->physicalServerId == physicalServerId)
		{
			return probe;
		}
	}
	return NULL;
}
#endif

static int
send_conf_file(char * conf_dir, char * workPath, Physical_Server_Info * server) 
{
	char scp_command[1024];
	char * p = NULL;
	char * dir_name = NULL;
	
	if ((conf_dir == NULL) || (workPath == NULL) || (server == NULL))
	{
		return STATUS_ERROR;
	}

	p = strrchr(workPath, '/');
	if (p == NULL)
	{
		return STATUS_ERROR;
	}
	*p = '\0';
	dir_name = p+1;
	memset (scp_command, 0, sizeof(scp_command));
	sprintf(scp_command,"scp -r %s/%s %s@%s:%s", conf_dir, dir_name, server->userName, server->hostName, workPath);
	*p = '/';
	system(scp_command);

	return STATUS_OK;
}

static int
exec_scp(char * src, char * dest)
{
	char * args[8];
	int i = 0;
	char * p = NULL;

	if ((p = strrchr(dest,'/')) != NULL)
	{
		*p='\0';
	}
	args[i++] = "scp";
	args[i++] = "-r";
	args[i++] = src;
	args[i++] = dest;
	args[i++] = NULL;

	return (PGR_execv("/usr/bin/scp", args));
}
