/*--------------------------------------------------------------------
 * FILE:
 *     probe_exec_pgrp.c
 *
 * NOTE:
 *     This file is composed of the probe process 
 *     Low level I/O functions that called by in these functions are 
 *     contained in 'replicate_com.c'.
 *
 *--------------------------------------------------------------------
 */
#include "postgres.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/file.h>

#ifdef MULTIBYTE
#include "mb/pg_wchar.h"
#endif

#include "pgc_admin.h"

uint16_t PGC_Probe_Exec_Pgrp(Probe_Header * header, char * packet);

static int set_pgrp_2_exec(Exec_Info * exec, Pgrp_Info *pgrp);
static int16_t get_pgrp_status(Pgrp_Info * pgrp);

uint16_t
PGC_Probe_Exec_Pgrp(Probe_Header * header, char * packet)
{
	char * func = "PGC_Probe_Exec_Pgrp()";
	Pgrp_Info * pgrp_key = NULL;
	Pgrp_Info * pgrp = NULL;
	uint16_t status = DATA_ERR;
	Exec_Info exec;
	char * exec_result = NULL;
	int i = 0;

	if ((header == NULL ) || (packet == NULL) || (PgrpTbl == NULL))
	{
		show_error("%s: table is not allocated",func);
		return DATA_ERR;
	}
	if (ntohl(header->body_length) < sizeof(Pgrp_Info))
	{
		show_error("%s: there is no packet data ",func);
		return DATA_ERR;
	}
	pgrp_key = (Pgrp_Info *) packet;
	pgrp = PGC_Get_PgrpTbl_Rec(pgrp_key);
	if (pgrp == NULL)
	{
		show_error("%s: there is no such pgrp in PgrpTbl",func);
		return DATA_ERR;
	}
	set_pgrp_2_exec(&exec, pgrp);
	switch (ntohs(header->packet_no))
	{
		case START_REQ_PKT:
			i = 0;
			strcpy(exec.options[i++],"start");
			exec.options[i++][0] = '\0';
			exec_result = PGC_Exec_Server(&exec);
			show_debug("%s: PGC_Exec_Server[%s] end",func,exec_result);
			if (exec_result != NULL)
				status = DATA_USE;
			break;
		case STOP_REQ_PKT:
			i = 0;
			strcpy(exec.options[i++],"stop");
			exec.options[i++][0] = '\0';
			exec_result = PGC_Exec_Server(&exec);
			if (exec_result != NULL)
				status = DATA_USE;
			break;
		case RECOVERY_REQ_PKT:
			i = 0;
			strcpy(exec.options[i++],"stop");
			exec.options[i++][0] = '\0';
			exec_result = PGC_Exec_Server(&exec);
			i = 0;
			strcpy(exec.options[i++],"start");
			exec.options[i++][0] = '\0';
			exec_result = PGC_Exec_Server(&exec);
			if (exec_result != NULL)
				status = DATA_USE;
			break;
		case STATUS_REQ_PKT:
			status = get_pgrp_status(pgrp);
			break;
		default :
			break;
	}
	return status;
}

static int16_t
get_pgrp_status(Pgrp_Info * pgrp)
{
	char * func = "get_pgrp_status()";
	FILE *fd;
	char fname[256];
	char pidbuf[128];
	pid_t pid;
	int16_t status = DATA_INIT;

	if (pgrp == NULL)
	{
		return DATA_ERR;
	}
	snprintf(fname, sizeof(fname), "%s/%s", pgrp->workPath, PGREPLICATE_PID_FILE);
	fd = fopen(fname, "r");
	if (!fd)
	{
		show_error("%s:could not open pid file as %s. reason: %s",
				   func,fname, strerror(errno));
		return DATA_ERR;
	}
	memset(pidbuf,0,sizeof(pidbuf));
	fread(pidbuf, sizeof(pidbuf), 1, fd);
	fclose(fd);
	pid = atoi(pidbuf);

	if (kill (pid,0) == 0)
	{
		status = DATA_USE;
	}
	else
	{
		status = DATA_ERR;
	}
	return status;
}

static int
set_pgrp_2_exec(Exec_Info * exec, Pgrp_Info *pgrp)
{
	if ((exec == NULL) || (pgrp == NULL))
	{
		return STATUS_ERROR;
	}
	memset(exec, 0, sizeof(Exec_Info));
	exec->portNumber = pgrp->replicationPortNumber;
	strncpy(exec->workPath, pgrp->workPath, sizeof(exec->workPath));
	strncpy(exec->binPath, pgrp->binPath, sizeof(exec->binPath));
	strcpy(exec->command,"pgreplicate");

	return STATUS_OK;
}
