/*--------------------------------------------------------------------
 * FILE:
 *     admin_set_pgrp_status.c
 *
 * NOTE:
 *     This file is composed of the admin process 
 *     Low level I/O functions that called by in these functions are 
 *     contained in 'replicate_com.c'.
 *
 *--------------------------------------------------------------------
 */
#include "postgres.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/file.h>

#ifdef MULTIBYTE
#include "mb/pg_wchar.h"
#endif

#include "pgc_admin.h"

int PGC_Admin_Set_Pgrp_Status(Probe_Header * header, char * packet);
int PGC_Sync_Status_Pgrp(Pgrp_Info * pgrp);

static int set_pgrp_status(HostTbl * cluster);

int
PGC_Admin_Set_Pgrp_Status(Probe_Header * header, char * packet)
{
	char * func = "PGC_Admin_Set_Pgrp_Status()";
	int count = 0;
	int status = STATUS_ERROR;
	HostTbl cluster;
	char * p = NULL;
	int size = 0;
	Pgrp_Info pgrp_key;
	Pgrp_Info * pgrp = NULL;

	if ((header == NULL ) || (packet == NULL))
	{
		show_error("%s: table is not allocated",func);
		return STATUS_ERROR;
	}
	if (ntohl(header->body_length) < sizeof(Pgrp_Info))
	{
		show_error("%s: there is no packet data ",func);
		return STATUS_ERROR;
	}
	
	/* set status of pgrp */
	PGC_Set_Packet_2_Pgrp_Info(&pgrp_key, (Pgrp_Info *)packet);
	pgrp = PGC_Get_PgrpTbl_Rec(&pgrp_key);
	if (pgrp != NULL)
	{
		pgrp->receiveStatus |= pgrp_key.status;
		status =  STATUS_OK;
	}
	size = sizeof(HostTbl);
	p = packet + sizeof(Pgrp_Info);
	/* set status of cluster in pgrp */
	count = 0;
	while (count < ntohl(header->rec_num))
	{
		memset(&cluster, 0, size);
		PGC_Set_Packet_2_HostTbl(&cluster,(HostTbl*)p); 
		status = set_pgrp_status(&cluster);
		count ++;
		p += sizeof(HostTbl);
	}
	return status;
}

int
PGC_Sync_Status_Pgrp(Pgrp_Info * pgrp)
{
	char * func ="PGC_Sync_Status_Pgrp()";
	Probe_Header r_header;
	Probe_Header h_data;
	Pgrp_Info body;
	int status = STATUS_OK;
	SSL_Info ssl_tbl;
	SSL_Server_Info * probe = ProbeTbl;

	if (probe == NULL)
	{
		show_error("%s:ProbeTbl is NULL",func);
		return STATUS_ERROR;
	}

	if (pgrp == NULL)
	{
		show_error("%s: pgrp info is null",func);
		return STATUS_ERROR;
	}
	memset(&h_data, 0, sizeof(Probe_Header));
	memset(&r_header, 0, sizeof(Probe_Header));
	memset(&body, 0, sizeof(Pgrp_Info));
	memset(&ssl_tbl, 0, sizeof(SSL_Info));

	h_data.packet_no = SET_STS_REQ_PKT;
	h_data.serverType = SERVER_TYPE_PGRP;
	h_data.body_length = sizeof(Pgrp_Info);
	h_data.rec_num = 1;
	PGC_Set_Pgrp_Info_2_packet(&body, pgrp);
	while (probe->status != DATA_END)
	{
		PGC_Set_Packet_Header(&r_header, &h_data);
		status = PGC_Admin_Send_Packet(&ssl_tbl, &r_header, (char *)&body, probe->physicalServerId);
		if (status == STATUS_OK)
		{
			PGC_Response_Receive(&ssl_tbl, &r_header);
			PGC_Close_SSL(&ssl_tbl);
		}
		probe ++;
	}
	PGC_Close_SSL(&ssl_tbl);
	return status;
}

static int
set_pgrp_status(HostTbl * cluster)
{
	Cluster_Info * ptr = NULL;
	if (ClusterDbTbl == NULL)
	{
		show_error("ClusterDbTbl is null");
		return STATUS_ERROR;
	}
	ptr = ClusterDbTbl;
	while (ptr->portNumber != 0)
	{
		if ((!strncmp(ptr->hostName, cluster->resolvedName, sizeof(ptr->hostName))) &&
			(ptr->portNumber == cluster->port))
		{
			/* find cluster data */
			ptr->receiveStatus |= cluster->useFlag;
			break;
		}
		ptr ++;
	}
	return STATUS_OK;
}
