.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "SPI_execp" "" "2008-01-03" "" "PostgreSQL 7.4.19 Documentation"
.SH NAME
SPI_execp \- executes a plan prepared by SPI_prepare

.SH SYNOPSIS
.sp
.nf
int SPI_execp(void * \fIplan\fR, Datum * \fIvalues\fR, const char * \fInulls\fR, int \fIcount\fR)
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBSPI_execp\fR executes a plan prepared by
\fBSPI_prepare\fR. \fItcount\fR
has the same interpretation as in \fBSPI_exec\fR.
.SH "ARGUMENTS"
.TP
\fBvoid * \fIplan\fB\fR
execution plan (returned by \fBSPI_prepare\fR)
.TP
\fBDatum *\fIvalues\fB\fR
actual parameter values
.TP
\fBconst char * \fInulls\fB\fR
An array describing which parameters are null.
n indicates a null value (entry in
\fIvalues\fR will be ignored); a space indicates a
nonnull value (entry in \fIvalues\fR is valid).

If \fInulls\fR is \fBNULL\fR then
\fBSPI_execp\fR assumes that no parameters are
null.
.TP
\fBint \fIcount\fB\fR
number of row for which plan is to be executed
.SH "RETURN VALUE"
.PP
The return value is the same as for \fBSPI_exec\fR
or one of the following:
.TP
\fBSPI_ERROR_ARGUMENT\fR
if \fIplan\fR is \fBNULL\fR or
\fIcount\fR is less than 0
.TP
\fBSPI_ERROR_PARAM\fR
if \fIvalues\fR is \fBNULL\fR and
\fIplan\fR was prepared with some parameters
.PP
.PP
SPI_processed and
SPI_tuptable are set as in
\fBSPI_exec\fR if successful.
.SH "NOTES"
.PP
If one of the objects (a table, function, etc.) referenced by the
prepared plan is dropped during the session then the result of
\fBSPI_execp\fR for this plan will be unpredictable.
