#include "connection.h"
#include "statement.h"
#include "protocol.h"
#include "resource.h"
#include "error.h"
//#include "common.h"

const int c_FIELD_NULL = FIELD_NULL;


const TCHAR c_szDriverODBCVer[6]  = _T("03.51");
const TCHAR c_szODBC_INI[]        = _T("ODBC.INI");
const TCHAR c_szDriverName[]      = _T("Mammoth ODBCng Alpha");  /* driver name */
const TCHAR c_szDBMSVersion[12]   = _T("00.00.0000 ");           /* mask for the DBMS version */
const TCHAR c_szDriverVersion[17] = _T("01.00.0000 alpha");      /* driver version */
const TCHAR c_szKeyWords[]        = _T("");
const TCHAR c_szSpecialCharacter[]= _T("_");

#ifdef WIN32
	const TCHAR c_szDriverFileName[10] = _T("modbc.dll");
#else
	const TCHAR c_szDriverFileName[12] = _T("libmodbc.so");
#endif /* WIN32 */

/* bookmark column data */
const TCHAR c_szBookmarkName[]           = _T("bookmark");  /* name of bookmark column */
const SQLUINTEGER c_nBookmarkDisplaySize = 20;

/*-------------------------------------------------------------------------------------------------
 * Column names and types for SQLTables, SQLColumns, SQLStatistics, SQLGetTypeInfo, SQLProcedures
 *-------------------------------------------------------------------------------------------------
 */
const ColumnNameType c_ProceduresColumns[8] = {
	{_T("PROCEDURE_CAT"),     PTN_VARCHAR},
	{_T("PROCEDURE_SCHEM"),   PTN_VARCHAR},
	{_T("PROCEDURE_NAME"),    PTN_VARCHAR},
	{_T("NUM_INPUT_PARAMS"),  PTN_VARCHAR},
	{_T("NUM_OUTPUT_PARAMS"), PTN_VARCHAR},
	{_T("NUM_RESULT_SETS"),   PTN_VARCHAR},
	{_T("REMARKS"),           PTN_VARCHAR},
	{_T("PROCEDURE_TYPE"),    PTN_INT4}
};

const ColumnNameType c_StatisticsColumns[13] = {
	{_T("TABLE_CAT"),        PTN_VARCHAR},
	{_T("TABLE_SCHEM"),      PTN_VARCHAR},
	{_T("TABLE_NAME"),       PTN_VARCHAR},
	{_T("NON_UNIQUE"),       PTN_INT2},
	{_T("INDEX_QUALIFIER"),  PTN_VARCHAR},
	{_T("INDEX_NAME"),       PTN_VARCHAR},
	{_T("TYPE"),             PTN_INT2},
	{_T("ORDINAL_POSITION"), PTN_INT2},
	{_T("COLUMN_NAME"),      PTN_VARCHAR},
	{_T("ASC_OR_DESC"),      PTN_CHAR},
	{_T("CARDINALITY"),      PTN_INT4},
	{_T("PAGES"),            PTN_INT4},
	{_T("FILTER_CONDITION"), PTN_VARCHAR}
};

const ColumnNameType c_GetTypeInfoColumns[19] = {
	{_T("TYPE_NAME"),          PTN_VARCHAR},
	{_T("DATA_TYPE"),          PTN_INT2},
	{_T("COLUMN_SIZE"),        PTN_INT4},
	{_T("LITERAL_PREFIX"),     PTN_VARCHAR},
	{_T("LITERAL_SUFFIX"),     PTN_VARCHAR},
	{_T("CREATE_PARAMS"),      PTN_VARCHAR},
	{_T("NULLABLE"),           PTN_INT2},
	{_T("CASE_SENSITIVE"),     PTN_INT2},
	{_T("SEARCHABLE"),         PTN_INT2},
	{_T("UNSIGNED_ATTRIBUTE"), PTN_INT2},
	{_T("FIXED_PREC_SCALE"),   PTN_INT2},
	{_T("AUTO_UNIQUE_VALUE"),  PTN_INT2},
	{_T("LOCAL_TYPE_NAME"),    PTN_VARCHAR},
	{_T("MINIMUM_SCALE"),      PTN_INT2},
	{_T("MAXIMUM_SCALE"),      PTN_INT2},
	{_T("SQL_DATA_TYPE"),      PTN_INT2},
	{_T("SQL_DATETIME_SUB"),   PTN_INT2},
	{_T("NUM_PREC_RADIX"),     PTN_INT4},
	{_T("INTERVAL_PRECISION"), PTN_INT2},
};

const ColumnNameType c_SpecialColumnsColumns[8] = {
	{_T("SCOPE"),          PTN_INT2},
	{_T("COLUMN_NAME"),    PTN_VARCHAR},
	{_T("DATA_TYPE"),      PTN_INT2},
	{_T("TYPE_NAME"),      PTN_VARCHAR},
	{_T("COLUMN_SIZE"),    PTN_INT4},
	{_T("BUFFER_LENGTH"),  PTN_INT4},
	{_T("DECIMAL_DIGITS"), PTN_INT2},
	{_T("PSEUDO_COLUMN"),  PTN_INT2}
};

const ColumnNameType c_TablesColumns[5] = {
	{_T("TABLE_CAT"),   PTN_VARCHAR},
	{_T("TABLE_SCHEM"), PTN_VARCHAR},
	{_T("TABLE_NAME"),  PTN_VARCHAR},
	{_T("TABLE_TYPE"),  PTN_VARCHAR},
	{_T("REMARKS"),     PTN_VARCHAR}
};

const ColumnNameType c_ColumnsColumns[18] = {
	{_T("TABLE_CAT"),         PTN_VARCHAR},
	{_T("TABLE_SCHEM"),       PTN_VARCHAR},
	{_T("TABLE_NAME"),        PTN_VARCHAR},
	{_T("COLUMN_NAME"),       PTN_VARCHAR},
	{_T("DATA_TYPE"),         PTN_INT2},
	{_T("TYPE_NAME"),         PTN_VARCHAR},
	{_T("COLUMN_SIZE"),       PTN_INT4},
	{_T("BUFFER_LENGTH"),     PTN_INT4},
	{_T("DECIMAL_DIGITS"),    PTN_INT2},
	{_T("NUM_PREC_RADIX"),    PTN_INT2},
	{_T("NULLABLE"),          PTN_INT2},
	{_T("REMARKS"),           PTN_VARCHAR},
	{_T("COLUMN_DEF"),        PTN_VARCHAR},
	{_T("SQL_DATA_TYPE"),     PTN_INT2},
	{_T("SQL_DATETIME_SUB"),  PTN_INT2},
	/* ODBC v.3.0 */
	{_T("CHAR_OCTET_LENGTH"), PTN_INT4},
	{_T("ORDINAL_POSITION"),  PTN_INT4},
	{_T("IS_NULLABLE"),       PTN_VARCHAR}
};

const ColumnNameType c_PrimaryKeysColumns[6] = {
	{_T("TABLE_CAT"),         PTN_VARCHAR},
	{_T("TABLE_SCHEM"),       PTN_VARCHAR},
	{_T("TABLE_NAME"),        PTN_VARCHAR},
	{_T("COLUMN_NAME"),       PTN_VARCHAR},
	{_T("KEY_SEQ"),           PTN_INT2},
	{_T("PK_NAME"),           PTN_VARCHAR}
};

const ColumnNameType c_ProcedureColumnsColumns[19] = {
	{_T("PROCEDURE_CAT"),     PTN_VARCHAR},
	{_T("PROCEDURE_SCHEM"),   PTN_VARCHAR},
	{_T("PROCEDURE_NAME"),    PTN_VARCHAR},
	{_T("COLUMN_NAME"),       PTN_VARCHAR},
	{_T("COLUMN_TYPE"),       PTN_INT2},
	{_T("DATA_TYPE"),         PTN_INT2},
	{_T("TYPE_NAME"),         PTN_VARCHAR},
	{_T("COLUMN_SIZE"),       PTN_INT4},
	{_T("BUFFER_LENGTH"),     PTN_INT4},
	{_T("DECIMAL_DIGITS"),    PTN_INT2},
	{_T("NUM_PREC_RADIX"),    PTN_INT2},
	{_T("NULLABLE"),          PTN_INT2},
	{_T("REMARKS"),           PTN_VARCHAR},
	{_T("COLUMN_DEF"),        PTN_VARCHAR},
	{_T("SQL_DATA_TYPE"),     PTN_INT2},
	{_T("SQL_DATETIME_SUB"),  PTN_INT2},
	{_T("CHAR_OCTET_LENGTH"), PTN_INT4},
	{_T("ORDINAL_POSITION"),  PTN_INT4},
	{_T("IS_NULLABLE"),       PTN_VARCHAR}
};

const ColumnNameType c_ForeignKeysColumns[14] = {
	{_T("PKTABLE_CAT"),       PTN_VARCHAR},
	{_T("PKTABLE_SCHEM"),     PTN_VARCHAR},
	{_T("PKTABLE_NAME"),      PTN_VARCHAR},
	{_T("PKCOLUMN_NAME"),     PTN_VARCHAR},
	{_T("FKTABLE_CAT"),       PTN_VARCHAR},
	{_T("FKTABLE_SCHEM"),     PTN_VARCHAR},
	{_T("FKTABLE_NAME"),      PTN_VARCHAR},
	{_T("FKCOLUMN_NAME"),     PTN_VARCHAR},
	{_T("KEY_SEQ"),           PTN_INT2},
	{_T("UPDATE_RULE"),       PTN_INT2},
	{_T("DELETE_RULE"),       PTN_INT2},
	{_T("FK_NAME"),           PTN_VARCHAR},
	{_T("PK_NAME"),           PTN_VARCHAR},
	{_T("DEFERRABILITY"),     PTN_INT2}
};

const ColumnNameType c_TablePrivilegesColumns[7] = {
	{_T("TABLE_CAT"),         PTN_VARCHAR},
	{_T("TABLE_SCHEM"),       PTN_VARCHAR},
	{_T("TABLE_NAME"),        PTN_VARCHAR},
	{_T("GRANTOR"),           PTN_VARCHAR},
	{_T("GRANTEE"),           PTN_VARCHAR},
	{_T("PRIVILEGE"),         PTN_VARCHAR},
	{_T("IS_GRANTABLE"),      PTN_VARCHAR}
};

const ColumnNameType c_ColumnPrivilegesColumns[8] = {
	{_T("TABLE_CAT"),         PTN_VARCHAR},
	{_T("TABLE_SCHEM"),       PTN_VARCHAR},
	{_T("TABLE_NAME"),        PTN_VARCHAR},
	{_T("COLUMN_NAME"),       PTN_VARCHAR},
	{_T("GRANTOR"),           PTN_VARCHAR},
	{_T("GRANTEE"),           PTN_VARCHAR},
	{_T("PRIVILEGE"),         PTN_VARCHAR},
	{_T("IS_GRANTABLE"),      PTN_VARCHAR}
};

/*-------------------------------------------------------------------------------------------------
 * PostgreSQL data types
 *
 * WARNING! Do not change the order of this strings
 * Types are ordered by closeness to the SQL type identifier's definition
 *-------------------------------------------------------------------------------------------------
 */
const PostgreSQLDataType c_PostgreSQLDataTypes[] = {
	/* exect numeric data types */
	{_T("smallint"),          _T("int2"),        SQL_SMALLINT,         21, 0, 1, 2,          5, NULL},
	{_T("smallint"),          _T("int2"),        SQL_TINYINT,          21, 0, 1, 2,          3, NULL},
	{_T("integer"),           _T("int4"),        SQL_INTEGER,          23, 0, 1, 2,         10, NULL},
	{_T("bigint"),            _T("int8"),        SQL_BIGINT,           20, 0, 1, 2,         20, NULL},

	/* autoincrementing numeric */
	{_T("serial"),            _T("serial4"),     SQL_SMALLINT,         23, 1, 2, 1,         10, NULL},
	{_T("bigserial"),         _T("serial8"),     SQL_BIGINT,           20, 1, 2, 1,         20, NULL},

	/* exact numeric of selectable precision */
	{_T("numeric"),           _T("numeric"),     SQL_NUMERIC,        1700, 0, 1, 2,         28, _T("precision,scale")},
	{_T("numeric"),           _T("numeric"),     SQL_DECIMAL,        1700, 0, 1, 2,         28, _T("precision,scale")},

	/* floating-point numbers */
	{_T("real"),              _T("float4"),      SQL_REAL,            700, 0, 1, 2,          7, NULL},
	{_T("double precision"),  _T("float8"),	     SQL_DOUBLE,          701, 0, 1, 2,         15, NULL},
	{_T("double precision"),  _T("float8"),	     SQL_FLOAT,           701, 0, 1, 2,         15, NULL},
	
	/* character types */
	{_T("character"),         _T("bpchar"),      SQL_CHAR,           1042, 0, 1, 0,       1024, _T("length")},
	{_T("character"),         _T("bpchar"),      SQL_WCHAR,          1042, 0, 1, 0,       1024, _T("length")},
	{_T("char"),              _T("char"),        SQL_CHAR,             18, 0, 1, 0,       1024, NULL},
	{_T("char"),              _T("char"),        SQL_WCHAR,            18, 0, 1, 0,       1024, NULL},
	{_T("character varying"), _T("varchar"),     SQL_VARCHAR,        1043, 0, 1, 0,       8190, _T("length")},
	{_T("character varying"), _T("varchar"),     SQL_WVARCHAR,       1043, 0, 1, 0,       8190, _T("length")},
	{_T("name"),              _T("name"),        SQL_VARCHAR,          19, 0, 1, 0,         63, NULL},
	{_T("name"),              _T("name"),        SQL_WVARCHAR,         19, 0, 1, 0,         31, NULL},
	{_T("text"),              _T("text"),        SQL_LONGVARCHAR,      25, 0, 1, 0,      65535, NULL},
	{_T("text"),              _T("text"),        SQL_WLONGVARCHAR,     25, 0, 1, 0,      65535, NULL},

	/* binary types */
	{_T("bytea"),             _T("bytea"),       SQL_BINARY,           17, 0, 1, 0,       1024, _T("length")},
	{_T("bytea"),             _T("bytea"),       SQL_VARBINARY,        17, 0, 1, 0,       1024, _T("length")},
	{_T("bytea"),             _T("bytea"),       SQL_LONGVARBINARY,    17, 0, 1, 0,      65535, NULL},
	
	/* date and time types */
	{_T("date"),              _T("date"),        SQL_TYPE_DATE,      1082, 0, 1, 0,         10, NULL},
	{_T("date"),              _T("date"),        SQL_DATE,           1082, 0, 1, 0,         10, NULL},

	{_T("timetz"),            _T("timetz"),      SQL_TYPE_TIME,      1266, 0, 1, 0,         22, _T("precision")},
	{_T("time"),              _T("time"),        SQL_TYPE_TIME,      1083, 0, 1, 0,         19, _T("precision")},
	{_T("timetz"),            _T("timetz"),      SQL_TIME,           1266, 0, 1, 0,         22, _T("precision")},
	{_T("time"),              _T("time"),        SQL_TIME,           1083, 0, 1, 0,         19, _T("precision")},

	{_T("timestamptz"),       _T("timestamptz"), SQL_TYPE_TIMESTAMP, 1184, 0, 1, 0,         33, _T("precision")},
	{_T("timestamp"),         _T("timestamp"),   SQL_TYPE_TIMESTAMP, 1114, 0, 1, 0,         30, _T("precision")},
	{_T("timestamptz"),       _T("timestamptz"), SQL_TIMESTAMP,      1184, 0, 1, 0,         33, _T("precision")},
	{_T("timestamp"),         _T("timestamp"),   SQL_TIMESTAMP,      1114, 0, 1, 0,         30, _T("precision")},

	/* interval types */
	{_T("interval"),          _T("interval"),    SQL_INTERVAL,       1186, 0, 1, 0,        255, _T("precision")},

	/* boolean types */
	{_T("boolean"),           _T("bool"),        SQL_BIT,              16, 0, 1, 0,          1, NULL},
	{_T("char"),              _T("char"),        SQL_BIT,              16, 0, 1, 0,          1, NULL},


	/* PostgreSQL specific types */
	{_T("box"),               _T("box"),         SQL_UNKNOWN_TYPE,    603, 0, 1, 0,          0, NULL},
	{_T("cidr"),              _T("cidr"),        SQL_UNKNOWN_TYPE,    650, 0, 1, 0,          0, NULL},
	{_T("circle"),            _T("circle"),      SQL_UNKNOWN_TYPE,    718, 0, 1, 0,          0, NULL},
	{_T("inet"),              _T("inet"),        SQL_UNKNOWN_TYPE,    869, 0, 1, 0,          0, NULL},
	{_T("line"),              _T("line"),        SQL_UNKNOWN_TYPE,    628, 0, 1, 0,          0, NULL},
	{_T("lseg"),              _T("lseg"),        SQL_UNKNOWN_TYPE,    601, 0, 1, 0,          0, NULL},
	{_T("macaddr"),           _T("macaddr"),     SQL_UNKNOWN_TYPE,    829, 0, 1, 0,          0, NULL},
	{_T("money"),             _T("money"),       SQL_UNKNOWN_TYPE,    790, 0, 1, 0,          0, NULL},
	{_T("path"),              _T("path"),        SQL_UNKNOWN_TYPE,    602, 0, 1, 0,          0, NULL},
	{_T("point"),             _T("point"),       SQL_UNKNOWN_TYPE,    600, 0, 1, 0,          0, NULL},
	{_T("polygon"),           _T("polygon"),     SQL_UNKNOWN_TYPE,    604, 0, 1, 0,          0, NULL},
	{_T("smgr"),              _T("smgr"),        SQL_UNKNOWN_TYPE,    210, 0, 1, 0,          0, NULL},

	/* special types */
	{_T("oid"),               _T("oid"),         SQL_INTEGER,          26, 1, 2, 2,          0, NULL},

	/* WARNING! This must be always the last record */
	{_T("unknown"),           _T("unknown"),     SQL_UNKNOWN_TYPE,    705, 0, 1, 0,          0, NULL}
};

/* List of all parameters in Data Source */
const DSParameter c_stDSParameters[DS_PARAMETERS_NUMBER] = {
	/* EDIT box parameters */
	{_T("DESCRIPTION"),     _T("DSN description"),    _T(""),          DESCRIPTION_MAX_LENGTH,    IDE_DESCRIPTION},     /* DESCRIPTION_PARAM    = 0 */
	/* can be used in Connection String */
	{_T("UID"),             _T("user ID"),            _T(""),          UID_MAX_LENGTH,            IDE_UID},             /* UID_PARAM            = 1 */	
	{_T("SERVER"),          _T("server"),             _T("localhost"), SERVER_MAX_LENGTH,         IDE_SERVER},          /* SERVER_PARAM         = 2 */
	{_T("DATABASE"),        _T("database"),           _T(""),          DATABASE_MAX_LENGTH,       IDE_DATABASE},        /* DATABASE_PARAM       = 3 */
	{_T("PWD"),             _T("password"),           _T(""),          PWD_MAX_LENGTH,            IDE_PWD},             /* PWD_PARAM            = 4 */
  /* EDIT box numeric parameters */
	{_T("PORT"),            _T("port"),               _T("5432"),      PORT_MAX_LENGTH,           IDE_PORT},            /* PORT_PARAM           = 5 */
	{_T("CONNECT_TIMEOUT"), _T("connection timeout"), _T(""),          CONNECTTIMEOUT_MAX_LENGTH, IDE_CONNECT_TIMEOUT}, /* CONNECTTIMEOUT_PARAM = 6 */
	/* CHECK BOX parameters */
	{_T("USE_SSL"),         _T("prefer SSL?"),        _T("N"),         USESSL_MAX_LENGTH,         IDC_USE_SSL},         /* USESSL_PARAM         = 7 */
	{_T("USE_BUFFERING"),   _T("buffer results?"),    _T("Y"),         USEBUFFERING_MAX_LENGTH,   IDC_USE_BUFFERING}    /* USEBUFFERING_PARAM   = 8 */
};

/*-------------------------------------------------------------------------------------------------
 * WARNING! Do not change the order of this strings
 *
 * '?' means parameter
 *-------------------------------------------------------------------------------------------------
 */
const Error c_Errors[] = {
	{_T(""), _T(""), 0},
	{_T("08001"), _T("Unknown host: ?:?."),                            1},  /* ERR_UNKNOWN_HOST                 =  1 */
	{_T("08001"), _T("Unable to connect: ?:?."),                       2},  /* ERR_CANT_CONNECT_TO_HOST         =  2 */
	{_T("01004"), _T("Too small buffer, ? was truncated."),            3},  /* ERR_TOO_SMALL_BUFFER             =  3 */
	{_T("24000"), _T("No cursor was opened."),                         4},  /* ERR_STMT_INVALID_CURSOR_STATE    =  4 */
	{_T("01S00"), _T("Unknown attribute in connection string: ?=?."),  5},  /* ERR_DBC_UNKNOWN_KEY              =  5 */
	{_T("HY012"), _T("Invalid transaction operation code."),           6},  /* ERR_INVALID_TRANS_OP_CODE        =  6 */
	{_T("HY092"), _T("Invalid handle type."),                          7},  /* ERR_INVALID_HANDLE_TYPE          =  7 */
	{_T("HY000"), _T("Cursor '?' already declared."),                  8},  /* ERR_STMT_CURSOR_DECLARED         =  8 */
	{_T("HY015"), _T("No cursor name avaible."),                       9},  /* ERR_STMT_NO_CURSOR_AVAIBLE       =  9 */
	{_T("HY015"), _T("Cursor already declared as '?'."),              10},  /* ERR_STMT_CURSOR_ALREADY_DECLARED = 10 */
	{_T("34000"), _T("Invalid cursor name."),                         11},  /* ERR_STMT_INVALID_CURSOR_NAME     = 11 */
	{_T("3C000"), _T("Cursor name already exists."),                  12},  /* ERR_STMT_CURSOR_NAME_IN_USE      = 12 */
	{_T("07009"), _T("ColumnNumber was greater than the number of columns in the result set."),
	                                                                  13},  /* ERR_STMT_COLUMN_NUMBER_TOO_BIG   = 13 */
	{_T("28000"), _T("Invalid login or password."),                   14},  /* ERR_DBC_INVALID_LOGIN_DATA       = 14 */
	{_T("01000"), _T("Statement wasn't prepare."),                    15},  /* ERR_STMT_NOT_PREPARED            = 15 */
	{_T("01000"), _T("Null buffer pointer."),                         16},  /* ERR_NULL_POINTER_BUFFER          = 16 */
	{_T("01000"), _T("Unknown attribute."),                           17},  /* ERR_UNKNOWN_ATTRIBUTE            = 17 */
	{_T("HY000"), _T("?"),                                            18},  /* ERR_SERVER_ERROR                 = 18 */
	{_T("01000"), _T("Statement '?' already declared."),              19},  /* ERR_STMT_STATEMENT_DECLARED      = 19 */
	{_T("01000"), _T("Not a SELECT, INSERT, DELETE or UPDATE query"), 20},  /* ERR_STMT_INVALID_STATE           = 20 */
	{_T("01000"), _T("In non-buffering mode it's impossible to determine the number of resulted rows."),
	                                                          21},  /* ERR_STMT_ROW_COUNT_UNAVAIBLE     = 21 */
	{_T("HY000"), _T("SQL_ATTR_USE_BOOKMARKS is set to SQL_UB_OFF. Change this it you want to use bookmark."),
	                                                          22},  /* ERR_STMT_BOOKMARKS_UNUSED        = 22 */
	{_T("HY001"), _T("Not enough memory."),                           23},  /* ERR_NOT_ENOUGH_MEMORY            = 23 */
	{_T("HY016"), _T("Can't modify an implementation row descriptor."),
	                                                          24},  /* ERR_DESC_CANT_MODIFY_IRD         = 24 */
	{_T("HY021"), _T("Inconsistent descriptor information."),         25},  /* ERR_DESC_INCONSISTENT_INFO       = 25 */
	{_T("HY024"), _T("Descriptor handle wasn't allocated not on the same connection as statement"),
	                                                          26},  /* ERR_STMT_DESC_WRONG_CONNECTION   = 26 */
	{_T("HY017"), _T("Cannot set implicitly allocated descriptor."),  27},  /* ERR_STMT_DESC_WRONG_ALLOC_TYPE   = 27 */
	{_T("07002"), _T("Not all parameters were bind by application."), 28},  /* ERR_STMT_NOT_ENOUGH_PARAMETERS   = 28 */
	{_T("07009"), _T("No parameter with number ? bound."),            29},  /* ERR_STMT_PARAM_NUMBER_NOT_BINDED = 29 */
	{_T("HY000"), _T("No valid table types were specified in '?'."),  30},  /* ERR_STMT_NO_VALID_TABLE_TYPES    = 30 */
	{_T("01000"), _T("This attribute is read only!"),                 31},  /* ERR_READONLY_ATTRIBUTE           = 31 */
	{_T("HY016"), _T("Can't set specified field in this descriptor."),
	                                                          32},  /* ERR_DESC_INVALID_FIELD           = 32 */
	{_T("07009"), _T("Cannot modify 0 record of a parameter descriptor."),
	                                                          33},  /* ERR_DESC_MODIFY_ZERO_REC_IN_PD   = 33 */
	{_T("07009"), _T("Cannot read 0 record of a parameter descriptor."),
	                                                          34},  /* ERR_DESC_READ_ZERO_REC_IN_PD     = 34 */
	{_T("HY091"), _T("This field is READ-ONLY!"),                     35},  /* ERR_DESC_READ_ONLY_FIELD         = 35 */
	{_T("HY091"), _T("Unknown field identifier."),                    36},  /* ERR_DESC_UNKNOWN_FIELD           = 36 */
	{_T("HY092"), _T("You can't set SQL_DESC_UNNAMED to SQL_NAMED."), 37},  /* ERR_DESC_CANT_SET_NAMED          = 37 */
	{_T("01000"), _T("Empty query has been sent to server and server successfully processed it."),
	                                                          38},  /* ERR_STMT_EMPTY_QUERY             = 38 */
	{_T("01000"), _T("Error occured while sending parameters to the server."), 
	                                                          39},  /* ERR_STMT_CANT_BIND_PARAMETERS    = 39 */
	{_T("01000"), _T("'?' can't be a NULL pointer or empty string."), 40},  /* ERR_EMPTY_STRING                 = 40 */
	{_T("01000"), _T("This driver version does not allow to change current catalog"),
	                                                          41},  /* ERR_CONN_USE_UNSUPPORTED         = 41 */
	{_T("01000"), _T("Bad query syntax."),                    42},   /* ERR_BAD_QUERY_SYNTAX             = 42 */
	{_T("01000"), _T("Cannot begin transaction."),            43},   /* ERR_CANT_BEGIN_TRANSACTION       = 43 */
	{_T("01000"), _T("Cannot ? transaction."),                44},   /* ERR_CANT_CLOSE_TRANSACTION       = 44 */
	{_T("01000"), _T("Cannot execute statement."),            45},   /* ERR_STMT_CANT_EXECUTE            = 45 */
	{_T("01000"), _T("Key '?' can't be set to '?' (previously set value is '?')."),
	                                                          46},   /* ERR_DBC_KEY_ALREADY_SET          = 46 */
	{_T("HY092"), _T("Unknown operation requested."),         47},   /* ERR_INVALID_BULK_OPERATION       = 47 */
	{_T("01000"), _T("Unable to make insert in different tables or views."), 48}, /* ERR_BULK_DIFFERENT_TABLES        = 48 */
	{_T("01000"), _T("There is no columns to ?."),            49},   /* ERR_BULK_NO_COLUMNS_TO       = 49 */
	{_T("22001"), _T("Reserved buffer was less then data length, value was right-truncated."), 50}  /* ERR_PUTPARAM_TRUNCATED_DATA  = 50 */
};