#ifndef __COMMON__
#define __COMMON__

#include "odbc.h"
#include <stdarg.h>

#ifndef WIN32
	#include "tchar.h"
/*	#ifdef UNICODE
        	#define _T(x) L ## x
	#else
        	#define _T(x) x
	#endif
*/
#endif

typedef struct _list List;
typedef struct _item Item;

#define LIST_ITEMS_NUMBER          10

struct _list
{
	/* head = 0      index in array
	   tail = used-1       -//-
	 */
	
	SQLHANDLE* handles;
	int        allocated;
	int        used;
};

SQLRETURN AddItem(List* pList, SQLHANDLE Handle); 
SQLRETURN RemoveItem(List* pList, SQLHANDLE Handle); 
SQLRETURN FreeList(List* pList, SQLSMALLINT HandleType, SQLUSMALLINT Option);

SQLRETURN ReturnString(SQLTCHAR* TargetValue, SQLSMALLINT TargetLength, SQLSMALLINT* SourceLength, const SQLTCHAR* SourceValue, SQLSMALLINT nSourceLength);

SQLINTEGER FillBufferWithValue(SQLPOINTER TargetValue, SQLINTEGER TargetLength, SQLSMALLINT TargetType, SQLPOINTER SourceValue, SQLINTEGER SourceLength, SQLSMALLINT SourceType);
SQLRETURN  PrepareConnectionString(SQLTCHAR* TargetValue, SQLSMALLINT TargetLength, SQLSMALLINT* SourceLength, const TCHAR** parameters, SQLTCHAR* dsn);
SQLRETURN  PrepareConnectionStringRequest(SQLTCHAR* TargetValue, SQLSMALLINT TargetLength, SQLSMALLINT* SourceLength, const TCHAR** parameters);

SQLINTEGER GetDisplaySizeForSQLType(SQLSMALLINT type, SQLSMALLINT opt);

TCHAR* PrepareText(const TCHAR* szBaseText, const TCHAR* szParameters, va_list vaList);
TCHAR* GetText(const TCHAR* szBaseText, const TCHAR* szParameters, ...);
TCHAR* CompileString(int size, TCHAR** strings, int* lengths);
SQLRETURN PostgreTypeConverter(int nTypeOID, int nTypeModifier, SQLTCHAR** pszPostgreSQLTypeName, int nTypeNameLength,
										 SQLSMALLINT* pSQLConciseType, SQLINTEGER*  pLength, SQLSMALLINT* pPrecision, SQLSMALLINT* pScale,
										 SQLSMALLINT* pIsNullable, BYTE* pIsUnsigned);

/* type information functions */
SQLSMALLINT GetCDefaultType(SQLSMALLINT sql_type);
SQLINTEGER  GetCTypeLength(SQLSMALLINT c_type, SQLINTEGER char_length);

int GetInt(TCHAR** pPtr, TCHAR terminator, SQLINTEGER* pLength);

SQLRETURN SQLTypeDescriptor(SQLSMALLINT  concise_type,
									SQLSMALLINT  is_unsigned,
									SQLINTEGER*  pLength,
									SQLSMALLINT* pPrecision,
									SQLSMALLINT* pScale,
									SQLSMALLINT* pSQLType, 
									SQLINTEGER*  pDisplaySize,
									SQLINTEGER*  pIntervalPrecision,
									SQLINTEGER*  pNumPrecRadix);

typedef enum
{
	PS_KEYWORD_WAITING,
	PS_KEYWORD,
	PS_VALUE_WAITING,
	PS_VALUE,
	PS_VALUE_CLOSE_WAITING,
	PS_DIVISOR_WAITING,
	PS_VALUE_EXT_CHARS_ALLOWED
} ParseState;


/*---------------------------------------------------------
 *---------------------------------------------------------
 */

#ifndef WIN32
	char* itoa (int value, char* string, int radix);
#endif /* WIN32 */

#ifdef UNICODE
	int utf8len(WCHAR* String, int Length);
#endif /* UNICODE */
#endif /* __COMMON__ */
