/*=============================================================================
 *
 *
 *=============================================================================
 */
#include "connection.h"

#define FIELD_NULL              (-1)
#define FIELD_FROM_DELETED_ROW  (-2)
#define FIELD_IN_NEXT_BLOCK     (-3)
#define FIELD_TERMINATOR        (-4)

/*-----------------------------------------------------------------------------
 * PostgreSQL data_type OIDs, used in IPD->oid
 *-----------------------------------------------------------------------------
 */
typedef enum _uint32
{
	PT_BOOL                =   16, /* 'true' or 'false' */
	PT_BYTEA               =   17, /* variable-length string, binary values escaped */
	PT_CHAR                =   18,
	PT_NAME                =   19, /* 63-character type for storing system identifiers */
	PT_INT8                =   20,
	PT_INT2                =   21,
	PT_INT4                =   23,
	PT_REGPROC             =   24, /* registered procedure (4 bytes), but it returns proc name */
	PT_TEXT                =   25, /* variable-length string, no limit specified */
	PT_OID                 =   26, /* object identifier (4 bytes) */
	PT_XID                 =   28, /* transaction id (4 bytes) */
	PT_CID                 =   29, /* command identifier (4 bytes) */
	PT_SMGR                =  210, /* storage manager */
	PT__LINE               =  629,
	PT_CIDR                =  650, /* network IP address/netmask, network address */
	PT__CIDR               =  651,
	PT_UNKNOWN             =  705,
	PT__CIRCLE             =  719,
	PT__MONEY              =  791,
	PT_MACADDR             =  829, /* XX:XX:XX:XX:XX:XX, MAC address */
	PT_INET                =  869, /* IP address/netmask, host address, netmask optional */
	PT__BOOL               = 1000,
	PT__BYTEA              = 1001,
	PT__CHAR               = 1002,
	PT__NAME               = 1003,
	PT__INT2               = 1005,
	PT__INT2VECTOR         = 1006,
	PT__INT4               = 1007,
	PT__REGPROC            = 1008,
	PT__TEXT               = 1009,
	PT__TID                = 1010,
	PT__XID                = 1011,
	PT__CID                = 1012,
	PT__OIDVECTOR          = 1013,
	PT__BPCHAR             = 1014,
	PT__VARCHAR            = 1015,
	PT__INT8               = 1016,
	PT__POINT              = 1017,
	PT__LSEG               = 1018,
	PT__PATH               = 1019,
	PT__BOX                = 1020,
	PT__FLOAT4             = 1021,
	PT__FLOAT8             = 1022,
	PT__ABSTIME            = 1023,
	PT__RELTIME            = 1024,
	PT__TINTERVAL          = 1025,
	PT__POLYGON            = 1027,
	PT__OID                = 1028,
	PT__ACLITEM            = 1034,
	PT__MACADDR            = 1040,
	PT__INET               = 1041,
	PT_BPCHAR              = 1042,
	PT_VARCHAR             = 1043,
	PT_DATE                = 1082,
	PT_TIME                = 1083,
	PT_TIMESTAMP           = 1114,
	PT__TIMESTAMP          = 1115,
	PT__DATE               = 1182,
	PT__TIME               = 1183,
	PT_TIMESTAMPTZ         = 1184, /* date and time with time zone */
	PT__TIMESTAMPTZ        = 1185,
	PT__INTERVAL           = 1187,
	PT__NUMERIC            = 1231,
	PT__TIMETZ             = 1270,
	PT_BIT                 = 1560, /* fixed-length bit string */
	PT__BIT                = 1561,
	PT_VARBIT              = 1562, /* variable-length bit string */
	PT__VARBIT             = 1563,
	PT_REFCURSOR           = 1790, /* reference cursor (portal name) */
	PT__REFCURSOR          = 2201,
	PT_REGPROCEDURE        = 2202, /* registered procedure (with args) */
	PT_REGOPER             = 2203, /* registered operator */
	PT_REGOPERATOR         = 2204, /* registered operator (with args) */
	PT_REGCLASS            = 2205, /* registered class */
	PT_REGTYPE             = 2206, /* registered type */
	PT__REGPROCEDURE       = 2207,
	PT__REGOPER            = 2208,
	PT__REGOPERATOR        = 2209,
	PT__REGCLASS           = 2210,
	PT__REGTYPE            = 2211,
	PT_TIMETZ              = 1266, /* hh:mm:ss, ANSI SQL time + time zone */
	PT_INTERVAL            = 1186,
	PT_NUMERIC             = 1700,

	/* ready */
	PT_INT2VECTOR          =   22, /* array of int2 integers */
	PT_TID                 =   27, /* (Block, offset), physical location of tuple (6 bytes)*/
	PT_OIDVECTOR           =   30, /* array of oids */

	PT_POINT               =  600, /* point '(x, y)' (16 bytes )*/
	PT_LSEG                =  601, /* line segment '(pointt1, point2)' (32 bytes) */
	PT_PATH                =  602, /* path '(pointt1, ...)' */
	PT_BOX                 =  603, /* box '(lower left, upper right)' (32 bytes) */
	PT_POLYGON             =  604, /* polygon '(point1, ...)' */
	PT_LINE                =  628, /* line, not implemented in 8.0.3 (32 bytes) */

	PT_FLOAT4              =  700,
	PT_FLOAT8              =  701,
	PT_ABSTIME             =  702, /* unix system time (4 bytes) */
	PT_RELTIME             =  703, /* unix delta time (4 bytes) */
	PT_TINTERVAL           =  704, /* (abstime,abstime), time interval (12 bytes) */
	PT_CIRCLE              =  718, /* circle '(center, radius)' (24 bytes) */
	PT_MONEY               =  790  /* $d,ddd.cc (4 bytes) */
} PostgreSQL_Type;

SQLRETURN SendStartupMessage(Connection* pConnection, Message* msg);
SQLRETURN SendMessageToBackend(Connection* pConnection, MessageType msgType, void* param);
SQLRETURN Stmt_SendMessageToBackend(Connection* pConnection, MessageType msgType, void* param);
SQLRETURN GetMessageFromBackend(Connection* pConnection, Message* msg, Statement* pStatement);
SQLRETURN WaitForBackendReply(Connection* pConnection, MessageType msgType, Statement* pData);
SQLRETURN GetBackendReply(Connection* pConnection);
SQLRETURN DeclarePortal(Statement* pStatement);
SQLRETURN DeclareStatement(Statement* pStatement, BOOL ForceDeclaration);
SQLRETURN CloseDeclared(Statement* pStatement, TCHAR chType);

