#=====================================================================
# SQL-Ledger Accounting
# Copyright (C) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#  Contributors:
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# General ledger backend code
#
# CHANGE LOG:
#   DS. 2000-07-04  Created
#   DS. 2001-06-12  Changed relations from accno to chart_id
#
#======================================================================

package GL;


sub delete_transaction {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect_noauto($myconfig);

  my $query = qq|DELETE FROM gl WHERE id = $form->{id}|;
  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query);    

  $query = qq|DELETE FROM acc_trans WHERE trans_id = $form->{id}|;
  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

  # commit and redirect
  my $rc = $dbh->commit;
  $dbh->disconnect;

  $rc;

}

sub delete_template {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect_noauto($myconfig);

  my $query = qq|DELETE FROM quicktemplate WHERE id = $form->{id}|;
  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

#  $query = qq|DELETE FROM acc_trans WHERE trans_id = $form->{id}|;
#  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

  # commit and redirect
  my $rc = $dbh->commit;
  $dbh->disconnect;

  $rc;

}

sub post_transaction {
  my ($self, $myconfig, $form) = @_;

  my ($debit, $credit) = (0, 0);
  $form->{callback}.= "&transdate=$form->{transdate}&transtype=$form->{transtype}&batch=$form->{batch}&transno=$form->{transno}&subtransno=$form->{subtransno}";

  my $i;
  # check if debit and credit balances
  for $i (1 .. $form->{rowcount}) {
    if ($form->{"debit_$i"} && $form->{"credit_$i"}) {
      return -1;
    }

    $form->{"debit_$i"} = $form->parse_amount($myconfig, $form->{"debit_$i"});
    $form->{"credit_$i"} = $form->parse_amount($myconfig, $form->{"credit_$i"});

    $debit += $form->{"debit_$i"};
    $credit += $form->{"credit_$i"};
  }

  $debit = $form->round_amount($debit, 2);
  $credit = $form->round_amount($credit, 2);

  if ($debit != $credit) {
    return -2;
  }

  # connect to database, turn off AutoCommit
  my $dbh = $form->dbconnect_noauto($myconfig);

  # post the transaction
  # make up a unique handle and store in source field
  # then retrieve the record based on the unique handle to get the id
  # replace the source field with the actual variable
  # add records to acc_trans

  # if there is a $form->{id} replace the old transaction
  # delete all acc_trans entries and add the new ones

  # escape '
  $form->{source} =~ s/'/\\'/g;
  $form->{description} =~ s/'/\\'/g;
  $form->{batch} =~ s/'/\\'/g;
  $form->{subb} =~ s/'/\\'/g;
  $form->{project} =~ s/'/\\'/g;


  my ($query, $uid, $sth);

  if ($form->{id}) {
    $query = qq|UPDATE gl SET
  		source = '$form->{source}',
  		batch = '$form->{batch}',
  		subb = '$form->{subb}',
  		project = '$form->{source}',
		description = '$form->{description}',
		transno = '$form->{transno}',
		subtransno = '$form->{subtransno}',
		transtype = '$form->{transtype}',
		transdate = '$form->{transdate}'
	        WHERE id = $form->{id}|;

  } else {
    $uid = time;
    $uid .= $form->{login};

    $query = qq|INSERT INTO gl (source,description,transdate,batch,project,subb, employee_id,transno,transtype,subtransno)
		VALUES ('$uid', '$form->{description}', '$form->{transdate}','$form->{batch}','$form->{project}','$form->{subb}',
		(SELECT id FROM employee WHERE login = '$form->{login}'), '$form->{transno}', '$form->{transtype}', '$form->{subtransno}')|;
  }

  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 


  if ($form->{id}) {
    # delete individual transactions
    $query = qq|DELETE FROM acc_trans
                WHERE trans_id = $form->{id}|;
    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
  } else {

    $query = qq|SELECT id FROM gl WHERE source = '$uid'|;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    ($form->{id}) = $sth->fetchrow_array;
    $query = qq|UPDATE gl SET source = '$form->{source}'
                WHERE id = $form->{id}|;
    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

    $sth->finish;
  }


  # insert acc_trans transactions
  for $i (1 .. $form->{rowcount}) {
    # extract accno
    ($accno) = split(/--/, $form->{"accno_$i"});
    my $amount = 0;

    if ($form->{"credit_$i"} != 0) {
      $amount = $form->{"credit_$i"};
    }
    if ($form->{"debit_$i"} != 0) {
      $amount = $form->{"debit_$i"} * -1;
    }


    # if there is an amount, add the record
    if ($amount != 0) {
      $query = qq|INSERT INTO acc_trans (trans_id, chart_id, amount, transdate,
                  source,project,sub)
		  VALUES
		  ($form->{id}, (SELECT id
		                 FROM chart
				 WHERE accno = '$accno'),
		   $amount, '$form->{transdate}', '$form->{source}','$form->{project}','$form->{subb}' )|;
    
      $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
    }
  }

  # commit and redirect
  my $rc = $dbh->commit;
  $dbh->disconnect;
  $form->{transno} ++;

  $rc;

}

sub post_template_transaction {
  my ($self, $myconfig, $form) = @_;

  my ($debit, $credit) = (0, 0);
  $form->{callback}.= "&transdate=$form->{transdate}&batch=$form->{batch}";
 #$form->dberror($form->{callback});
  my $i;
  # check if debit and credit balances
  for $i (1 .. $form->{rowcount}) {
    if (!$form->{"amount"} ) {
      return -1;
    }

    $debit = $form->{"amount"};
    $credit = $form->{"amount"};
    $debit = $form->parse_amount($myconfig, $form->{"amount"});
    $credit = $form->parse_amount($myconfig, $form->{"amount"});

   if($debit <=0 || $credit <=0){
   	return -3;
  }
   # $form->dberror($form->{"amount"});

  }


 $debit = $form->round_amount($debit, 2);
  $credit = $form->round_amount($credit, 2);

  #if ($debit != $credit) {
  #  return -2;
  #}

  # connect to database, turn off AutoCommit
  my $dbh = $form->dbconnect_noauto($myconfig);

  # post the transaction
  # make up a unique handle and store in source field
  # then retrieve the record based on the unique handle to get the id
  # replace the source field with the actual variable
  # add records to acc_trans

  # if there is a $form->{id} replace the old transaction
  # delete all acc_trans entries and add the new ones

  # escape '
  $form->{source} =~ s/'/\\'/g;
  $form->{description} =~ s/'/\\'/g;
  $form->{batch} =~ s/'/\\'/g;
  $form->{subb} =~ s/'/\\'/g;
  $form->{project} =~ s/'/\\'/g;
 $form->{amount} =~ s/'/\\'/g;


  my ($query, $uid, $sth);

 # if ($form->{id}) {
 #   $query = qq|UPDATE gl SET
 # 		source = '$form->{source}',
 # 		batch = '$form->{batch}',
 # 		project = '$form->{source}',
#		description = '$form->{description}',
#		transdate = '$form->{transdate}'
#	        WHERE id = $form->{id}|;

 # } else {
    $uid = time;
    $uid .= $form->{login};

    $query = qq|INSERT INTO gl (source,description,transdate,batch,project,subb,employee_id,transno,transtype,subtransno)
		VALUES ('$uid', '$form->{description}', '$form->{transdate}','$form->{batch}','$form->{project}','$form->{subb}',
		(SELECT id FROM employee WHERE login = '$form->{login}'), '$form->{transno}', '$form->{transtype}', '$form->{subtransno}')|;
 # }

  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 


  #if ($form->{id}) {
    # delete individual transactions
  #  $query = qq|DELETE FROM acc_trans
  #              WHERE trans_id = $form->{id}|;
  #  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
  #} else {

    $query = qq|SELECT id FROM gl WHERE source = '$uid'|;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    ($form->{id}) = $sth->fetchrow_array;
    $query = qq|UPDATE gl SET source = '$form->{source}'
                WHERE id = $form->{id}|;
    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

    $sth->finish;
#  }


  # insert acc_trans transactions
  #for $i (1 .. $form->{rowcount}) {
    # extract accno
    ($accno) = split(/--/, $form->{"accno_1"});
    my $amount = $debit*-1;

    #if ($form->{"credit_$i"} != 0) {
    #  $amount = $form->{"credit_$i"};
    #}
    #if ($form->{"debit_$i"} != 0) {
    #  $amount = $form->{"debit_$i"} * -1;
    #}


    # if there is an amount, add the record
    if ($amount != 0) {
      $query = qq|INSERT INTO acc_trans (trans_id, chart_id, amount, transdate,
                  source,project,sub)
		  VALUES
		  ($form->{id}, (SELECT id
		                 FROM chart
				 WHERE accno = '$accno'),
		   $amount, '$form->{transdate}', '$form->{source}' ,'$form->{project}','$form->{subb}')|;

      $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 


#   }
  }

     ###add credit
   ($accno) = split(/--/, $form->{"accno_2"});
    my $amount = $credit;

   # if there is an amount, add the record
    if ($amount != 0) {
      $query = qq|INSERT INTO acc_trans (trans_id, chart_id, amount, transdate,
                  source,project,sub)
		  VALUES
		  ($form->{id}, (SELECT id
		                 FROM chart
				 WHERE accno = '$accno'),
		   $amount, '$form->{transdate}', '$form->{source}' ,'$form->{project}','$form->{subb}')|;

      $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
  }

  # commit and redirect
  my $rc = $dbh->commit;
  $dbh->disconnect;

  $rc;

}

sub post_template {
  my ($self, $myconfig, $form) = @_;

  my ($debit, $credit) = (0, 0);

  my $i;


  # connect to database, turn off AutoCommit
  my $dbh = $form->dbconnect_noauto($myconfig);

  # post the transaction
  # make up a unique handle and store in source field
  # then retrieve the record based on the unique handle to get the id
  # replace the source field with the actual variable
  # add records to acc_trans

  # if there is a $form->{id} replace the old transaction
  # delete all acc_trans entries and add the new ones

  # escape '
  $form->{template} =~ s/'/\\'/g;


  my ($query, $uid, $sth);
    ($accno1) = split(/--/, $form->{"accno_1"});
    ($accno2) = split(/--/, $form->{"accno_2"});

  if ($form->{id}) {
    $query = qq|UPDATE quicktemplate SET
  		name = '$form->{name}',
  		source = '$form->{source}',
		debit = '$accno1',
		credit = '$accno2'
	        WHERE id = $form->{id}|;

  } else {
    $uid = time;
    $uid .= $form->{login};

    $query = qq|INSERT INTO quicktemplate (name,debit,credit,source)
		VALUES ('$form->{template}', '$accno1','$accno2','$form->{source}'
		)|;
  }

  $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 


#  if ($form->{id}) {
    # delete individual transactions
#    $query = qq|DELETE FROM acc_trans
#               WHERE trans_id = $form->{id}|;
#    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 
#  } else {
#
#    $query = qq|SELECT id FROM gl WHERE source = '$uid'|;
#    $sth = $dbh->prepare($query);
#    $sth->execute || $form->dberror($query);

#    ($form->{id}) = $sth->fetchrow_array;
#    $query = qq|UPDATE gl SET source = '$form->{source}'
#                WHERE id = $form->{id}|;
#    $dbh->do($query) || $form->dberror($query);  $form->save_query(\%$form,$myconfig->{dbname},$query); 

#    $sth->finish;
 # }


  # commit and redirect
  my $rc = $dbh->commit;
  $dbh->disconnect;

  $rc;

}

sub search_template {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my $where = "1 = 1";
  $form->{sort} = "template" unless ($form->{sort});

 # if ($form->{"$form->{db}number"}) {
 #   my $companynumber = $form->like(lc $form->{"$form->{db}number"});
 #   $where .= " AND lower($form->{db}number) LIKE '$companynumber'";
 # }
  if ($form->{template}) {
    my $template = $form->like(lc $form->{template});
    $where .= " AND lower(name) LIKE '$template'";
  }

  
  my $query = qq~SELECT id, name as template, debit,credit

                 FROM quicktemplate
                 WHERE $where
		 ORDER BY $form->{sort}~;

  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);


  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
    push @{ $form->{GL} }, $ref;
  }

  $sth->finish;
  $dbh->disconnect;

}


sub all_transactions {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my ($glwhere, $arwhere, $apwhere,$gpwhere,$ouwhere) = ("1 = 1", "1 = 1", "1 = 1", "1 = 1", "1 = 1");

  if ($form->{source}) {
    my $source = $form->like(lc $form->{source});
    $glwhere .= " AND lower(gl.source) LIKE '$source'";
    $gpwhere .= " AND lower(source) LIKE '$source'";
    $ouwhere .= " AND lower(source) LIKE '$source'";
    $arwhere .= " AND lower(ar.invnumber) LIKE '$source'";
    $apwhere .= " AND lower(ap.invnumber) LIKE '$source'";
  }
  if ($form->{datefrom}) {
    $glwhere .= " AND acc_trans.transdate >= '$form->{datefrom}'";
    $gpwhere .= " AND gp_trans.transdate >= '$form->{datefrom}'";
    $ouwhere .= " AND transdate >= '$form->{datefrom}'";
    $arwhere .= " AND acc_trans.transdate >= '$form->{datefrom}'";
    $apwhere .= " AND acc_trans.transdate >= '$form->{datefrom}'";
  }
  if ($form->{dateto}) {
    $glwhere .= " AND acc_trans.transdate <= '$form->{dateto}'";
    $gpwhere .= " AND gp_trans.transdate <= '$form->{dateto}'";
    $ouwhere .= " AND transdate <= '$form->{dateto}'";
    $arwhere .= " AND acc_trans.transdate <= '$form->{dateto}'";
    $apwhere .= " AND acc_trans.transdate <= '$form->{dateto}'";
  }
  if ($form->{description}) {
    my $description = $form->like(lc $form->{description});
    $glwhere .= " AND lower(gl.description) LIKE '$description%'";
    $gpwhere .= " AND lower(gp_trans.description) LIKE '$description%'";
    $ouwhere .= " AND lower(ou_trans.description) LIKE '$description%'";
    $arwhere .= " AND lower(source) LIKE '$description%'";
    $apwhere .= " AND lower(source) LIKE '$description%'";
  }
  if ($form->{accno1}) {
    $glwhere .= " AND chart.accno like '$form->{accno1}%'";
    $gpwhere .= " AND chart.accno like '$form->{accno1}%'";
    $ouwhere .= " AND chart.accno like '$form->{accno1}%'";
    $arwhere .= " AND chart.accno like '$form->{accno1}%'";
    $apwhere .= " AND chart.accno like '$form->{accno1}%'";
  }
  if ($form->{accdesc}) {
    $glwhere .= " AND chart.description = '$form->{accdesc}'";
    $gpwhere .= " AND chart.description = '$form->{accdesc}'";
    $ouwhere .= " AND chart.description = '$form->{accdesc}'";
    $arwhere .= " AND chart.description = '$form->{accdesc}'";
    $apwhere .= " AND chart.description = '$form->{accdesc}'";
  }
  if ($form->{batchno}) {
    $glwhere .= " AND batch like '$form->{batchno}%'";
    $gpwhere .= " AND batch like '$form->{batchno}%'";
    $ouwhere .= " AND batch like '$form->{batchno}%'";
    $arwhere .= " AND batch like '$form->{batchno}%'";
    $apwhere .= " AND batch like '$form->{batchno}%'";
  }
  if ($form->{transnono}) {
    $glwhere .= " AND transno like '$form->{transnono}%'";
    $gpwhere .= " AND transno like '$form->{transnono}%'";
    $ouwhere .= " AND transno like '$form->{transnono}%'";
    $arwhere .= " AND transno like '$form->{transnono}%'";
    $apwhere .= " AND transno like '$form->{transnono}%'";
  }
  if ($form->{transtypeno}) {
    $glwhere .= " AND transtype like '$form->{transtypeno}%'";
    $gpwhere .= " AND transtype like '$form->{transtypeno}%'";
    $ouwhere .= " AND transtype like '$form->{transtypeno}%'";
    $arwhere .= " AND transtype like '$form->{transtypeno}%'";
    $apwhere .= " AND transtype like '$form->{transtypeno}%'";
  }
  if ($form->{subtransnono}) {
    $glwhere .= " AND subtransno like '$form->{subtransnono}%'";
    $gpwhere .= " AND subtransno like '$form->{subtransnono}%'";
    $ouwhere .= " AND subtransno like '$form->{subtransnono}%'";
    $arwhere .= " AND subtransno like '$form->{subtransnono}%'";
    $apwhere .= " AND subtransno like '$form->{subtransnono}%'";
  }
 if ($form->{subbno}) {
    $glwhere .= " AND acc_trans.sub= '$form->{subbno}'";
    $gpwhere .= " AND gp_trans.sub= '$form->{subbno}'";
    $ouwhere .= " AND ou_trans.sub= '$form->{subbno}'";
    $arwhere .= " AND acc_trans.sub = '$form->{subbno}'";
    $apwhere .= " AND acc_trans.sub = '$form->{subbno}'";
  }
  if ($form->{projectno}) {
    $glwhere .= " AND acc_trans.project = '$form->{projectno}'";
    $gpwhere .= " AND gp.project = '$form->{projectno}'";
    $ouwhere .= " AND ou.project = '$form->{projectno}'";
    $arwhere .= " AND acc_trans.project = '$form->{projectno}'";
    $apwhere .= " AND acc_trans.project = '$form->{projectno}'";
  }
  if ($form->{gifi_accno}) {
    $glwhere .= " AND chart.gifi_accno = '$form->{gifi_accno}'";
    $gpwhere .= " AND chart.gifi_accno = '$form->{gifi_accno}'";
    $ouwhere .= " AND chart.gifi_accno = '$form->{gifi_accno}'";
    $arwhere .= " AND chart.gifi_accno = '$form->{gifi_accno}'";
    $apwhere .= " AND chart.gifi_accno = '$form->{gifi_accno}'";
  }
  if ($form->{category} ne 'X') {
    $glwhere .= " AND chart.category = '$form->{category}'";
    $gpwhere .= " AND chart.category = '$form->{category}'";
    $ouwhere .= " AND chart.category = '$form->{category}'";
    $arwhere .= " AND chart.category = '$form->{category}'";
    $apwhere .= " AND chart.category = '$form->{category}'";
  }
  
  if(!($form->{l_debit} && $form->{l_credit})){
    if ($form->{l_debit} ) {
    $glwhere .= " AND acc_trans.amount <0";
    $gpwhere .= " AND amount <0";
    $ouwhere .= " AND ou.amount <0";
    $arwhere .= " AND acc_trans.amount <0";
    $apwhere .= " AND acc_trans.amount <0";
  }
    if ($form->{l_credit} ) {
    $glwhere .= " AND acc_trans.amount >0";
    $gpwhere .= " AND amount >0";
    $ouwhere .= " AND ou_trans.amount >0";
    $arwhere .= " AND acc_trans.amount >0";
    $apwhere .= " AND acc_trans.amount >0";
  }
  }
  my $false = ($myconfig->{dbdriver} eq 'Pg') ? FALSE : q|'0'|;

  my $sortorder = join ', ', $form->sort_columns(qw(transdate transtype batch transno subtransno source description accno accdesc  project ));
  my %ordinal = ( transdate => 6,
                  source => 4,
		  description => 5 );
  map { $sortorder =~ s/$_/$ordinal{$_}/ } keys %ordinal;
  #$sortorder=$form->{sort};

  my $query = qq|SELECT gl.id, 'gl' AS type, $false AS invoice, gl.source,
                 gl.description, acc_trans.transdate,
		 acc_trans.amount, chart.accno, chart.description as accdesc,chart.gifi_accno, transtype, batch,transno,subtransno,gl.project, gl.subb,acc_trans.amount
                 FROM gl, acc_trans, chart
                 WHERE $glwhere
		 AND acc_trans.chart_id = chart.id
		 AND gl.id = acc_trans.trans_id
	UNION ALL
	         SELECT ar.id, 'ar' AS type, ar.invoice, ar.invnumber,
		 source, acc_trans.transdate,
		 acc_trans.amount, chart.accno, chart.description as accdesc,chart.gifi_accno, transtype, batch,transno,subtransno,ar.project,ar.subb,acc_trans.amount
		 FROM ar, acc_trans, chart, customer
		 WHERE $arwhere
		 AND acc_trans.chart_id = chart.id
		 AND ar.customer_id = customer.id
		 AND ar.id = acc_trans.trans_id
	UNION ALL
	         SELECT ap.id, 'ap' AS type, ap.invoice, ap.invnumber,
		 source, acc_trans.transdate,
		 acc_trans.amount, chart.accno, chart.description as accdesc,chart.gifi_accno,transtype, batch,transno,subtransno,ap.project,ap.subb,acc_trans.amount
		 FROM ap, acc_trans, chart, vendor
		 WHERE $apwhere
		 AND acc_trans.chart_id = chart.id
		 AND ap.vendor_id = vendor.id
		 AND ap.id = acc_trans.trans_id
	UNION ALL
	         SELECT gp.id, 'gp' AS type, $false, gp_trans.source,
		 gp_trans.description as desc, gp_trans.transdate,
		 gp_trans.amount, chart.accno, chart.description as accdesc,chart.gifi_accno,transtype, batch,transno,subtransno,proj,gp_trans.sub,gp_trans.amount
		 FROM gp,  chart, gp_trans
		 WHERE $gpwhere
		 AND gp_trans.chart_id = chart.id
		 
		 AND gp.id = gp_trans.id
	UNION ALL
	         SELECT ou.id, 'ou' AS type, $false, ou_trans.source,
		 ou_trans.description as desc, ou_trans.transdate,
		 ou_trans.amount, chart.accno, chart.description as accdesc,chart.gifi_accno,transtype, batch,transno,subtransno,ou.project,ou.sub,ou_trans.amount
		 FROM ou,  chart, ou_trans
		 WHERE $ouwhere
		 AND ou_trans.chart_id = chart.id

		 AND ou.id = ou_trans.id
	
	UNION ALL
	         SELECT ar.id, 'cn' AS type, ar.invoice, ar.ordnumber,
		 ar.notes, acc_trans.transdate,
		 acc_trans.amount, chart.accno, chart.description as accdesc,chart.gifi_accno, transtype, batch,transno,subtransno,ar.project,ar.subb,acc_trans.amount
		 FROM creditnote ar, acc_trans, chart, customer
		 WHERE $arwhere
		 AND acc_trans.chart_id = chart.id
		 AND ar.customer_id = customer.id
		 AND ar.id = acc_trans.trans_id
	UNION ALL
	         SELECT ap.id, 'cn1' AS type, ap.invoice, ap.ordnumber,
		 ap.notes, acc_trans.transdate,
		 acc_trans.amount, chart.accno, chart.description as accdesc,chart.gifi_accno,transtype, batch,transno,subtransno,ap.project,ap.subb,acc_trans.amount
		 FROM creditnote ap, acc_trans, chart, vendor
		 WHERE $apwhere
		 AND acc_trans.chart_id = chart.id
		 AND ap.vendor_id = vendor.id
		 AND ap.id = acc_trans.trans_id


		 ORDER BY $sortorder|;
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
#$form->dberror($query);
  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {

    # gl
    if ($ref->{type} eq "gl") {
      $ref->{module} = "gl";
    }

    # ap
    if ($ref->{type} eq "ap") {
      if ($ref->{invoice}) {
        $ref->{module} = "ir";
      } else {
        $ref->{module} = "ap";
      }
    }

    # ar
    if ($ref->{type} eq "ar") {
      if ($ref->{invoice}) {
        $ref->{module} = "is";
      } else {
        $ref->{module} = "ar";
      }
    }

    # ar
    if ($ref->{type} eq "gp") {
      if ($ref->{invoice}) {
        $ref->{module} = "dataentry2";
      } else {
        $ref->{module} = "dataentry2";
      }
    }
        # ar
    if ($ref->{type} eq "ou") {
      if ($ref->{invoice}) {
        $ref->{module} = "dataentry3";
      } else {
        $ref->{module} = "dataentry3";
      }
    }

    if ($ref->{type} eq "dn") {
	$form->{vc} = "customer";
      if ($ref->{invoice}) {
        $ref->{module} = "debitnote";
      } else {
        $ref->{module} = "debitnote2";
      }
    }

        if ($ref->{type} eq "cn") {
	$form->{vc} = "customer";
    #  if ($ref->{invoice}) {
        $ref->{module} = "creditnote";
     # } else {
     #   $ref->{module} = "creditnote2";
    #  }
    }

        if ($ref->{type} eq "dn1") {
	$form->{vc}="vendor";
      if ($ref->{invoice}) {
        $ref->{module} = "debitnote";
      } else {
        $ref->{module} = "debitnote2";
      }
    }

        if ($ref->{type} eq "cn1") {
	$form->{vc}="vendor";
     # if ($ref->{invoice}) {
        $ref->{module} = "creditnote";
     # } else {
     #   $ref->{module} = "creditnote2";
     # }
    }

    if ($ref->{amount} < 0) {
      $ref->{debit} = $ref->{amount} * -1;
      $ref->{credit} = 0;
    } else {
      $ref->{credit} = $ref->{amount};
      $ref->{debit} = 0;
    }

    push @{ $form->{GL} }, $ref;
    
  }

  $sth->finish;

  if ($form->{accno}) {
    $query = qq|SELECT description FROM chart WHERE accno = '$form->{accno}'|;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    ($form->{account_description}) = $sth->fetchrow_array;
    $sth->finish;
  }
  if ($form->{gifi_accno}) {
    $query = qq|SELECT description FROM gifi WHERE accno = '$form->{gifi_accno}'|;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    ($form->{gifi_account_description}) = $sth->fetchrow_array;
    $sth->finish;
  }
 
  $dbh->disconnect;

}

sub all_transactions1 {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my ($glwhere, $arwhere, $apwhere,$gpwhere,$ouwhere) = ("1 = 1", "1 = 1", "1 = 1", "1 = 1", "1 = 1");

  if ($form->{source}) {
    my $source = $form->like(lc $form->{source});
    $glwhere .= " AND lower(gl.source) LIKE '$source'";
    $gpwhere .= " AND lower(source) LIKE '$source'";
    $ouwhere .= " AND lower(source) LIKE '$source'";
    $arwhere .= " AND lower(ar.invnumber) LIKE '$source'";
    $apwhere .= " AND lower(ap.invnumber) LIKE '$source'";
  }
  if ($form->{datefrom}) {
    $glwhere .= " AND acc_trans.transdate >= '$form->{datefrom}'";
    $gpwhere .= " AND transdate >= '$form->{datefrom}'";
    $ouwhere .= " AND transdate >= '$form->{datefrom}'";
    $arwhere .= " AND acc_trans.transdate >= '$form->{datefrom}'";
    $apwhere .= " AND acc_trans.transdate >= '$form->{datefrom}'";
  }
  if ($form->{dateto}) {
    $glwhere .= " AND acc_trans.transdate <= '$form->{dateto}'";
    $gpwhere .= " AND transdate <= '$form->{dateto}'";
    $ouwhere .= " AND transdate <= '$form->{dateto}'";
    $arwhere .= " AND acc_trans.transdate <= '$form->{dateto}'";
    $apwhere .= " AND acc_trans.transdate <= '$form->{dateto}'";
  }
  if ($form->{description}) {
    my $description = $form->like(lc $form->{description});
    $glwhere .= " AND lower(gl.description) LIKE '$description%'";
    $gpwhere .= " AND lower(gp_trans.description) LIKE '$description%'";
    $ouwhere .= " AND lower(ou_trans.description) LIKE '$description%'";
    $arwhere .= " AND lower(customer.name) LIKE '$description%'";
    $apwhere .= " AND lower(vendor.name) LIKE '$description%'";
  }
  if ($form->{accno1}) {
    $glwhere .= " AND chart.accno like '$form->{accno1}%'";
    $gpwhere .= " AND chart.accno like '$form->{accno1}%'";
    $ouwhere .= " AND chart.accno like '$form->{accno1}%'";
    $arwhere .= " AND chart.accno like '$form->{accno1}%'";
    $apwhere .= " AND chart.accno like '$form->{accno1}%'";
  }
  if ($form->{accdesc}) {
    $glwhere .= " AND chart.description = '$form->{accdesc}'";
    $gpwhere .= " AND chart.description = '$form->{accdesc}'";
    $ouwhere .= " AND chart.description = '$form->{accdesc}'";
    $arwhere .= " AND chart.description = '$form->{accdesc}'";
    $apwhere .= " AND chart.description = '$form->{accdesc}'";
  }
  if ($form->{batchno}) {
    $glwhere .= " AND batch like '$form->{batchno}%'";
    $gpwhere .= " AND batch like '$form->{batchno}%'";
    $ouwhere .= " AND batch like '$form->{batchno}%'";
    $arwhere .= " AND batch like '$form->{batchno}%'";
    $apwhere .= " AND batch like '$form->{batchno}%'";
  }
  if ($form->{transnono}) {
    $glwhere .= " AND transno like '$form->{transnono}%'";
    $gpwhere .= " AND transno like '$form->{transnono}%'";
    $ouwhere .= " AND transno like '$form->{transnono}%'";
    $arwhere .= " AND transno like '$form->{transnono}%'";
    $apwhere .= " AND transno like '$form->{transnono}%'";
  }
  if ($form->{transtypeno}) {
    $glwhere .= " AND transtype like '$form->{transtypeno}%'";
    $gpwhere .= " AND transtype like '$form->{transtypeno}%'";
    $ouwhere .= " AND transtype like '$form->{transtypeno}%'";
    $arwhere .= " AND transtype like '$form->{transtypeno}%'";
    $apwhere .= " AND transtype like '$form->{transtypeno}%'";
  }
  if ($form->{subtransnono}) {
    $glwhere .= " AND subtransno like '$form->{subtransnono}%'";
    $gpwhere .= " AND subtransno like '$form->{subtransnono}%'";
    $ouwhere .= " AND subtransno like '$form->{subtransnono}%'";
    $arwhere .= " AND subtransno like '$form->{subtransnono}%'";
    $apwhere .= " AND subtransno like '$form->{subtransnono}%'";
  }
 if ($form->{subbno}) {
    $glwhere .= " AND subb= '$form->{subbno}'";
    $gpwhere .= " AND subb= '$form->{subbno}'";
    $ouwhere .= " AND subb= '$form->{subbno}'";
    $arwhere .= " AND subb = '$form->{subbno}'";
    $apwhere .= " AND subb = '$form->{subbno}'";
  }
  if ($form->{projectno}) {
    $glwhere .= " AND project = '$form->{projectno}'";
    $gpwhere .= " AND project = '$form->{projectno}'";
    $ouwhere .= " AND project = '$form->{projectno}'";
    $arwhere .= " AND project = '$form->{projectno}'";
    $apwhere .= " AND project = '$form->{projectno}'";
  }
  if ($form->{gifi_accno}) {
    $glwhere .= " AND chart.gifi_accno = '$form->{gifi_accno}'";
    $gpwhere .= " AND chart.gifi_accno = '$form->{gifi_accno}'";
    $ouwhere .= " AND chart.gifi_accno = '$form->{gifi_accno}'";
    $arwhere .= " AND chart.gifi_accno = '$form->{gifi_accno}'";
    $apwhere .= " AND chart.gifi_accno = '$form->{gifi_accno}'";
  }
  if ($form->{category} ne 'X') {
    $glwhere .= " AND chart.category = '$form->{category}'";
    $gpwhere .= " AND chart.category = '$form->{category}'";
    $ouwhere .= " AND chart.category = '$form->{category}'";
    $arwhere .= " AND chart.category = '$form->{category}'";
    $apwhere .= " AND chart.category = '$form->{category}'";
  }
  
  if(!($form->{l_debit} && $form->{l_credit})){
    if ($form->{l_debit} ) {
    $glwhere .= " AND acc_trans.amount <0";
    $gpwhere .= " AND amount <0";
    $ouwhere .= " AND acc_trans.amount <0";
    $arwhere .= " AND acc_trans.amount <0";
    $apwhere .= " AND acc_trans.amount <0";
  }
    if ($form->{l_credit} ) {
    $glwhere .= " AND acc_trans.amount >0";
    $gpwhere .= " AND amount >0";
    $ouwhere .= " AND acc_trans.amount >0";
    $arwhere .= " AND acc_trans.amount >0";
    $apwhere .= " AND acc_trans.amount >0";
  }
  }
  my $false = ($myconfig->{dbdriver} eq 'Pg') ? FALSE : q|'0'|;

  my $sortorder = join ', ', $form->sort_columns(qw(transdate transtype batch transno subtransno source description accno accdesc  project subb));
  my %ordinal = ( transdate => 6,
                  source => 4,
		  description => 5 );
  map { $sortorder =~ s/$_/$ordinal{$_}/ } keys %ordinal;
  #$sortorder=$form->{sort};

  my $query = qq|SELECT gl.id, 'gl' AS type, $false AS invoice, gl.source,
                 gl.description, acc_trans.transdate,
		 acc_trans.amount, chart.accno, chart.description as accdesc,chart.gifi_accno, transtype, batch,transno,subtransno,project, subb,acc_trans.amount
                 FROM gl, acc_trans, chart
                 WHERE $glwhere
		 AND acc_trans.chart_id = chart.id
		 AND gl.id = acc_trans.trans_id
	UNION ALL
	         SELECT ar.id, 'ar' AS type, ar.invoice, ar.invnumber,
		 source, acc_trans.transdate,
		 acc_trans.amount, chart.accno, chart.description as accdesc,chart.gifi_accno, transtype, batch,transno,subtransno,'','',acc_trans.amount
		 FROM ar, acc_trans, chart, customer
		 WHERE $arwhere
		 AND acc_trans.chart_id = chart.id
		 AND ar.customer_id = customer.id
		 AND ar.id = acc_trans.trans_id
	UNION ALL
	         SELECT ap.id, 'ap' AS type, ap.invoice, ap.invnumber,
		 source, acc_trans.transdate,
		 acc_trans.amount, chart.accno, chart.description as accdesc,chart.gifi_accno,transtype, batch,transno,subtransno,'','',acc_trans.amount
		 FROM ap, acc_trans, chart, vendor
		 WHERE $apwhere
		 AND acc_trans.chart_id = chart.id
		 AND ap.vendor_id = vendor.id
		 AND ap.id = acc_trans.trans_id
	UNION ALL
	         SELECT gp.id, 'gp' AS type, $false, gp_trans.source,
		 gp_trans.description as desc, gp_trans.transdate,
		 gp_trans.amount, chart.accno, chart.description as accdesc,chart.gifi_accno,transtype, batch,transno,subtransno,proj,sub,gp_trans.amount
		 FROM gp,  chart, gp_trans
		 WHERE $gpwhere
		 AND gp_trans.chart_id = chart.id
		 
		 AND gp.id = gp_trans.id
	UNION ALL
	         SELECT ou.id, 'ou' AS type, $false, ou_trans.source,
		 ou_trans.description as desc, ou_trans.transdate,
		 ou_trans.amount, chart.accno, chart.description as accdesc,chart.gifi_accno,transtype, batch,transno,subtransno,'','',ou_trans.amount
		 FROM ou,  chart, ou_trans
		 WHERE $gpwhere
		 AND ou_trans.chart_id = chart.id

		 AND ou.id = ou_trans.id
	UNION ALL
	         SELECT ar.id, 'dn' AS type, ar.invoice, ar.ordnumber,
		 customer.name, acc_trans.transdate,
		 acc_trans.amount, chart.accno, chart.description as accdesc,chart.gifi_accno, transtype, batch,transno,subtransno,'','',acc_trans.amount
		 FROM debitnote ar, acc_trans, chart, customer
		 WHERE $arwhere
		 AND acc_trans.chart_id = chart.id
		 AND ar.customer_id = customer.id
		 AND ar.id = acc_trans.trans_id
	UNION ALL
	         SELECT ap.id, 'dn1' AS type, ap.invoice, ap.ordnumber,
		 vendor.name, acc_trans.transdate,
		 acc_trans.amount, chart.accno, chart.description as accdesc,chart.gifi_accno,transtype, batch,transno,subtransno,'','',acc_trans.amount
		 FROM debitnote ap, acc_trans, chart, vendor
		 WHERE $apwhere
		 AND acc_trans.chart_id = chart.id
		 AND ap.vendor_id = vendor.id
		 AND ap.id = acc_trans.trans_id
	UNION ALL
	         SELECT ar.id, 'cn' AS type, ar.invoice, ar.ordnumber,
		 customer.name, acc_trans.transdate,
		 acc_trans.amount, chart.accno, chart.description as accdesc,chart.gifi_accno, transtype, batch,transno,subtransno,'','',acc_trans.amount
		 FROM creditnote ar, acc_trans, chart, customer
		 WHERE $arwhere
		 AND acc_trans.chart_id = chart.id
		 AND ar.customer_id = customer.id
		 AND ar.id = acc_trans.trans_id
	UNION ALL
	         SELECT ap.id, 'cn1' AS type, ap.invoice, ap.ordnumber,
		 vendor.name, acc_trans.transdate,
		 acc_trans.amount, chart.accno, chart.description as accdesc,chart.gifi_accno,transtype, batch,transno,subtransno,'','',acc_trans.amount
		 FROM creditnote ap, acc_trans, chart, vendor
		 WHERE $apwhere
		 AND acc_trans.chart_id = chart.id
		 AND ap.vendor_id = vendor.id
		 AND ap.id = acc_trans.trans_id

		 ORDER BY accno|;
		 
  my $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
#$form->dberror($query);
  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {

    # gl
    if ($ref->{type} eq "gl") {
      $ref->{module} = "gl";
    }

    # ap
    if ($ref->{type} eq "ap") {
      if ($ref->{invoice}) {
        $ref->{module} = "ir";
      } else {
        $ref->{module} = "ap";
      }
    }

    # ar
    if ($ref->{type} eq "ar") {
      if ($ref->{invoice}) {
        $ref->{module} = "is";
      } else {
        $ref->{module} = "ar";
      }
    }

    # ar
    if ($ref->{type} eq "gp") {
      if ($ref->{invoice}) {
        $ref->{module} = "dataentry2";
      } else {
        $ref->{module} = "dataentry2";
      }
    }
        # ar
    if ($ref->{type} eq "ou") {
      if ($ref->{invoice}) {
        $ref->{module} = "dataentry3";
      } else {
        $ref->{module} = "dataentry3";
      }
    }

    if ($ref->{type} eq "dn") {
	$form->{vc} = "customer";
      if ($ref->{invoice}) {
        $ref->{module} = "debitnote";
      } else {
        $ref->{module} = "debitnote2";
      }
    }

        if ($ref->{type} eq "cn") {
	$form->{vc} = "customer";
      if ($ref->{invoice}) {
        $ref->{module} = "creditnote";
      } else {
        $ref->{module} = "creditnote2";
      }
    }

        if ($ref->{type} eq "dn1") {
	$form->{vc}="vendor";
      if ($ref->{invoice}) {
        $ref->{module} = "debitnote";
      } else {
        $ref->{module} = "debitnote2";
      }
    }

        if ($ref->{type} eq "cn1") {
	$form->{vc}="vendor";
      if ($ref->{invoice}) {
        $ref->{module} = "creditnote";
      } else {
        $ref->{module} = "creditnote2";
      }
    }

    if ($ref->{amount} < 0) {
      $ref->{debit} = $ref->{amount} * -1;
      $ref->{credit} = 0;
    } else {
      $ref->{credit} = $ref->{amount};
      $ref->{debit} = 0;
    }

    #26/10 modify the dashes of column Trans. No. 
    $ref->{transtype} = $ref->{transtype}."-";
    $ref->{batch} = $ref->{batch}."-";

    
    push @{ $form->{GL} }, $ref;
  }

  $sth->finish;

  if ($form->{accno}) {
    $query = qq|SELECT description FROM chart WHERE accno = '$form->{accno}'|;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    ($form->{account_description}) = $sth->fetchrow_array;
    $sth->finish;
  }
  if ($form->{gifi_accno}) {
    $query = qq|SELECT description FROM gifi WHERE accno = '$form->{gifi_accno}'|;
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    ($form->{gifi_account_description}) = $sth->fetchrow_array;
    $sth->finish;
  }
 
  $dbh->disconnect;
}

sub get_selected_account {
  my ($self, $myconfig, $form,$account) = @_;

  my ($query, $sth);

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

if ($form->{id}) {
    $query = "SELECT closedto, revtrans
              FROM defaults";
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);




    ($form->{closedto}, $form->{revtrans}) = $sth->fetchrow_array;
    $sth->finish;

    $query = "SELECT source, description, transdate,batch,project,subb,transno,transtype,subtransno
              FROM gl
	      WHERE id = $form->{id}";
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    ($form->{source}, $form->{description}, $form->{transdate}, $form->{batch}, $form->{project}, $form->{subb}, $form->{transno}, $form->{transtype}, $form->{subtransno}) = $sth->fetchrow_array;
    $sth->finish;



    # retrieve individual rows
    $query = "SELECT chart.accno, amount,chart.description
	      FROM acc_trans, chart
	      WHERE acc_trans.chart_id = chart.id
	      AND trans_id = $form->{id}
	      ORDER BY accno";
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
      push @{ $form->{GL} }, $ref;
    }
  } else {
    $query = "SELECT current_date AS transdate, closedto, revtrans
              FROM defaults";
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    ($form->{transdate}, $form->{closedto}, $form->{revtrans}) = $sth->fetchrow_array;
  }

  $sth->finish;

  # get chart of accounts
  $query = qq|SELECT accno,description
              FROM chart
	      WHERE charttype = 'A' and accno like '$account%'
              ORDER by accno|;
  $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
 # $form->dberror($query);
  $form->{chart} = "";
 # $form->{chart2} = "";
  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
    $form->{chart} .= "<option value='$ref->{accno}--$ref->{description}'>$ref->{accno}--$ref->{description}\n";
  }
  $sth->finish;

  $dbh->disconnect;

}

sub transaction {
  my ($self, $myconfig, $form) = @_;

  my ($query, $sth);

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

if ($form->{id}) {
    $query = "SELECT closedto, revtrans
              FROM defaults";
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);




    ($form->{closedto}, $form->{revtrans}) = $sth->fetchrow_array;
    $sth->finish;

    $query = "SELECT source, description, transdate,batch,project,subb,transno,transtype,subtransno
              FROM gl
	      WHERE id = $form->{id}";
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    ($form->{source}, $form->{description}, $form->{transdate}, $form->{batch}, $form->{project}, $form->{subb}, $form->{transno}, $form->{transtype}, $form->{subtransno}) = $sth->fetchrow_array;
    $sth->finish;



    # retrieve individual rows
    $query = "SELECT chart.accno, amount,chart.description
	      FROM acc_trans, chart
	      WHERE acc_trans.chart_id = chart.id
	      AND trans_id = $form->{id}
	      ORDER BY accno";
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
      push @{ $form->{GL} }, $ref;
    }
  } else {
    $query = "SELECT current_date AS transdate, closedto, revtrans
              FROM defaults";
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    ($form->{transdate}, $form->{closedto}, $form->{revtrans}) = $sth->fetchrow_array;
  }

  $sth->finish;

  # get chart of accounts
  $query = qq|SELECT accno,description
              FROM chart
	      WHERE charttype = 'A'
              ORDER by accno|;
  $sth = $dbh->prepare($query);
  $sth->execute || $form->dberror($query);
  $form->{chart} = "";
  $form->{chart2} = "";
  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
    $form->{chart} .= "$ref->{accno}--$ref->{description}\n";
    $form->{chart2} .= "<option value='$ref->{accno}--$ref->{description}'>$ref->{accno}--$ref->{description}\n";
    $form->{chart1} .= "<option value='$ref->{accno}--$ref->{description}'>$ref->{accno}--$ref->{description}\n";
  }
  $sth->finish;

  $dbh->disconnect;

}

sub transaction_template {
  my ($self, $myconfig, $form) = @_;

  my ($query, $sth);

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  if ($form->{id}) {
#    $query = "SELECT closedto, revtrans
#              FROM defaults";
#    $sth = $dbh->prepare($query);
#    $sth->execute || $form->dberror($query);

#    ($form->{closedto}, $form->{revtrans}) = $sth->fetchrow_array;
#    $sth->finish;

    $query = "SELECT id, name as template, debit, credit,current_date AS transdate,source 
              FROM quicktemplate
	      WHERE id = $form->{id}";
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

   # ($form->{id}, $form->{template}, $form->{debit}, $form->{credit}) = $sth->fetchrow_array;
 while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
    push @{ $form->{GL} }, $ref;
  }
    $sth->finish;

    # retrieve individual rows
 #   $query = "SELECT chart.accno, amount
#	      FROM acc_trans, chart
#	      WHERE acc_trans.chart_id = chart.id
#	      AND trans_id = $form->{id}
#	      ORDER BY accno";
#    $sth = $dbh->prepare($query);
#    $sth->execute || $form->dberror($query);

#    while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
#      push @{ $form->{GL} }, $ref;
#    }
  } else {
    $query = "SELECT current_date AS transdate, closedto, revtrans
              FROM defaults";
    $sth = $dbh->prepare($query);
    $sth->execute || $form->dberror($query);

    ($form->{transdate}, $form->{closedto}, $form->{revtrans}) = $sth->fetchrow_array;
  }

  $sth->finish;

  # get chart of accounts
#  $query = qq|SELECT accno,description
#              FROM chart
#	      WHERE charttype = 'A'
#              ORDER by accno|;
#  $sth = $dbh->prepare($query);
#  $sth->execute || $form->dberror($query);
#  $form->{chart} = "";
#  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {
#    $form->{chart} .= "$ref->{accno}--$ref->{description}\n";
#  }
#  $sth->finish;

  $dbh->disconnect;

}

1;

