#!/usr/sbin/dtrace -s

/*
 * USAGE    : ./query_time_breakdown.d
 *
 * DESCRIPTION:
 *   This script breaks down the time into parsing, planning, and execution
 *   for each query.
 *
 * AUTHOR     : Robert Lor <robert.lor@sun.com>
 *
 * $Header$
 */

#pragma D option quiet

postgresql*:::query-parse-start
{
	printf("Statement: %s\n", copyinstr(arg0));
	self->ts = timestamp;
}

postgresql*:::query-parse-done
/self->ts/
{
        printf("Query PARSING   time: %d\n", (timestamp - self->ts));
        self->follow = 1;
}

postgresql*:::query-plan-start
/self->follow/
{
	self->ts = timestamp;
}

postgresql*:::query-plan-done
/self->follow/
{
        printf("Query PLANNING  time: %d\n", (timestamp - self->ts));
}

postgresql*:::query-execute-start
/self->follow/
{
	self->ts = timestamp;
}

postgresql*:::query-execute-done
/self->follow/
{
        printf("Query EXECUTION time: %d\n\n", (timestamp - self->ts));
        self->follow = 0;
}
