#!/usr/sbin/dtrace -qs

/*
 * Usage      : write_size.d
 * Description: Show write size distribution by file descriptor
 * Author     : Robert Lor
 */

BEGIN
{
	endtime = timestamp + (5 * 1000000000ull);
}

syscall::write:entry
/ execname == "postgres" /
{
	@fd[arg0] = quantize(arg2);
}

END
{
        printf("\n%15s %15s\n","PID", "Write Count");
        printa("%15d %@15d\n",@fd);
}

/*
 * Run the script for ~10 secs and exit. Since there is processing time
 * before the probes are enabled and after they are disabled, endtime will be
 * be longer than the specified time, so adjust it accordingly.
 */
tick-1sec
/timestamp >= endtime/
{
	exit(0);
}
