/**
 * xpsql.c,v 1.1 2003/07/17 14:10:45 myui Exp
 * 
 * ----------------------
 *	Copyright (c) 2003	Makoto Yui <yuin@bb.din.or.jp>
 *  All rights reserved.
 */
/**
 * XMLPGSQL Copyright (C) 2001-2003 (Eurah) MediaFront Inc.
 *
 * This file includes part of XMLPGSQL.
 *
 * XMLPGSQL is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * XMLPGSQL is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with xpsql; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 
//#define __DEBUG__

#include <string.h>
//#include <stdlib.h>				/* realloc */
#include "xpsql.h"
#include "executor/spi.h"		/* for SPI_exec */
#include "commands/sequence.h"	/* for nextval() */
#include "lib/stringinfo.h"		/* for makeStringInfo() */
#include "mb/pg_wchar.h"

#define _SPI_CONN() connected=(SPI_connect()==SPI_ERROR_CONNECT)
#define _SPI_FIN() if(!connected)SPI_finish()

/**
 * exec_query
 *		-- internal function
 * 
 * Modified by Makoto Yui <yuin@bb.din.or.jp>
 */
int
exec_query(char *query)
{
	int ret;

#ifdef __DEBUG__
	elog(NOTICE, "Query:%s", query);
#endif
	if ((ret = SPI_exec(query, 0)) < 0) {
		switch (ret) {
		  case -1:
			  elog(ERROR, "[SPI_ERROR_CONNECT] %s", query);break;
		  case -2:
			  elog(ERROR, "[SPI_ERROR_COPY] %s", query);break;
		  case -3:
			  elog(ERROR, "[SPI_ERROR_OPUNKNOWN] %s", query);break;
		  case -4:
			  elog(ERROR, "[SPI_ERROR_UNCONNECTED] %s", query);break;
		  case -5:
			  elog(ERROR, "[SPI_ERROR_CURSOR] %s", query);break;
		  case -6:
			  elog(ERROR, "[SPI_ERROR_ARGUMENT] %s", query);break;
		  case -7:
			  elog(ERROR, "[SPI_ERROR_PARAM] %s", query);break;
		  case -8:
			  elog(ERROR, "[SPI_ERROR_TRANSACTION] %s", query);break;
		  case -9:
			  elog(ERROR, "[SPI_ERROR_NOATTRIBUTE] %s", query);break;
		  case -10:
			  elog(ERROR, "[SPI_ERROR_NOOUTFUNC] %s", query);break;
		  case -11:
			  elog(ERROR, "[SPI_ERROR_TYPUNKNOWN] %s", query);break;
		  default:
			  elog(ERROR, "[SPI_ERROR_OTHER] %s", query);
		}
	}
#ifdef __DEBUG__
	elog(NOTICE, "[Result:%d]", ret);
#endif

	return ret;
}

/**
 * create_new_document:
 *		-- unspecified in DOM level 2, proprietary extention 
 * 
 * Author: Makoto Yui <yuin@bb.din.or.jp>
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(create_new_document);
Datum
create_new_document(PG_FUNCTION_ARGS)
{
	char *doc_file =
		DatumGetCString(DirectFunctionCall1(textout, PG_GETARG_DATUM(0)));
	int32 doc_id;
	int32 node_id;
	bool connected;
	bool isnull;
	Datum seqname;
	//Datum tmp;
	StringInfo str = makeStringInfo();

#ifdef __DEBUG__
	elog(NOTICE, "[create_new_document] DOCUMENT:%s", doc_file);
#endif

	_SPI_CONN();
	appendStringInfo(str,
					 "SELECT docid FROM xml_document WHERE name='%s' UNION ALL "
					 "SELECT coalesce(max(docid)+1,1) FROM xml_document",
					 doc_file);
	exec_query(str->data);
	initStringInfo(str);
	if (SPI_processed != 1) {
		_SPI_FIN();
		PG_RETURN_NULL();
	}
	else {

		doc_id =
			DatumGetInt32(SPI_getbinval
						  (SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1,
						   &isnull));

		appendStringInfo(str,
						 "INSERT INTO xml_document(docid,name) VALUES(%d,'%s')",
						 doc_id, doc_file);
		exec_query(str->data);
		initStringInfo(str);

		seqname =
			DirectFunctionCall1(textin, CStringGetDatum("xml_nodeid_seq"));
		DirectFunctionCall1(nextval, seqname);
		node_id = (int32) DatumGetInt64(DirectFunctionCall1(nextval, seqname));
		pfree(DatumGetTextP(seqname));

		appendStringInfo(str,
						 "INSERT INTO xml_node(id,kind,docid,pathid,dewey) VALUES(%d,'%d',%d,0,'{0,%d}');"
						 "INSERT INTO xml_node(id,kind,docid,pathid,dewey) VALUES(%d,'%d',%d,0,'{-1,%d}')",
						 node_id-1, KIND_ROOT, doc_id, doc_id,
						 node_id, KIND_DUMMY, doc_id, doc_id);
		exec_query(str->data);
		initStringInfo(str);

		//appendStringInfo(str, "INSERT INTO xml_path(pathid,pathexp) VALUES(0,'')");
		//exec_query(str->data);
		//initStringInfo(str);

		pfree(str);
		_SPI_FIN();
		PG_RETURN_INT32(node_id-1);
	}
}

/**
 * xml_tagid
 *		-- unspecified in DOM level 2, proprietary extention 
 * 
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(xml_tagid);
Datum
xml_tagid(PG_FUNCTION_ARGS)
{
	char *tag_name =
		DatumGetCString(DirectFunctionCall1(textout, PG_GETARG_DATUM(0)));
	int32 tag_id;
	bool connected;
	bool isnull;
	Datum seqname;
	StringInfo str = makeStringInfo();

#ifdef __DEBUG__
	elog(NOTICE, "[xml_tagid] TAG:%s", tag_name);
#endif
	_SPI_CONN();
	appendStringInfo(str, "SELECT tagid FROM xml_tag WHERE name='%s'",
					 tag_name);
	exec_query(str->data);
	initStringInfo(str);
	if (SPI_processed > 0) {
		tag_id =
			DatumGetInt32(SPI_getbinval
						  (SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1,
						   &isnull));
	}
	else {
		seqname =
			DirectFunctionCall1(textin, CStringGetDatum("xml_tagid_seq"));
		tag_id = (int32) DatumGetInt64(DirectFunctionCall1(nextval, seqname));
		pfree(DatumGetTextP(seqname));

#ifdef __DEBUG__
		elog(NOTICE, "TAG_ID:%d", tag_id);
#endif
		appendStringInfo(str, "INSERT INTO xml_tag VALUES(%d,'%s')",
						 tag_id, tag_name);
		exec_query(str->data);
		//initStringInfo(str);
	}
	pfree(str);
	_SPI_FIN();
	PG_RETURN_INT32(tag_id);
}

/**
 * xml_attid:
 *		-- unspecified in DOM level 2, proprietary extention 
 * 
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(xml_attid);
Datum
xml_attid(PG_FUNCTION_ARGS)
{
	char *att_name =
		DatumGetCString(DirectFunctionCall1(textout, PG_GETARG_DATUM(0)));
	int32 att_id;
	bool connected;
	bool isnull;
	Datum seqname;
	StringInfo str = makeStringInfo();

#ifdef __DEBUG__
	elog(NOTICE, "[xml_attid] ATTRIBUTE:%s", att_name);
#endif
	_SPI_CONN();
	appendStringInfo(str,
					 "SELECT tagid FROM xml_attribute WHERE name='%s'",
					 att_name);
	exec_query(str->data);
	initStringInfo(str);
	if (SPI_processed > 0)
		att_id =
			DatumGetInt32(SPI_getbinval
						  (SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1,
						   &isnull));
	else {
		seqname =
			DirectFunctionCall1(textin, CStringGetDatum("xml_attid_seq"));
		att_id = (int32) DatumGetInt64(DirectFunctionCall1(nextval, seqname));
		pfree(DatumGetTextP(seqname));

#ifdef __DEBUG__
		elog(NOTICE, "ATTRIBUE_ID:%d", att_id);
#endif
		appendStringInfo(str, "INSERT INTO xml_attribute VALUES(%d,'%s')",
						 att_id, att_name);
		exec_query(str->data);
		//initStringInfo(str);
	}
	pfree(str);
	_SPI_FIN();
	PG_RETURN_INT32(att_id);
}


/**
 * xml_nsid
 *		-- unspecified in DOM level 2, proprietary extention 
 *
 *  Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(xml_nsid);
Datum
xml_nsid(PG_FUNCTION_ARGS)
{
	char *ns_name =
		DatumGetCString(DirectFunctionCall1(textout, PG_GETARG_DATUM(0)));
	int32 ns_id;
	bool connected;
	bool isnull;
	Datum seqname;
	StringInfo str = makeStringInfo();

#ifdef __DEBUG__
	elog(NOTICE, "[xml_nsid] NS:%s", ns_name);
#endif

	_SPI_CONN();
	appendStringInfo(str,
					 "SELECT tagid FROM xml_namespace WHERE name='%s'",
					 ns_name);
	exec_query(str->data);
	initStringInfo(str);
	if (SPI_processed > 0)
		ns_id =
			DatumGetInt32(SPI_getbinval
						  (SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1,
						   &isnull));
	else {
		seqname =
			DirectFunctionCall1(textin, CStringGetDatum("xml_nsid_seq"));
		ns_id = (int32) DatumGetInt64(DirectFunctionCall1(nextval, seqname));
		pfree(DatumGetTextP(seqname));

#ifdef __DEBUG__
		elog(NOTICE, "NS_ID:%d", ns_id);
#endif
		appendStringInfo(str, "INSERT INTO xml_namespace VALUES(%d,'%s')",
						 ns_id, ns_name);
		exec_query(str->data);
		//initStringInfo(str);
	}
	pfree(str);
	_SPI_FIN();
	PG_RETURN_INT32(ns_id);
}


/**
 * xml_piid
 *		-- unspecified in DOM level 2, proprietary extention 
 * 
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(xml_piid);
Datum
xml_piid(PG_FUNCTION_ARGS)
{
	char *pi_name =
		DatumGetCString(DirectFunctionCall1(textout, PG_GETARG_DATUM(0)));
	int32 pi_id;
	bool connected;
	bool isnull;
	Datum seqname;
	StringInfo str = makeStringInfo();

#ifdef __DEBUG__
	elog(NOTICE, "[xml_piid] PI:%s", pi_name);
#endif
	_SPI_CONN();
	appendStringInfo(str, "SELECT tagid FROM xml_pi WHERE name='%s'",
					 pi_name);
	exec_query(str->data);
	initStringInfo(str);
	if (SPI_processed > 0)
		pi_id =
			DatumGetInt32(SPI_getbinval
						  (SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1,
						   &isnull));
	else {
		seqname =
			DirectFunctionCall1(textin, CStringGetDatum("xml_piid_seq"));
		pi_id = (int32) DatumGetInt64(DirectFunctionCall1(nextval, seqname));
		pfree(DatumGetTextP(seqname));

#ifdef __DEBUG__
		elog(NOTICE, "PI_ID:%d", pi_id);
#endif
		appendStringInfo(str, "INSERT INTO xml_pi VALUES(%d,'%s')", 
						 pi_id,pi_name);
		exec_query(str->data);
		//initStringInfo(str);
	}

	pfree(str);
	_SPI_FIN();
	PG_RETURN_INT32(pi_id);
}

/**
 * drop_document:
 *		-- unspecified in DOM level 2, proprietary extention
 * 
 * Modified by Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(drop_document);
Datum
drop_document(PG_FUNCTION_ARGS)
{
	char *doc_file =
		DatumGetCString(DirectFunctionCall1(textout, PG_GETARG_DATUM(0)));
	int32 doc_id;
	bool connected;
	bool isnull;
	StringInfo str = makeStringInfo();

#ifdef __DEBUG__
	elog(NOTICE, "[drop_document] DOCUMENT:%s", doc_file);
#endif

	_SPI_CONN();
	appendStringInfo(str, "SELECT docid FROM xml_document WHERE name='%s'",
					 doc_file);
	exec_query(str->data);
	initStringInfo(str);
	if (SPI_processed > 0) {
		doc_id =
				 DatumGetInt32(SPI_getbinval
							  (SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1,
							   &isnull));
		appendStringInfo(str,
						 "DELETE FROM xml_document WHERE docid=%d;DELETE FROM xml_node WHERE docid=%d",
						 doc_id, doc_id);
		exec_query(str->data);
		//initStringInfo(str);
		pfree(str);
		_SPI_FIN();
		PG_RETURN_BOOL(TRUE);
	}
	else {
		pfree(str);
		_SPI_FIN();
		PG_RETURN_BOOL(FALSE);
	}
}

/**
 * get_tagid:
 *		-- unspecified in DOM level 2, proprietary extention 
 * 
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(get_tagid);
Datum
get_tagid(PG_FUNCTION_ARGS)
{
	char *tag_name =
		DatumGetCString(DirectFunctionCall1(textout, PG_GETARG_DATUM(0)));
	int32 tag_id;
	bool connected;
	bool isnull;
	StringInfo str = makeStringInfo();

#ifdef __DEBUG__
	elog(NOTICE, "[get_tagid] TAG:%s", tag_name);
#endif
	_SPI_CONN();
	appendStringInfo(str, "SELECT tagid FROM xml_tag WHERE name='%s'",
					 tag_name);
	exec_query(str->data);
	//initStringInfo(str);
	if (SPI_processed > 0) {
		tag_id =
			DatumGetInt32(SPI_getbinval
						  (SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1,
						   &isnull));
		pfree(str);
		_SPI_FIN();
		PG_RETURN_INT32(tag_id);
	}
	else {
		pfree(str);
		_SPI_FIN();
		PG_RETURN_NULL();
	}
}

/**
 * get_attid:
 *		-- unspecified in DOM level 2, proprietary extention 
 * 
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(get_attid);
Datum
get_attid(PG_FUNCTION_ARGS)
{
	char *att_name =
		DatumGetCString(DirectFunctionCall1(textout, PG_GETARG_DATUM(0)));
	int32 att_id;
	bool connected;
	bool isnull;
	StringInfo str = makeStringInfo();

#ifdef __DEBUG__
	elog(NOTICE, "[get_attid] ATTRIBUTE:%s", att_name);
#endif

	_SPI_CONN();
	appendStringInfo(str,
					 "SELECT tagid FROM xml_attribute WHERE name='%s'",
					 att_name);
	exec_query(str->data);
	//initStringInfo(str);
	if (SPI_processed > 0) {
		att_id =
			DatumGetInt32(SPI_getbinval
						  (SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1,
						   &isnull));
		pfree(str);
		_SPI_FIN();
		PG_RETURN_INT32(att_id);
	}
	else {
		pfree(str);
		_SPI_FIN();
		PG_RETURN_NULL();
	}
}

/**
 * get_nsid:
 *		-- unspecified in DOM level 2, proprietary extention 
 * 
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(get_nsid);
Datum
get_nsid(PG_FUNCTION_ARGS)
{
	char *ns_name =
		DatumGetCString(DirectFunctionCall1(textout, PG_GETARG_DATUM(0)));
	int32 ns_id;
	bool connected;
	bool isnull;
	StringInfo str = makeStringInfo();

#ifdef __DEBUG__
	elog(NOTICE, "[get_nsid] TAG:%s", ns_name);
#endif

	_SPI_CONN();
	appendStringInfo(str,
					 "SELECT tagid FROM xml_namespace WHERE name='%s'",
					 ns_name);
	exec_query(str->data);
	//initStringInfo(str);
	if (SPI_processed > 0) {
		ns_id =
			DatumGetInt32(SPI_getbinval
						  (SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1,
						   &isnull));
		pfree(str);
		_SPI_FIN();
		PG_RETURN_INT32(ns_id);
	}
	else {
		pfree(str);
		_SPI_FIN();
		PG_RETURN_NULL();
	}
}

/**
 * get_piid:
 *		-- unspecified in DOM level 2, proprietary extention 
 * 
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(get_piid);
Datum
get_piid(PG_FUNCTION_ARGS)
{
	char *pi_name =
		DatumGetCString(DirectFunctionCall1(textout, PG_GETARG_DATUM(0)));
	int32 pi_id;
	bool connected;
	bool isnull;
	StringInfo str = makeStringInfo();

#ifdef __DEBUG__
	elog(NOTICE, "[get_piid] PI:%s", pi_name);
#endif

	_SPI_CONN();
	appendStringInfo(str, "SELECT tagid FROM xml_pi WHERE name='%s'",
					 pi_name);
	exec_query(str->data);
	//initStringInfo(str);
	if (SPI_processed > 0) {
		pi_id =
			DatumGetInt32(SPI_getbinval
						  (SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1,
						   &isnull));
		pfree(str);
		_SPI_FIN();
		PG_RETURN_INT32(pi_id);
	}
	else {
		pfree(str);
		_SPI_FIN();
		PG_RETURN_NULL();
	}
}

/**
 * Document.createElement(tagName)
 * 	-- DOM Level 2 core
 *
 * Description:  
 * 		Creates an element of the type specified. 
 * 		Note that the instance returned implements the Element interface, 
 * 		so attributes can be specified directly on the returned object.
 * 
 * Parameters: 
 * 		DOMString tagName  -  The name of the element type to instantiate. 
 * 							(Remember that for XML this is case-sensitive.)
 * 
 * Returns:  
 * 		Element -  A new Element object with the nodeName attribute set to tagName, 
 * 				and localName, prefix, and namespaceURI set to null.
 * 
 * Exceptions:  
 * 		DOMException INVALID_CHARACTER_ERR -- not yet impled
 * 		Raised if the specified name contains an illegal character.
 *  
 * Author: Makoto Yui <yuin@bb.din.or.jp>
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(createelement);
Datum
	createelement(PG_FUNCTION_ARGS)
{
	int32 doc_node=PG_GETARG_INT32(0);
	char *tag_name=DatumGetCString(DirectFunctionCall1(textout, PG_GETARG_DATUM(1)));
	//char *doc_id;
	int doc_id;
	int32 node_id;
	int32 dummy_id;
	bool connected;
	Datum seqname;
	StringInfo str = makeStringInfo();
	
#ifdef __DEBUG__
	elog(NOTICE,"[createElement] DOC_NODE:%d TAG:%s",doc_node,tag_name);
#endif
	_SPI_CONN();
	
	appendStringInfo(str, "SELECT docid FROM xml_node WHERE id = %d AND kind = '%d'",
					doc_node, KIND_ROOT);
	exec_query(str->data);
	initStringInfo(str);
	if(SPI_processed==0){
#ifdef __DEBUG__
		elog(NOTICE,"[createElement] Raising a DOMException,"
					"first argument must be document-node.");
#endif
		_SPI_FIN();
		PG_RETURN_NULL();
	}
	doc_id=atoi(SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1));

	seqname = DirectFunctionCall1(textin,CStringGetDatum("xml_nodeid_seq"));
	node_id = (int32) DatumGetInt64(DirectFunctionCall1(nextval,seqname));
	pfree(DatumGetTextP(seqname));
	
	seqname = DirectFunctionCall1(textin,CStringGetDatum("xml_node_dummy_seq"));
	dummy_id = (int32) DatumGetInt64(DirectFunctionCall1(nextval,seqname));
	pfree(DatumGetTextP(seqname));

#ifdef __DEBUG__
	elog(NOTICE,"NODE:%d",node_id);
#endif

	/* set node */
	appendStringInfo(str, "INSERT INTO xml_node(id,kind,docid,pathid,dewey,parent,tagid) "
						  "VALUES(%d,'%d',%d,%d,'{-1,%d,%d}',%d,xml_tagid('%s'));"
						  "INSERT INTO xml_path VALUES(%d,'#/%s','false')",
					node_id, KIND_ELEMENT, doc_id, node_id, doc_id, dummy_id, doc_node, tag_name,
					node_id, tag_name
				);
	exec_query(str->data);
	
	pfree(str);		
	_SPI_FIN();
	PG_RETURN_INT32(node_id);
}

/**
 * Document.createProcessingInstruction(target, data)
 *		-- DOM Level 2 core
 * 
 * Description:  
 * 		Creates a ProcessingInstruction node given the specified name and data strings.
 * 
 * Parameters:  
 * 		DOMString target  -  The target part of the processing instruction.
 * 		DOMString data  -  The data for the node.
 * 
 * Returns:  
 * 		ProcessingInstruction -  The new ProcessingInstruction object.
 * 
 * Exceptions:  
 * 		DOMException INVALID_CHARACTER_ERR
 * 			Raised if the specified target contains an illegal character. 
 * 		DOMException NOT_SUPPORTED_ERR
 * 			Raised if this document is an HTML document. 
 * 
 * Author: Makoto Yui <yuin@bb.din.or.jp>
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(createprocessinginstruction);
Datum
	createprocessinginstruction(PG_FUNCTION_ARGS)
{
	int32 doc_node=PG_GETARG_INT32(0);
	char *pi_name=DatumGetCString(DirectFunctionCall1(textout, PG_GETARG_DATUM(1)));
	char *pi_data=DatumGetCString(DirectFunctionCall1(textout, PG_GETARG_DATUM(2)));
	//char *doc_id;
	int doc_id;
	int32 node_id;
	int32 dummy_id;
	bool connected;
	Datum seqname;
	StringInfo str = makeStringInfo();
	
#ifdef __DEBUG__
	elog(NOTICE,"[createProcessingInstruction] DOC_NODE:%d PI_NAME:%s",doc_node,pi_name);
#endif
	_SPI_CONN();
	
	appendStringInfo(str, "SELECT docid FROM xml_node WHERE id = %d AND kind = '%d'",
					doc_node, KIND_ROOT);
	exec_query(str->data);
	initStringInfo(str);
	if(SPI_processed==0){
#ifdef __DEBUG__
		elog(NOTICE,"[createProcessingInstruction] Raising a DOMException,"
					"first argument must be document-node.");
#endif
		_SPI_FIN();
		PG_RETURN_NULL();
	}
	doc_id=atoi(SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1));

	seqname = DirectFunctionCall1(textin,CStringGetDatum("xml_nodeid_seq"));
	node_id = (int32) DatumGetInt64(DirectFunctionCall1(nextval,seqname));
	pfree(DatumGetTextP(seqname));

	seqname = DirectFunctionCall1(textin,CStringGetDatum("xml_node_dummy_seq"));
	dummy_id = (int32) DatumGetInt64(DirectFunctionCall1(nextval,seqname));
	pfree(DatumGetTextP(seqname));

#ifdef __DEBUG__
	elog(NOTICE,"NODE:%d",node_id);
#endif

	appendStringInfo(str, "INSERT INTO xml_node(id,kind,docid,pathid,dewey,parent,tagid,value) "
						  "VALUES(%d, '%d', %d, %d, '{-1,%d,%d}', %d, xml_piid('%s'), '%s');"
						  "INSERT INTO xml_path VALUES(%d,'#/processing-instruction()','false')",
					node_id, KIND_PI, doc_id, node_id, doc_id, dummy_id, doc_node, pi_name, pi_data,
					node_id
				);
	exec_query(str->data);

	pfree(str);		
	_SPI_FIN();
	PG_RETURN_INT32(node_id);
}

/**
 * Document.createTextNode(data)
 *	-- DOM Level 2 core
 * 
 * Description:  
 * 		Creates a Text node given the specified string.
 * 
 * Parameters:  
 * 		DOMString data  -  The data for the node.
 * 
 * Returns:  
 * 		Text -  The new Text object.
 * 
 * Exceptions:  
 * 		none
 * 
 * Author: Makoto Yui <yuin@bb.din.or.jp>
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(createtextnode);
Datum
	createtextnode(PG_FUNCTION_ARGS)
{
	int32 doc_node=PG_GETARG_INT32(0);
	char *content=DatumGetCString(DirectFunctionCall1(textout, PG_GETARG_DATUM(1)));
	size_t len = strlen(content);
	//char *doc_id;
	int doc_id;
	int32 node_id;
	int32 dummy_id;
	bool connected;
	Datum seqname;
	StringInfo str = makeStringInfo();
	
#ifdef __DEBUG__
	elog(NOTICE,"[createTextNode] DOC_NODE:%d VALUE:%s",doc_node,content);
#endif
	_SPI_CONN();

	// escape string
	content = (char*) repalloc(content,(int)len*1.5);
	StrReplace(content,"\\","\\\\");
	StrReplace(content,"\'","\'\'");

	appendStringInfo(str, "SELECT docid FROM xml_node WHERE id = %d AND kind = '%d'",
					doc_node, KIND_ROOT);
	exec_query(str->data);
	initStringInfo(str);
	if(SPI_processed==0){
#ifdef __DEBUG__
		elog(NOTICE,"[createTextNode] Raising a DOMException,"
					"first argument must be document-node.");
#endif
		_SPI_FIN();
		PG_RETURN_NULL();
	}
	doc_id=atoi(SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1));

	seqname = DirectFunctionCall1(textin,CStringGetDatum("xml_nodeid_seq"));
	node_id = (int32) DatumGetInt64(DirectFunctionCall1(nextval,seqname));
	pfree(DatumGetTextP(seqname));

	seqname = DirectFunctionCall1(textin,CStringGetDatum("xml_node_dummy_seq"));
	dummy_id = (int32) DatumGetInt64(DirectFunctionCall1(nextval,seqname));
	pfree(DatumGetTextP(seqname));

#ifdef __DEBUG__
	elog(NOTICE,"NODE:%d",node_id);
#endif

	appendStringInfo(str, "INSERT INTO xml_node(id,kind,docid,pathid,dewey,parent,value) "
						  "VALUES(%d, '%d', %d, %d, '{-1,%d,%d}', %d, '%s');"
						  "INSERT INTO xml_path VALUES(%d,'#/text()','false')",
					node_id, KIND_TEXT, doc_id, node_id, doc_id, dummy_id, doc_node, content,
					node_id);
	exec_query(str->data);

	pfree(str);		
	_SPI_FIN();
	PG_RETURN_INT32(node_id);
}

/**
 * Document.createComment(data)
 *		-- DOM Level 2 core
 *
 * Description:  
 * 		Creates a Comment node given the specified string.
 * 
 * Parameters:  
 * 		DOMString data  -  The data for the node.
 * 
 * Returns:  
 * 		Comment -  The new Comment object.
 * 
 * Exceptions:  
 * 		none
 * 
 * Author: Makoto Yui <yuin@bb.din.or.jp>
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(createcomment);
Datum
	createcomment(PG_FUNCTION_ARGS)
{
	int32 doc_node=PG_GETARG_INT32(0);
	char *content=DatumGetCString(DirectFunctionCall1(textout, PG_GETARG_DATUM(1)));
	//char *doc_id;
	int doc_id;
	int32 node_id;
	int32 dummy_id;
	bool connected;
	Datum seqname;
	StringInfo str = makeStringInfo();
	
#ifdef __DEBUG__
	elog(NOTICE,"[createComment] DOC_NODE:%d VALUE:%s",doc_node,content);
#endif
	_SPI_CONN();

	appendStringInfo(str, "SELECT docid FROM xml_node WHERE id = %d AND kind = '%d'",
					doc_node, KIND_ROOT);
	exec_query(str->data);
	initStringInfo(str);
	if(SPI_processed==0){
#ifdef __DEBUG__
		elog(NOTICE,"[createComment] Raising a DOMException,"
					"first argument must be document-node.");
#endif
		_SPI_FIN();
		PG_RETURN_NULL();
	}
	doc_id=atoi(SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1));

	seqname = DirectFunctionCall1(textin,CStringGetDatum("xml_nodeid_seq"));
	node_id = (int32) DatumGetInt64(DirectFunctionCall1(nextval,seqname));
	pfree(DatumGetTextP(seqname));

	seqname = DirectFunctionCall1(textin,CStringGetDatum("xml_node_dummy_seq"));
	dummy_id = (int32) DatumGetInt64(DirectFunctionCall1(nextval,seqname));
	pfree(DatumGetTextP(seqname));

#ifdef __DEBUG__
	elog(NOTICE,"NODE:%d",node_id);
#endif

	appendStringInfo(str, "INSERT INTO xml_node(id,kind,docid,pathid,dewey,parent,value) "
						  "VALUES(%d, '%d', %d, %d, '{-1,%d,%d}', %d, '%s');"
						  "INSERT INTO xml_path VALUES(%d,'#/comment()','false')",
					node_id, KIND_COMMENT, doc_id, node_id, doc_id, dummy_id, doc_node, content,
					node_id
				);
	exec_query(str->data);
	
	pfree(str);		
	_SPI_FIN();
	PG_RETURN_INT32(node_id);
}

/**
 * new_childElement
 *		-- unspecified in DOM level 2, proprietary extention
 * 
 * Author: Makoto Yui <yuin@bb.din.or.jp>
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(new_childelement);
Datum
new_childelement(PG_FUNCTION_ARGS)
{
	int32 parent_id = PG_GETARG_INT32(0);
	char *tag_name =
		DatumGetCString(DirectFunctionCall1(textout, PG_GETARG_DATUM(1)));
	char *doc_id;
	int32 node_id;
	bool connected;
	Datum seqname;
	StringInfo str = makeStringInfo();

#ifdef __DEBUG__
	elog(NOTICE, "[new_childElement] PARENT:%d TAG:%s", parent_id, tag_name);
#endif
	_SPI_CONN();

	/*
	 * Error check routine for DOMException, HIERARCHY_REQUEST_ERR
	 */
	appendStringInfo(str, "SELECT docid FROM xml_node "
					 "WHERE id = %d AND (kind = '%d' OR (kind = '%d' AND child IS NULL))",
					 parent_id, KIND_ELEMENT, KIND_ROOT);
	exec_query(str->data);
	initStringInfo(str);
	if (SPI_processed == 0) {
		_SPI_FIN();
		PG_RETURN_NULL();
	}
	doc_id = SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1);

	seqname = DirectFunctionCall1(textin, CStringGetDatum("xml_nodeid_seq"));
	node_id = (int32) DatumGetInt64(DirectFunctionCall1(nextval, seqname));
	pfree(DatumGetTextP(seqname));

#ifdef __DEBUG__
	elog(NOTICE, "NODE:%d", node_id);
#endif

	/*
	 * SET node info
	 */
	appendStringInfo(str,
					 "INSERT INTO xml_node(id,kind,docid,pathid,tagid) "
					 "VALUES(%d,'%d',%s,%d,xml_tagid('%s'))", 
					 node_id, KIND_ELEMENT, doc_id, node_id, tag_name);
	exec_query(str->data);
	//initStringInfo(str);

	/*
	 * SET parent-child link
	 */
	DirectFunctionCall2(appendchild, Int32GetDatum(parent_id),
						Int32GetDatum(node_id));

	pfree(str);
	_SPI_FIN();
	PG_RETURN_INT32(node_id);
}

/**
 * new_childPi:
 *		-- unspecified in DOM level 2, proprietary extention
 * 
 * Author: Makoto Yui <yuin@bb.din.or.jp>
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(new_childpi);
Datum
new_childpi(PG_FUNCTION_ARGS)
{
	int32 parent_id = PG_GETARG_INT32(0);
	char *pi_name =
		DatumGetCString(DirectFunctionCall1(textout, PG_GETARG_DATUM(1)));
	char *pi_data =
		DatumGetCString(DirectFunctionCall1(textout, PG_GETARG_DATUM(2)));
	char *doc_id;
	int32 node_id;
	bool connected;
	Datum seqname;
	StringInfo str = makeStringInfo();

#ifdef __DEBUG__
	elog(NOTICE, "[new_childPi] PARENT:%d PI_NAME:%s", parent_id, pi_name);
#endif

	_SPI_CONN();
	appendStringInfo(str,
					 "SELECT docid FROM xml_node WHERE id=%d AND kind='%d'",
					 parent_id, KIND_ELEMENT);
	exec_query(str->data);
	initStringInfo(str);
	if (SPI_processed == 0) {
		_SPI_FIN();
		PG_RETURN_NULL();
	}
	doc_id = SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1);

	seqname = DirectFunctionCall1(textin, CStringGetDatum("xml_nodeid_seq"));
	node_id = (int32) DatumGetInt64(DirectFunctionCall1(nextval, seqname));
	pfree(DatumGetTextP(seqname));

#ifdef __DEBUG__
	elog(NOTICE, "NODE:%d", node_id);
#endif

	appendStringInfo(str,
					 "INSERT INTO xml_node(id,kind,docid,pathid,tagid,value) "
					 "VALUES(%d, '%d', %s, %d, xml_piid('%s'), '%s');",
					 node_id, KIND_PI, doc_id, node_id, pi_name, pi_data);
	exec_query(str->data);
	//initStringInfo(str);

	DirectFunctionCall2(appendchild, Int32GetDatum(parent_id),
						Int32GetDatum(node_id));

	pfree(str);
	_SPI_FIN();
	PG_RETURN_INT32(node_id);
}

/**
 * new_childText:
 *		-- unspecified in DOM level 2, proprietary extention
 * 
 * Author: Makoto Yui <yuin@bb.din.or.jp>
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(new_childtext);
Datum
new_childtext(PG_FUNCTION_ARGS)
{
	int32 parent_id = PG_GETARG_INT32(0);
	char *content =
		DatumGetCString(DirectFunctionCall1(textout, PG_GETARG_DATUM(1)));
	size_t len = strlen(content);
	char *doc_id;
	int32 node_id;
	bool connected;
	Datum seqname;
	StringInfo str = makeStringInfo();

#ifdef __DEBUG__
	elog(NOTICE, "[new_childText] PARENT:%d CONTENT:%s", parent_id,
		 content);
#endif
	_SPI_CONN();

	// escape string
	content = (char*) repalloc(content,(int)len*1.5);
	StrReplace(content,"\\","\\\\");
	StrReplace(content,"\'","\'\'");
	
	appendStringInfo(str,
					 "SELECT docid FROM xml_node WHERE id=%d AND kind='%d'",
					 parent_id, KIND_ELEMENT);
	exec_query(str->data);
	initStringInfo(str);
	if (SPI_processed == 0) {
		_SPI_FIN();
		PG_RETURN_NULL();
	}
	doc_id = SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1);

	seqname = DirectFunctionCall1(textin, CStringGetDatum("xml_nodeid_seq"));
	node_id = (int32) DatumGetInt64(DirectFunctionCall1(nextval, seqname));
	pfree(DatumGetTextP(seqname));

#ifdef __DEBUG__
	elog(NOTICE, "NODE:%d", node_id);
#endif

	appendStringInfo(str,
					 "INSERT INTO xml_node(id,kind,docid,pathid,value) "
					 "VALUES(%d, '%d', %s, %d, '%s')", 
					 node_id, KIND_TEXT, doc_id, node_id, content);
	exec_query(str->data);
	//initStringInfo(str);
	DirectFunctionCall2(appendchild, Int32GetDatum(parent_id),
						Int32GetDatum(node_id));

	pfree(str);
	pfree(content);
	_SPI_FIN();
	PG_RETURN_INT32(node_id);
}

/**
 * new_childComment:
 *		-- unspecified in DOM level 2, proprietary extention
 * 
 * Author: Makoto Yui <yuin@bb.din.or.jp>
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(new_childcomment);
Datum
new_childcomment(PG_FUNCTION_ARGS)
{
	int32 parent_id = PG_GETARG_INT32(0);
	char *content =
		DatumGetCString(DirectFunctionCall1(textout, PG_GETARG_DATUM(1)));
	char *doc_id;
	int32 node_id;
	bool connected;
	Datum seqname;
	StringInfo str = makeStringInfo();

#ifdef __DEBUG__
	elog(NOTICE, "[new_childComment] PARENT:%d CONTENT:%s", parent_id,
		 content);
#endif
	_SPI_CONN();
	appendStringInfo(str,
					 "SELECT docid FROM xml_node WHERE id=%d AND kind='%d'",
					 parent_id, KIND_ELEMENT);
	exec_query(str->data);
	initStringInfo(str);
	if (SPI_processed == 0) {
		_SPI_FIN();
		PG_RETURN_NULL();
	}
	doc_id = SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1);

	seqname = DirectFunctionCall1(textin, CStringGetDatum("xml_nodeid_seq"));
	node_id = (int32) DatumGetInt64(DirectFunctionCall1(nextval, seqname));
	pfree(DatumGetTextP(seqname));

#ifdef __DEBUG__
	elog(NOTICE, "NODE:%d", node_id);
#endif

	appendStringInfo(str,
					 "INSERT INTO xml_node(id,kind,docid,pathid,value) "
					 "VALUES(%d, '%d', %s, %d, '%s')", 
					 node_id, KIND_COMMENT, doc_id, node_id, content);
	exec_query(str->data);
	//initStringInfo(str);

	DirectFunctionCall2(appendchild, Int32GetDatum(parent_id),
						Int32GetDatum(node_id));

	pfree(str);
	_SPI_FIN();
	PG_RETURN_INT32(node_id);
}

/**
 * setAttribute:
 * 
 * Description: 
 * 		Adds a new attribute. 
 * 
 * Parameters:  
 * 		DOMString name  -  The name of the attribute to create or alter.
 * 		DOMString value  -  Value to set in string form.
 * 
 * Returns:  
 * 		attid
 * 
 * Modified by Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(setattribute);
Datum
setattribute(PG_FUNCTION_ARGS)
{
	int32 parent_id = PG_GETARG_INT32(0);
	char *att_name =
		DatumGetCString(DirectFunctionCall1(textout, PG_GETARG_DATUM(1)));
	char *att_value =
		DatumGetCString(DirectFunctionCall1(textout, PG_GETARG_DATUM(2)));
	char *doc_id;
	int32 node_id;
	bool connected;
	bool isnull;
	Datum seqname;
	StringInfo str = makeStringInfo();

#ifdef __DEBUG__
	elog(NOTICE, "[setAttribute] PARENT:%d ATT_NAME:%s", parent_id,
		 att_name);
#endif

	_SPI_CONN();
	appendStringInfo(str,
					 "SELECT id FROM xml_node WHERE kind='%d' AND parent=%d AND tagid=get_attid('%s')",
					 KIND_ATTRIBUTE, parent_id, att_name);
	exec_query(str->data);
	initStringInfo(str);
	if (SPI_processed > 0) {
		node_id =
			DatumGetInt32(SPI_getbinval
						  (SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1,
						   &isnull));
		appendStringInfo(str, "UPDATE xml_node SET value='%s' WHERE id=%d",
						 att_value, node_id);
		exec_query(str->data);
		//initStringInfo(str);
	}
	else {
		appendStringInfo(str, "SELECT docid FROM xml_node WHERE id=%d",
						 parent_id);
		exec_query(str->data);
		initStringInfo(str);
		if (SPI_processed == 0) {
			_SPI_FIN();
			PG_RETURN_NULL();
		}
		doc_id =
			SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1);

		seqname =
			DirectFunctionCall1(textin, CStringGetDatum("xml_nodeid_seq"));
		node_id = (int32) DatumGetInt64(DirectFunctionCall1(nextval, seqname));
		pfree(DatumGetTextP(seqname));

		appendStringInfo(str,
						 "INSERT INTO xml_node(id,kind,docid,pathid,tagid,value) "
						 "VALUES(%d, '%d', %s, %d, xml_attid('%s'), '%s')",
						 node_id, KIND_ATTRIBUTE, doc_id, node_id, att_name, att_value);
		exec_query(str->data);
		initStringInfo(str);
		appendStringInfo(str,
						 "UPDATE xml_node SET parent = %d WHERE id = %d",
						 parent_id, node_id);
		exec_query(str->data);
		//initStringInfo(str);
	}

	pfree(str);
	_SPI_FIN();
	PG_RETURN_INT32(node_id);
}

/**
 * setNamespace
 *		-- unspecified in DOM level 2, proprietary extention 
 * 
 * Author: Makoto Yui <yuin@bb.din.or.jp>
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(setnamespace);
Datum
setnamespace(PG_FUNCTION_ARGS)
{
	int32 parent_id = PG_GETARG_INT32(0);
	char *ns_name;
	char *ns_value;
	char *doc_id;
	int32 node_id;
	bool connected;
	bool isnull;
	bool default_ns;
	Datum seqname;
	StringInfo str = makeStringInfo();
	
	if (fcinfo->nargs == 3)
	{
		default_ns=FALSE;
		ns_name=DatumGetCString(DirectFunctionCall1(textout, PG_GETARG_DATUM(1)));
		ns_value=DatumGetCString(DirectFunctionCall1(textout, PG_GETARG_DATUM(2)));	
	}
	else if(fcinfo->nargs == 2)
	{
		default_ns=TRUE;
		ns_name="xmlns";
		ns_value=DatumGetCString(DirectFunctionCall1(textout, PG_GETARG_DATUM(1)));			
	}
	else
		PG_RETURN_NULL();

#ifdef __DEBUG__
	elog(NOTICE, "[setNamespace] PARENT:%d NS_NAME:%s", parent_id, ns_name);
#endif

	_SPI_CONN();
	appendStringInfo(str,
					 "SELECT id FROM xml_node WHERE kind='%d' AND parent=%d AND tagid=get_nsid('%s%s')",
					 KIND_NAMESPACE, parent_id, default_ns ? "": "xmlns:", ns_name);
	exec_query(str->data);
	initStringInfo(str);
	if (SPI_processed > 0) {
		node_id =
			DatumGetInt32(SPI_getbinval
						  (SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1,
						   &isnull));
		appendStringInfo(str, "UPDATE xml_node SET value='%s' WHERE id=%d",
						 ns_value, node_id);
		exec_query(str->data);
		//initStringInfo(str);
	}
	else {
		appendStringInfo(str, "SELECT docid FROM xml_node WHERE id=%d",
						 parent_id);
		exec_query(str->data);
		initStringInfo(str);
		if (SPI_processed == 0) {
			_SPI_FIN();
			PG_RETURN_NULL();
		}
		doc_id =
			SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1);

		seqname =
			DirectFunctionCall1(textin, CStringGetDatum("xml_nodeid_seq"));
		node_id = (int32) DatumGetInt64(DirectFunctionCall1(nextval, seqname));
		pfree(DatumGetTextP(seqname));

#ifdef __DEBUG__
		elog(NOTICE, "NODE:%d", node_id);
#endif

		appendStringInfo(str,
						 "INSERT INTO xml_node(id,kind,docid,tagid,value) "
						 "VALUES(%d,'%d',%s,xml_nsid('%s%s'),'%s')",
						 node_id, KIND_NAMESPACE, doc_id, default_ns ? "": "xmlns:", ns_name, ns_value);
		exec_query(str->data);
		initStringInfo(str);
		appendStringInfo(str,
						 "UPDATE xml_node SET parent = %d WHERE id = %d",
						 parent_id, node_id);
		exec_query(str->data);
		//initStringInfo(str);
	}

	pfree(str);
	_SPI_FIN();
	PG_RETURN_INT32(node_id);
}

/**
 * appendChild()
 * 		-- DOM Level2 Core
 * 
 * Description:
 * 		Adds the node newChild to the end of the list of children of this node. 
 * 
 * Parameters:  
 * 		Node newChild  -  The node to add. If it is a DocumentFragment object, 
 * 						the entire contents of the document fragment are moved 
 * 						into the child list of this node.
 * 
 * Returns:	
 * 		Node -  The node added.
 * 
 * Exceptions:  
 * 		DOMException HIERARCHY_REQUEST_ERR
 * 			Raised if this node is of a type that does not allow children 
 * 			of the type of the newChild node, or if the node to append is 
 * 			one of this node's ancestors or this node itself. 
 * 		DOMException WRONG_DOCUMENT_ERR
 * 			Raised if newChild was created from a different document than 
 * 			the one that created this node. 
 * 		DOMException NO_MODIFICATION_ALLOWED_ERR	-- not yet imple'd
 * 			Raised if this node is readonly or if the previous parent of 
 * 			the node being inserted is readonly. 
 * 
 * Author: Makoto Yui <yuin@bb.din.or.jp>
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(appendchild);
Datum
appendchild(PG_FUNCTION_ARGS)
{
	int32 parent_node_id = PG_GETARG_INT32(0);
	int32 node_id = PG_GETARG_INT32(1);
	int kind_code;
	bool connected;
	StringInfo str = makeStringInfo();

#ifdef __DEBUG__
	elog(NOTICE, "[appendChild] PARENT_ID:%d CHILD_ID:%d",
		 parent_node_id, node_id);
#endif

	_SPI_CONN();
	appendStringInfo(str, "SELECT kind FROM xml_node WHERE id=%d", node_id);
	exec_query(str->data);
	initStringInfo(str);
	if (SPI_processed == 0) {
		_SPI_FIN();
		PG_RETURN_BOOL(FALSE);
	}
	kind_code =
		atoi(SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1));

	if ((kind_code == KIND_ROOT) || (kind_code == KIND_ATTRIBUTE)
		|| (kind_code == KIND_NAMESPACE)) {
		_SPI_FIN();
		elog(ERROR,"[appendChild] Raising a DOMException, HIERARCHY_REQUEST_ERR.");
	}

	appendStringInfo(str, "UPDATE xml_node SET parent=%d WHERE id=%d",
					 parent_node_id, node_id);
	exec_query(str->data);
	initStringInfo(str);

	/*
	 * parent node has child ?
	 */
	appendStringInfo(str,
					 "SELECT id FROM xml_node WHERE id=%d AND child IS NOT NULL",
					 parent_node_id);
	exec_query(str->data);
	initStringInfo(str);

	if (SPI_processed > 0) {
		/*
		 * link from older brother
		 */
		appendStringInfo(str,
						 "UPDATE xml_node SET next=%d WHERE parent=%d and id!=%d and kind<>%d and kind<>%d and next is NULL",
						 node_id, parent_node_id, node_id, KIND_ATTRIBUTE,
						 KIND_NAMESPACE);
		exec_query(str->data);
		//initStringInfo(str);
	}
	else {
		/*
		 * link from parent
		 */
		appendStringInfo(str, "UPDATE xml_node SET child = %d WHERE id = %d",
						 node_id, parent_node_id);
		exec_query(str->data);
		//initStringInfo(str);
	}

	pfree(str);
	_SPI_FIN();
	PG_RETURN_BOOL(TRUE);
}

/**
 * insertBefore()
 * 		-- DOM Level2 Core
 * 
 * Description:
 * 		inserts the node newChild before the existing child node refChild. 
 * 		If refChild is null, insert newChild at the end of the list of children.
 * 
 * Parameters:  
 * 		Node newChild  -  The node to insert.
 *		Node refChild  -  The reference node, 
 * 							i.e., the node before which the new node must be inserted.
 * Returns:	
 * 		Node -  The node being inserted.  
 * 
 * Exceptions:
 * 		DOMException HIERARCHY_REQUEST_ERR
 * 			Raised if this node is of a type that does not allow children of the type 
 * 			of the newChild node, or if the node to insert is one of this node's ancestors 
 * 			or this node itself. 
 * 		DOMException WRONG_DOCUMENT_ERR			 -- diffrent specification with DOM
 * 			Raised if newChild was created from a different document than the one that 
 * 			created this node. 
 * 		DOMException NO_MODIFICATION_ALLOWED_ERR -- not yet implemented
 * 			Raised if this node is readonly or if the parent of the node being inserted is 
 * 			readonly. 
 * 		DOMException NOT_FOUND_ERR				 -- not yet implemented
 * 			Raised if refChild is not a child of this node. 
 * 
 * Author: Makoto Yui <yuin@bb.din.or.jp>
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(insertbefore);
Datum
	insertbefore(PG_FUNCTION_ARGS)
{
	int32 newChild;
//	int32 thisNode;
	int refChild;
	int child_id;
	char *parent_id,*ref_doc;
	int kind_code;
	bool connected;
//	bool hierarchyCheck=FALSE;
	StringInfo str = makeStringInfo();

/*
	if(fcinfo->nargs==3){
		hierarchyCheck = TRUE;
		thisNode = PG_GETARG_INT32(0);
		newChild = PG_GETARG_INT32(1);
		refChild = (int) PG_GETARG_INT32(2);
	}
	else{
*/
		newChild = PG_GETARG_INT32(0);
		refChild = (int) PG_GETARG_INT32(1);	
//	}

#ifdef __DEBUG__
	elog(NOTICE,"[insertBefore] InsertNode:%d BeforeNode:%d",newChild,refChild);
#endif

	_SPI_CONN();

	/**
	 * HIERARCHY_REQUEST_ERR 
	 */
	appendStringInfo(str,"select kind,docid,parent from xml_node where id=%d", refChild);
	exec_query(str->data);
	initStringInfo(str);
		
	if(SPI_processed==0){
		_SPI_FIN();
		PG_RETURN_BOOL(FALSE);
	}
	kind_code =
		atoi(SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1));

	if((kind_code==KIND_ROOT)||(kind_code==KIND_ATTRIBUTE)||(kind_code==KIND_NAMESPACE)){
		_SPI_FIN();
		PG_RETURN_BOOL(FALSE);
	}

	ref_doc=SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 2);
	parent_id=SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 3);

	if(parent_id==NULL){
#ifdef __DEBUG__
		elog(NOTICE,"Parent is NULL:%d",refChild);
#endif
		_SPI_FIN();
		PG_RETURN_BOOL(FALSE);
	}

	/* new node will be first-child of the parent ? */
	appendStringInfo(str,"select child from xml_node where id=%s and docid=%s",parent_id,ref_doc);
	exec_query(str->data);
	initStringInfo(str);
	
	if(SPI_processed==0){
		_SPI_FIN();
		PG_RETURN_BOOL(FALSE);
	}

	child_id = atoi(SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1));
	
	if( refChild==child_id){
		/* if firstchild */
		appendStringInfo(str,"update xml_node set child=%d where id=%s;"
				   			 "update xml_node set docid=%s, parent=%s, next=%d where id=%d",
						newChild,parent_id, ref_doc, parent_id, refChild, newChild);
		exec_query(str->data);

	}
	else{
		/* modify older brother's link info */
		appendStringInfo(str,"update xml_node set next=%d where id=(select id from xml_node where next=%d);"
				   			 "update xml_node set docid=%s, parent=%s, next=%d where id=%d",
				   		newChild, refChild, ref_doc, parent_id, refChild, newChild);
		exec_query(str->data);
	}

	pfree(str);
	_SPI_FIN();
	PG_RETURN_BOOL(TRUE);
}



/**
 * stringValue
 * 		-- XPath 1.0
 *
 * Author: Makoto Yui <yuin@bb.din.or.jp>
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 */
PG_FUNCTION_INFO_V1(stringvalue);
Datum
stringvalue(PG_FUNCTION_ARGS)
{
	int32 node_id = PG_GETARG_INT32(0);
	bool connected;
	int kind;
	int length;
	char *d_order;
	char *ret_text;
	bool isnull;
	struct varlena *p;
	StringInfo str = makeStringInfo();

#ifdef __DEBUG__
	elog(NOTICE, "[stringValue] NODE_ID:%d", node_id);
#endif

	_SPI_CONN();
	appendStringInfo(str, "SELECT "
					 			"xn.kind,xn.dewey "
					 		"FROM " 
					 			"xml_node xn " 
					 		"WHERE " 
					 			"xn.id = %d", 
					 		node_id);
	exec_query(str->data);
	initStringInfo(str);

	if (SPI_processed == 0) {
		_SPI_FIN();
		PG_RETURN_NULL();
	}
	kind = (int)
		DatumGetInt16(SPI_getbinval
					  (SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1,
					   &isnull));
	d_order = SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 2);

	switch (kind) {
	  case KIND_ROOT:
	  case KIND_ELEMENT:
		  appendStringInfo(str, "SELECT "
						   			"list(Q.value) "
						   		"FROM "
								   "(SELECT "
								   		"value "
								   "FROM "
								   		"xml_node "
								   "WHERE "
								   		"kind='%d' AND "
								   		"_int_descendant(dewey,'%s') "
								   "ORDER BY " 
								   		"dewey" 
								   	") AS Q", 
						   KIND_TEXT, d_order);
		  exec_query(str->data);
		  //initStringInfo(str);
		  break;
	  case KIND_TEXT:
	  case KIND_COMMENT:
	  case KIND_ATTRIBUTE:
	  case KIND_NAMESPACE:
	  case KIND_PI:
		  appendStringInfo(str, "SELECT value FROM xml_node WHERE id = %d",
						   node_id);
		  exec_query(str->data);
		  //initStringInfo(str);
		  break;
	}

	if (SPI_processed == 0) {
		_SPI_FIN();
		PG_RETURN_NULL();
	}

	pfree(str);
	ret_text = SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1);
	_SPI_FIN();
	length = strlen(ret_text);
	p = palloc(length + VARHDRSZ);
	p->vl_len = length + VARHDRSZ;
	memcpy(VARDATA(p), ret_text, length);
	PG_RETURN_TEXT_P(p);
}

/*
 *  StrReplace - replace string
 *  
 * 	this function needs care for handring, buffer overflow
 */
static int
StrReplace(char *ap, const char *bp, const char *cp)
{
	int bs, cs, rc;
	char *limit;

	rc = 0;
	bs = strlen(bp);
	cs = strlen(cp);
	limit = ap + strlen(ap) - bs;

	while (ap <= limit)
	{
		if (strncmp(ap, bp, bs) == 0) 
		{
			memmove(ap + cs, ap + bs, limit - ap + 1);
			strncpy(ap, cp, cs);
			limit += cs - bs;
			rc++;
			ap += cs;
		}
		else
			ap++;
	}
	return rc;
}// streplace

/**
 * indent option
 * -bad -bap -cdb -br -nce -npcs -nbc -lp -cpn -nfca -fc1 -i4 -ci4 -cli2 -d4 -ts4
 * 
 * [c.h]
 * typedef signed int int32;               // Size 32bits 4byte (int4)
 * 
 * [limits.h]
 * define INT_MAX 2147483647
 */
