/*
* Disponible en http://www.kazak.ws
*
* Desarrollado por Soluciones KAZAK 
* Grupo de Investigacion y Desarrollo de Software Libre
* Santiago de Cali/Republica de Colombia 2001
*
* CLASS ExportToFile v 0.1                                                   
* Descripcion:
* Clase encargada de manejar el dialogo mediante el cual se
* define la operacion (importar/exportar) a realizar entre una tabla y un archivo.
*
* Preguntas, Comentarios y Sugerencias: xpg@kazak.ws
*                                                                   
* Fecha: 2001/10/01                                                 
*
* Autores: Beatriz Florin  - bettyflor@kazak.ws                    
*          Gustavo Gonzalez - xtingray@kazak.ws                     
*/

import java.beans.*; 
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import java.util.Hashtable;
import java.util.Enumeration;
import java.util.Vector;
import java.io.*;

class ExportToFile extends JDialog implements ActionListener {

 Vector TableList;
 JFrame frame;
 JRadioButton tableToFileButton;
 JRadioButton fileToTableButton;
 Language idiom;
 boolean wellDone = false;
 int option = -1;
 int regs;

 public ExportToFile (JFrame aFrame,String table,PGConnection dbConn,Language lang,int numReg)
  {
  super(aFrame, true);
  idiom = lang;
  frame = aFrame;
  regs = numReg;

  setTitle(idiom.getWord("COPY") + " " + idiom.getWord("DATA"));

  JPanel global = new JPanel();
  global.setLayout(new BoxLayout(global,BoxLayout.Y_AXIS));


  /*** Construccin componentes de la ventana ***/
  //Creacion radio Button

  tableToFileButton = new JRadioButton(idiom.getWord("FTF"));
  tableToFileButton.setMnemonic('a'); 

  fileToTableButton = new JRadioButton(idiom.getWord("FFT"));
  fileToTableButton.setMnemonic('t'); 

  if(regs > 0)
   {
    tableToFileButton.setEnabled(true);
    tableToFileButton.setSelected(true);
   }
  else
   {
    tableToFileButton.setEnabled(false);
    fileToTableButton.setSelected(true);
   }

  ButtonGroup group = new ButtonGroup();
  group.add(tableToFileButton);
  group.add(fileToTableButton);
  
  JPanel rightTop = new JPanel();
  rightTop.setLayout(new BoxLayout(rightTop,BoxLayout.Y_AXIS));
  rightTop.add(tableToFileButton);
  rightTop.add(fileToTableButton);
  Border etched = BorderFactory.createEtchedBorder();
  TitledBorder title = BorderFactory.createTitledBorder(etched,idiom.getWord("COPY") + " " + idiom.getWord("DATA"));
  title.setTitleJustification(TitledBorder.LEFT);
  rightTop.setBorder(title);
  
  JPanel rightPanel = new JPanel();
  rightPanel.setLayout(new BoxLayout(rightPanel,BoxLayout.Y_AXIS));
  rightPanel.add(rightTop);
  
  /*** Unin de todos los componentes de la ventana ***/
  
  JPanel downPanel = new JPanel();
  downPanel.setLayout(new FlowLayout(FlowLayout.CENTER));
  downPanel.add(rightPanel);

  title = BorderFactory.createTitledBorder(etched);
  downPanel.setBorder(title);

  JButton ok = new JButton(idiom.getWord("OK"));
  ok.setActionCommand("ButtonOk");
  ok.addActionListener(this);

  JButton cancel = new JButton(idiom.getWord("CANCEL"));
  cancel.setActionCommand("ButtonCancel");
  cancel.addActionListener(this);

  JPanel botons = new JPanel();
  botons.setLayout(new FlowLayout(FlowLayout.CENTER));
  botons.add(ok);
  botons.add(cancel);

  global.add(downPanel); 
  global.add(botons);

  getContentPane().add(global);
 }

 public void actionPerformed(java.awt.event.ActionEvent e) 
 {

  if(e.getActionCommand().equals("ButtonCancel")) 
   {
     setVisible(false);
     return;
   }		

  if(e.getActionCommand().equals("ButtonOk")) 
   {
     if(tableToFileButton.isSelected())
      {
        option = 1;
      }

     if(fileToTableButton.isSelected())
      {
        option = 2;
      }

     wellDone = true;
     setVisible(false);
     return;
   }

 }

public boolean isWellDone()
 {
  return wellDone;
 } 

public int getOption()
 {
  return option;
 }

} //Fin de la Clase
