/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.xml.sax.AttributeList;
import org.xml.sax.helpers.AttributeListImpl;

public class RuntimeConfigurable {
    private String elementTag = null;
    private Vector children = new Vector();
    private Object wrappedObject = null;
    private AttributeList attributes;
    private StringBuffer characters = new StringBuffer();

    public RuntimeConfigurable(Object proxy, String elementTag) {
        this.wrappedObject = proxy;
        this.elementTag = elementTag;
    }

    void setProxy(Object proxy) {
        this.wrappedObject = proxy;
    }

    public void setAttributes(AttributeList attributes) {
        this.attributes = new AttributeListImpl(attributes);
    }

    public AttributeList getAttributes() {
        return this.attributes;
    }

    public void addChild(RuntimeConfigurable child) {
        this.children.addElement(child);
    }

    RuntimeConfigurable getChild(int index) {
        return (RuntimeConfigurable)this.children.elementAt(index);
    }

    public void addText(String data) {
        this.characters.append(data);
    }

    public void addText(char[] buf, int start, int count) {
        this.addText(new String(buf, start, count));
    }

    public String getElementTag() {
        return this.elementTag;
    }

    public void maybeConfigure(Project p) throws BuildException {
        String id = null;
        if (this.attributes != null) {
            ProjectHelper.configure(this.wrappedObject, this.attributes, p);
            id = this.attributes.getValue("id");
            this.attributes = null;
        }
        if (this.characters.length() != 0) {
            ProjectHelper.addText(p, this.wrappedObject, this.characters.toString());
            this.characters.setLength(0);
        }
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            RuntimeConfigurable child = (RuntimeConfigurable)enumeration.nextElement();
            if (child.wrappedObject instanceof Task) {
                Task childTask = (Task)child.wrappedObject;
                childTask.setRuntimeConfigurableWrapper(child);
                childTask.maybeConfigure();
            } else {
                child.maybeConfigure(p);
            }
            ProjectHelper.storeChild(p, this.wrappedObject, child.wrappedObject, child.getElementTag().toLowerCase(Locale.US));
        }
        if (id != null) {
            p.addReference(id, this.wrappedObject);
        }
    }
}

