/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FastHashMap
extends HashMap {
    protected HashMap map = null;
    protected boolean fast = false;

    public FastHashMap() {
        this.map = new HashMap();
    }

    public FastHashMap(int n) {
        this.map = new HashMap(n);
    }

    public FastHashMap(int n, float f) {
        this.map = new HashMap(n, f);
    }

    public FastHashMap(Map map) {
        this.map = new HashMap(map);
    }

    public boolean getFast() {
        return this.fast;
    }

    public void setFast(boolean bl) {
        this.fast = bl;
    }

    public void clear() {
        if (this.fast) {
            FastHashMap fastHashMap = this;
            synchronized (fastHashMap) {
                HashMap hashMap = (HashMap)this.map.clone();
                hashMap.clear();
                this.map = hashMap;
            }
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            this.map.clear();
        }
    }

    public Object clone() {
        FastHashMap fastHashMap = null;
        if (this.fast) {
            fastHashMap = new FastHashMap((Map)this.map);
        } else {
            HashMap hashMap = this.map;
            synchronized (hashMap) {
                fastHashMap = new FastHashMap((Map)this.map);
            }
        }
        fastHashMap.setFast(this.getFast());
        return fastHashMap;
    }

    public boolean containsKey(Object object) {
        if (this.fast) {
            return this.map.containsKey(object);
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            boolean bl = this.map.containsKey(object);
            return bl;
        }
    }

    public boolean containsValue(Object object) {
        if (this.fast) {
            return this.map.containsValue(object);
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            boolean bl = this.map.containsValue(object);
            return bl;
        }
    }

    public Set entrySet() {
        if (this.fast) {
            return this.map.entrySet();
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            Set set = this.map.entrySet();
            return set;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (this.fast) {
            if (map.size() != this.map.size()) {
                return false;
            }
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (!(v == null ? map.get(k) != null || !map.containsKey(k) : !v.equals(map.get(k)))) continue;
                return false;
            }
            return true;
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            if (map.size() != this.map.size()) {
                boolean bl = false;
                return bl;
            }
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (v == null) {
                    if (map.get(k) == null && map.containsKey(k)) continue;
                    boolean bl = false;
                    return bl;
                }
                if (v.equals(map.get(k))) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    public Object get(Object object) {
        if (this.fast) {
            return this.map.get(object);
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            Object v = this.map.get(object);
            return v;
        }
    }

    public int hashCode() {
        if (this.fast) {
            int n = 0;
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                n += ((Object)iterator.next()).hashCode();
            }
            return n;
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            int n = 0;
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                n += ((Object)iterator.next()).hashCode();
            }
            int n2 = n;
            return n2;
        }
    }

    public boolean isEmpty() {
        if (this.fast) {
            return this.map.isEmpty();
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            boolean bl = this.map.isEmpty();
            return bl;
        }
    }

    public Set keySet() {
        if (this.fast) {
            return this.map.keySet();
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            Set set = this.map.keySet();
            return set;
        }
    }

    public Object put(Object object, Object object2) {
        if (this.fast) {
            FastHashMap fastHashMap = this;
            synchronized (fastHashMap) {
                HashMap hashMap = (HashMap)this.map.clone();
                Object object3 = hashMap.put(object, object2);
                this.map = hashMap;
                Object object4 = object3;
                return object4;
            }
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            Object object5 = this.map.put(object, object2);
            return object5;
        }
    }

    public void putAll(Map map) {
        if (this.fast) {
            FastHashMap fastHashMap = this;
            synchronized (fastHashMap) {
                HashMap hashMap = (HashMap)this.map.clone();
                hashMap.putAll(map);
                this.map = hashMap;
            }
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            this.map.putAll(map);
        }
    }

    public Object remove(Object object) {
        if (this.fast) {
            FastHashMap fastHashMap = this;
            synchronized (fastHashMap) {
                HashMap hashMap = (HashMap)this.map.clone();
                Object v = hashMap.remove(object);
                this.map = hashMap;
                Object v2 = v;
                return v2;
            }
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            Object v = this.map.remove(object);
            return v;
        }
    }

    public int size() {
        if (this.fast) {
            return this.map.size();
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            int n = this.map.size();
            return n;
        }
    }

    public Collection values() {
        if (this.fast) {
            return this.map.values();
        }
        HashMap hashMap = this.map;
        synchronized (hashMap) {
            Collection collection = this.map.values();
            return collection;
        }
    }
}

