#include <netinet/in.h>
#include <arpa/inet.h>
#include <netinet/if_ether.h>
#include <net/ethernet.h>
#include <netinet/ether.h>
#include <netinet/ip.h>
#include <sys/time.h>
#include <pthread.h>
#include <unistd.h>

#include <iostream>
#include <map>
#include <list>

#include <pcap.h>

using namespace std;

#include "ip.h"
#include "prio.h"

ostream& operator<<(ostream &os, struct timeval tv) 
{
	struct tm *ti = localtime(&tv.tv_sec);

	os << ti->tm_hour << ":" << ti->tm_min << ":" << ti->tm_sec << "." << tv.tv_usec;
	return os;
}


CRecord::CRecord(const struct my_ip *ip, int volume)
			: ip_src_m(ip->ip_src), ip_dst_m(ip->ip_dst), ip_proto_m(ip->ip_p), volume_m(volume), packets_m(1)  {
		port_src_m =	ntohs(ip->port_src);
		port_dst_m =	ntohs(ip->port_dst);
		memset(&lastUpdate_m, 0, sizeof (lastUpdate_m));
		memset(&lastUpdate_m, 0, sizeof (firstUpdate_m));

}

ostream& operator<<(ostream &os, const CRecord *cr) {
	cout << "src " << inet_ntoa(cr->ip_src_m)
		<< " dst " << inet_ntoa(cr->ip_dst_m)
		<< " sprt " << cr->port_src_m
		<< " dprt " << cr->port_dst_m
		<< " prot " << (unsigned int)cr->ip_proto_m
		<< " vol " << cr->volume_m;
	if (cr->packets_m == 1) {
		cout << " " << cr->lastUpdate_m
			<< endl;
	} else {
		if (cr->lastUpdate_m.tv_sec != cr->firstUpdate_m.tv_sec)
			cout << " ovr " << cr->lastUpdate_m.tv_sec - cr->firstUpdate_m.tv_sec;
		else
			cout << " ovr " << cr->lastUpdate_m.tv_usec - cr->firstUpdate_m.tv_usec << " usec ";
		cout << " paks " << cr->packets_m
			<< " " << cr->firstUpdate_m
			<< " " << cr->lastUpdate_m
			<< endl;
	}
	return os;
}


RTable::RTable(int SleepTime, int dataLinkType) : SleepTime_m(SleepTime), dataLinkType_m(dataLinkType) {
	pthread_mutex_init(&mutex_m, NULL);
}

void	RTable::Add(CRecord *cr, struct timeval when) {

	pthread_mutex_lock(&mutex_m);
	CRecordMapIter		crmi = crm.find(cr);
	CRecord	*ncr;
	
	if (crmi == crm.end()) {
		ncr = new CRecord(*cr);	// TODO: make proper constructor
		// put this new record to the front of the list
		crl_m.push_front(ncr);
		// save the iterator into the 'second' of the map
		crm[ncr] = crl_m.begin();
		ncr->firstUpdate_m = when;
	} else {
		CRecordListIter crli = (*crmi).second;
		ncr = (*crli);
		ncr->volume_m += cr->volume_m;
		ncr->packets_m++;
		crl_m.erase(crli);
		crl_m.push_front(ncr);
		// iterator is still there and should be valid
		(*crmi).second = crl_m.begin();
		// move this node to the head
	}
	ncr->lastUpdate_m = when;
	pthread_mutex_unlock(&mutex_m);
	
}

ostream& operator<<(ostream &os, RTable& rtt) {
		pthread_mutex_lock(&rtt.mutex_m);
		for (CRecordListIter iter = rtt.crl_m.begin(); iter != rtt.crl_m.end(); iter++) {
			os << *iter << endl;
		}
		pthread_mutex_unlock(&rtt.mutex_m);
		return os;
}

void	RTable::Sleep() {
	sleep(SleepTime_m);
}

void	RTable::MakeListOfFlushItems(CRecordList *ulist, struct timeval *since) {
	pthread_mutex_lock(&mutex_m);
	for (CRecordListIter iter = crl_m.begin(); iter != crl_m.end();) {
		CRecord *cr = (*iter++); // increment iterator first as we delete this node
		// TODO: add u_sec
		// add exit when too far back
		if (cr->lastUpdate_m.tv_sec < since->tv_sec) {
			CRecordMapIter		crmi = crm.find(cr);
			if (crmi == crm.end()) {
				cerr << "shit: record was in list but not in the map!" << endl;
				exit(1);
			}
			crl_m.erase((*crmi).second); // remove from list
			crm.erase(crmi);			// remove from map
			ulist->push_back(cr);	// add to the outgoing list
		}
	}
	pthread_mutex_unlock(&mutex_m);
}


