drop table a_b;
drop table a;
drop table b;
drop table c;

-- simple table
create table a (
	id serial,
	foo text
);

-- needed for referential integrity later on...
create unique index i_a_id on a(id);

-- another simple table
create table b (
	id serial,
	bar int
);

create unique index i_b_id on b(id);

-- associative table to test replication with only one (wrongly) defined
-- key (a_id)
create table a_b (
	a_id int not null references a(id),
	b_id int not null references b(id),
	stamp timestamp default now(),
	primary key(a_id,b_id)
);

-- test replication with completly wrong key (foo)
create table c (
	id int not null,
	foo text,
	bar text,
	primary key(id)
);

-- another associative table
create table a_b_c (
	a_id int not null references a(id),
	b_id int not null references b(id),
	c_id int not null references c(id),
	primary key(a_id,b_id,c_id)
);

