import unittest, sys

class TypeTestCase(unittest.TestCase):
	def runTest(self):
		import Postgres
		textType = Postgres.Type("text")
		int4Type = Postgres.Type("int4")
		float4Type = Postgres.Type(700)
		float8Type = Postgres.Type(701)

		# instantiating objects
		text = textType("some text")
		i4 = int4Type("1234")
		i4 = int4Type(1234)
		f4 = float4Type(1234.123)
		f8 = float8Type(1234.123)

		# test casting
		f4totext = textType(f4)
		texttof4 = float4Type(f4totext)
		self.failUnless(str(f4totext) == str(texttof4))


sys.modules[__name__] = TypeTestCase
