import unittest, sys

class ObjTestCase(unittest.TestCase):
	def runTest(self):
		import Postgres
		# instantiation
		text = Postgres.Type("text")
		o = text("some text for testing")
		self.failUnless(type(o) == Postgres.Object)

		# raw instantiation
		ro = Postgres.Object(text, r'\xff\0\xf0foobar\nfeh')
		self.failUnless(str(ro) == r'\xff\0\xf0foobar\nfeh')

		# array indirection
		textArray = Postgres.Type("text[]")
		ta = textArray('foo', 'bar', 'feh')
		self.failUnless(str(ta[0]) == 'foo')
		self.failUnless(str(ta[1]) == 'bar')
		self.failUnless(str(ta[2]) == 'feh')

		# array mutation
		
		# custom type attributes

sys.modules[__name__] = ObjTestCase
