/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.util.logging.Logger;

public class SPIActions {
    static void log(String string) {
        if ("GNU libgcj".equals(System.getProperty("java.vm.name"))) {
            System.out.print("INFO: ");
            System.out.println(string);
        } else {
            Logger.getAnonymousLogger().info(string);
        }
    }

    public static int testSavepointSanity() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        SPIActions.log("Attempting to set an anonymous savepoint, expect to see an UnsupportedOperationException for versions prior to 8.0");
        try {
            Savepoint savepoint = connection.setSavepoint();
            try {
                Statement statement = connection.createStatement();
                SPIActions.log("Attempting to set a SAVEPOINT using SQL (should fail)");
                statement.execute("SAVEPOINT foo");
            }
            catch (SQLException sQLException) {
                SPIActions.log("It failed allright. Everything OK then");
                SPIActions.log("Rolling back to anonymous savepoint");
                connection.rollback(savepoint);
                return 1;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            SPIActions.log(unsupportedOperationException.getMessage());
            return 0;
        }
        throw new SQLException("SAVEPOINT through SQL succeeded. That's bad news!");
    }

    public static int testTransactionRecovery() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        SPIActions.log("Attempting to set an anonymous savepoint, expect to see an UnsupportedOperationException for versions prior to 8.0");
        try {
            Statement statement = connection.createStatement();
            Savepoint savepoint = connection.setSavepoint();
            try {
                SPIActions.log("Attempting to execute a statement with a syntax error");
                statement.execute("THIS MUST BE A SYNTAX ERROR");
            }
            catch (SQLException sQLException) {
                SPIActions.log("It failed. Let's try to recover by rolling back to anonymous savepoint");
                connection.rollback(savepoint);
                SPIActions.log("Rolled back.");
                SPIActions.log("Now let's try to execute a correct statement.");
                ResultSet resultSet = statement.executeQuery("SELECT 'OK'");
                while (resultSet.next()) {
                    SPIActions.log("Expected: OK; Retrieved: " + resultSet.getString(1));
                }
                resultSet.close();
                statement.close();
                return 1;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            SPIActions.log(unsupportedOperationException.getMessage());
            return 0;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int transferPeopleWithSalary(int n) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = null;
        Statement statement2 = null;
        Statement statement3 = null;
        ResultSet resultSet = null;
        try {
            int n2;
            String string = "SELECT id, name, salary FROM employees1 WHERE salary > ?";
            SPIActions.log(string);
            statement = connection.prepareStatement(string);
            string = "INSERT INTO employees2(id, name, salary, transferDay, transferTime) VALUES (?, ?, ?, ?, ?)";
            SPIActions.log(string);
            statement2 = connection.prepareStatement(string);
            string = "DELETE FROM employees1 WHERE id = ?";
            SPIActions.log(string);
            statement3 = connection.prepareStatement(string);
            SPIActions.log("assigning parameter value " + n);
            statement.setInt(1, n);
            SPIActions.log("Executing query");
            resultSet = statement.executeQuery();
            int n3 = 0;
            SPIActions.log("Doing next");
            while (resultSet.next()) {
                SPIActions.log("Processing row " + ++n3);
                n2 = resultSet.getInt(1);
                String string2 = resultSet.getString(2);
                int n4 = resultSet.getInt(3);
                statement2.setInt(1, n2);
                statement2.setString(2, string2);
                statement2.setInt(3, n4);
                long l = System.currentTimeMillis();
                statement2.setDate(4, new Date(l));
                statement2.setTime(5, new Time(l));
                int n5 = statement2.executeUpdate();
                SPIActions.log("Insert processed " + n5 + " rows");
                statement3.setInt(1, n2);
                n5 = statement3.executeUpdate();
                SPIActions.log("Delete processed " + n5 + " rows");
                SPIActions.log("Doing next");
            }
            if (n3 == 0) {
                SPIActions.log("No row found");
            }
            n2 = n3;
            return n2;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (statement2 != null) {
                statement2.close();
            }
            if (statement3 != null) {
                statement3.close();
            }
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int maxFromSetReturnExample(int n, int n2) throws SQLException {
        int n3 = Integer.MIN_VALUE;
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT base FROM setReturnExample(?, ?)");
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, n2);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                n = resultSet.getInt(1);
                if (n <= n3) continue;
                n3 = n;
            }
            int n4 = n;
            return n4;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDateAsString() throws SQLException {
        ResultSet resultSet = null;
        Statement statement = null;
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT CURRENT_DATE");
            if (resultSet.next()) {
                String string = resultSet.getDate(1).toString();
                return string;
            }
            String string = "Date could not be retrieved";
            return string;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimeAsString() throws SQLException {
        ResultSet resultSet = null;
        Statement statement = null;
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT CURRENT_TIME");
            if (resultSet.next()) {
                String string = resultSet.getTime(1).toString();
                return string;
            }
            String string = "Time could not be retrieved";
            return string;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
            connection.close();
        }
    }
}

