/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.postgresql.pljava.internal.AclId;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.jdbc.ResultSetField;
import org.postgresql.pljava.jdbc.SPIConnection;
import org.postgresql.pljava.jdbc.SPIDriver;
import org.postgresql.pljava.jdbc.SyntheticResultSet;
import org.postgresql.pljava.jdbc.TypeOid;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public class SPIDatabaseMetaData
implements DatabaseMetaData {
    private static final String KEYWORDS = "abort,acl,add,aggregate,append,archive,arch_store,backward,binary,boolean,change,cluster,copy,database,delimiter,delimiters,do,extend,explain,forward,heavy,index,inherits,isnull,light,listen,load,merge,nothing,notify,notnull,oids,purge,rename,replace,retrieve,returns,rule,recipe,setof,stdin,stdout,store,vacuum,verbose,version";
    private final SPIConnection m_connection;
    private static final int VARHDRSZ = 4;
    private int NAMEDATALEN = 0;
    private int INDEX_MAX_KEYS = 0;
    private static final HashMap s_tableTypeClauses = new HashMap();
    private static final String[] s_defaultTableTypes;

    public SPIDatabaseMetaData(SPIConnection sPIConnection) {
        this.m_connection = sPIConnection;
    }

    protected int getMaxIndexKeys() throws SQLException {
        if (this.INDEX_MAX_KEYS == 0) {
            this.INDEX_MAX_KEYS = Integer.parseInt(Backend.getConfigOption("max_index_keys"));
        }
        return this.INDEX_MAX_KEYS;
    }

    protected int getMaxNameLength() throws SQLException {
        if (this.NAMEDATALEN == 0) {
            String string = "SELECT t.typlen FROM pg_catalog.pg_type t, pg_catalog.pg_namespace n WHERE t.typnamespace=n.oid   AND t.typname='name'   AND n.nspname='pg_catalog'";
            ResultSet resultSet = this.m_connection.createStatement().executeQuery(string);
            if (!resultSet.next()) {
                throw new SQLException("Unable to find name datatype in the system catalogs.");
            }
            this.NAMEDATALEN = resultSet.getInt("typlen");
            resultSet.close();
        }
        return this.NAMEDATALEN - 1;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        return true;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    public String getURL() throws SQLException {
        return "jdbc:default:connection";
    }

    public String getUserName() throws SQLException {
        return AclId.getUser().getName();
    }

    public boolean isReadOnly() throws SQLException {
        return this.m_connection.isReadOnly();
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        return true;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    public String getDatabaseProductName() throws SQLException {
        return "PostgreSQL";
    }

    public String getDatabaseProductVersion() throws SQLException {
        int[] nArray = this.m_connection.getVersionNumber();
        return nArray[0] + "." + nArray[1] + "." + nArray[2];
    }

    public String getDriverName() throws SQLException {
        return "PostgreSQL pljava SPI Driver";
    }

    public String getDriverVersion() throws SQLException {
        SPIDriver sPIDriver = new SPIDriver();
        return sPIDriver.getMajorVersion() + "." + sPIDriver.getMinorVersion();
    }

    public int getDriverMajorVersion() {
        return new SPIDriver().getMajorVersion();
    }

    public int getDriverMinorVersion() {
        return new SPIDriver().getMinorVersion();
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    public String getSQLKeywords() throws SQLException {
        return KEYWORDS;
    }

    public String getNumericFunctions() throws SQLException {
        return "abs,acos,asin,atan,atan2,ceiling,cos,cot,degrees,exp,floor,log,log10,mod,pi,power,radians,rand,round,sign,sin,sqrt,tan,truncate";
    }

    public String getStringFunctions() throws SQLException {
        String string = "ascii,char,concat,lcase,left,length,ltrim,repeat,rtrim,space,substring,ucase,replace";
        return string;
    }

    public String getSystemFunctions() throws SQLException {
        return "database,ifnull,user";
    }

    public String getTimeDateFunctions() throws SQLException {
        return "curdate,curtime,dayname,dayofmonth,dayofweek,dayofyear,hour,minute,month,monthname,now,quarter,second,week,year";
    }

    public String getSearchStringEscape() throws SQLException {
        return "\\\\";
    }

    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    public boolean supportsConvert() throws SQLException {
        return false;
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        return false;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    public String getSchemaTerm() throws SQLException {
        return "schema";
    }

    public String getProcedureTerm() throws SQLException {
        return "function";
    }

    public String getCatalogTerm() throws SQLException {
        return "database";
    }

    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    public int getMaxColumnNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return this.getMaxIndexKeys();
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    public int getMaxColumnsInTable() throws SQLException {
        return 1600;
    }

    public int getMaxConnections() throws SQLException {
        return 8192;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getMaxRowSize() throws SQLException {
        return 0x40000000;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    public int getMaxStatements() throws SQLException {
        return 1;
    }

    public int getMaxTableNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    public int getMaxUserNameLength() throws SQLException {
        return this.getMaxNameLength();
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        if (n == 8 || n == 2) {
            return true;
        }
        return this.getDatabaseMajorVersion() >= 8 && (n == 1 || n == 4);
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    private static String escapeQuotes(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 32;
        int n3 = 32;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            stringBuffer.append(c);
            if (c == '\'' && (n2 != 92 || n2 == 92 && n3 == 92)) {
                stringBuffer.append("'");
            }
            n3 = n2;
            n2 = c;
        }
        return stringBuffer.toString();
    }

    private static String resolveSchemaConditionWithOperator(String string, String string2, String string3) {
        if (string2 == null) {
            return "1=1";
        }
        if (!"".equals(string2)) {
            return string + " " + string3 + " '" + SPIDatabaseMetaData.escapeQuotes(string2) + "' ";
        }
        return string + " " + string3 + " 'public' ";
    }

    private static String resolveSchemaCondition(String string, String string2) {
        return SPIDatabaseMetaData.resolveSchemaConditionWithOperator(string, string2, "=");
    }

    private static String resolveSchemaPatternCondition(String string, String string2) {
        return SPIDatabaseMetaData.resolveSchemaConditionWithOperator(string, string2, "LIKE");
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        String string4 = "SELECT NULL AS PROCEDURE_CAT, n.nspname AS PROCEDURE_SCHEM, p.proname AS PROCEDURE_NAME, NULL, NULL, NULL, d.description AS REMARKS, 2 AS PROCEDURE_TYPE  FROM pg_catalog.pg_namespace n, pg_catalog.pg_proc p  LEFT JOIN pg_catalog.pg_description d ON (p.oid=d.objoid)  LEFT JOIN pg_catalog.pg_class c ON (d.classoid=c.oid AND c.relname='pg_proc')  LEFT JOIN pg_catalog.pg_namespace pn ON (c.relnamespace=pn.oid AND pn.nspname='pg_catalog')  WHERE p.pronamespace=n.oid  AND " + SPIDatabaseMetaData.resolveSchemaPatternCondition("n.nspname", string2);
        if (string3 != null) {
            string4 = string4 + " AND p.proname LIKE '" + SPIDatabaseMetaData.escapeQuotes(string3) + "' ";
        }
        string4 = string4 + " ORDER BY PROCEDURE_SCHEM, PROCEDURE_NAME ";
        return this.createMetaDataStatement().executeQuery(string4);
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        ResultSetField[] resultSetFieldArray = new ResultSetField[13];
        ArrayList<Object> arrayList = new ArrayList<Object>();
        resultSetFieldArray[0] = new ResultSetField("PROCEDURE_CAT", TypeOid.VARCHAR, this.getMaxNameLength());
        resultSetFieldArray[1] = new ResultSetField("PROCEDURE_SCHEM", TypeOid.VARCHAR, this.getMaxNameLength());
        resultSetFieldArray[2] = new ResultSetField("PROCEDURE_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        resultSetFieldArray[3] = new ResultSetField("COLUMN_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        resultSetFieldArray[4] = new ResultSetField("COLUMN_TYPE", TypeOid.INT2, 2);
        resultSetFieldArray[5] = new ResultSetField("DATA_TYPE", TypeOid.INT2, 2);
        resultSetFieldArray[6] = new ResultSetField("TYPE_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        resultSetFieldArray[7] = new ResultSetField("PRECISION", TypeOid.INT4, 4);
        resultSetFieldArray[8] = new ResultSetField("LENGTH", TypeOid.INT4, 4);
        resultSetFieldArray[9] = new ResultSetField("SCALE", TypeOid.INT2, 2);
        resultSetFieldArray[10] = new ResultSetField("RADIX", TypeOid.INT2, 2);
        resultSetFieldArray[11] = new ResultSetField("NULLABLE", TypeOid.INT2, 2);
        resultSetFieldArray[12] = new ResultSetField("REMARKS", TypeOid.VARCHAR, this.getMaxNameLength());
        String string5 = "SELECT n.nspname,p.proname,p.prorettype,p.proargtypes, t.typtype::varchar,t.typrelid  FROM pg_catalog.pg_proc p,pg_catalog.pg_namespace n, pg_catalog.pg_type t  WHERE p.pronamespace=n.oid AND p.prorettype=t.oid  AND " + SPIDatabaseMetaData.resolveSchemaPatternCondition("n.nspname", string2);
        if (string3 != null) {
            string5 = string5 + " AND p.proname LIKE '" + SPIDatabaseMetaData.escapeQuotes(string3) + "' ";
        }
        string5 = string5 + " ORDER BY n.nspname, p.proname ";
        ResultSet resultSet = this.m_connection.createStatement().executeQuery(string5);
        String string6 = null;
        String string7 = null;
        Oid oid = null;
        String string8 = null;
        Oid oid2 = null;
        String string9 = null;
        StringTokenizer stringTokenizer = null;
        ArrayList<Oid> arrayList2 = null;
        while (resultSet.next()) {
            Object object;
            Object object2;
            string6 = resultSet.getString("nspname");
            string7 = resultSet.getString("proname");
            oid = (Oid)resultSet.getObject("prorettype");
            string8 = resultSet.getString("typtype");
            oid2 = (Oid)resultSet.getObject("typrelid");
            string9 = resultSet.getString("proargtypes");
            stringTokenizer = new StringTokenizer(string9);
            arrayList2 = new ArrayList<Oid>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList2.add(new Oid(Integer.parseInt(stringTokenizer.nextToken())));
            }
            if (!string8.equals("c")) {
                Object[] objectArray = new Object[]{null, string6, string7, "returnValue", new Short(5), new Short((short)this.m_connection.getSQLType(oid)), this.m_connection.getPGType(oid), null, null, null, null, new Short(2), null};
                arrayList.add(objectArray);
            }
            for (int i = 0; i < arrayList2.size(); ++i) {
                object2 = (Oid)arrayList2.get(i);
                object = new Object[]{null, string6, string7, "$" + (i + 1), new Short(1), new Short((short)this.m_connection.getSQLType((Oid)object2)), this.m_connection.getPGType((Oid)object2), null, null, null, null, new Short(2), null};
                arrayList.add(object);
            }
            if (!string8.equals("c")) continue;
            String string10 = "SELECT a.attname,a.atttypid FROM pg_catalog.pg_attribute a WHERE a.attrelid = ? ORDER BY a.attnum ";
            object2 = this.m_connection.prepareStatement(string10);
            object2.setObject(1, oid2);
            object = object2.executeQuery(string10);
            while (object.next()) {
                Oid oid3 = (Oid)object.getObject("atttypid");
                Object[] objectArray = new Object[]{null, string6, string7, object.getString("attname"), new Short(3), new Short((short)this.m_connection.getSQLType(oid3)), this.m_connection.getPGType(oid3), null, null, null, null, new Short(2), null};
                arrayList.add(objectArray);
            }
            object.close();
            object2.close();
        }
        resultSet.close();
        return this.createSyntheticResultSet(resultSetFieldArray, arrayList);
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        String string4 = "SCHEMAS";
        String string5 = "SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM, c.relname AS TABLE_NAME,  CASE n.nspname LIKE 'pg\\\\_%' OR n.nspname = 'information_schema'  WHEN true THEN CASE  WHEN n.nspname = 'pg_catalog' OR n.nspname = 'information_schema' THEN CASE c.relkind   WHEN 'r' THEN 'SYSTEM TABLE'   WHEN 'v' THEN 'SYSTEM VIEW'   WHEN 'i' THEN 'SYSTEM INDEX'   ELSE NULL   END  WHEN n.nspname = 'pg_toast' THEN CASE c.relkind   WHEN 'r' THEN 'SYSTEM TOAST TABLE'   WHEN 'i' THEN 'SYSTEM TOAST INDEX'   ELSE NULL   END  ELSE CASE c.relkind   WHEN 'r' THEN 'TEMPORARY TABLE'   WHEN 'i' THEN 'TEMPORARY INDEX'   ELSE NULL   END  END  WHEN false THEN CASE c.relkind  WHEN 'r' THEN 'TABLE'  WHEN 'i' THEN 'INDEX'  WHEN 'S' THEN 'SEQUENCE'  WHEN 'v' THEN 'VIEW'  ELSE NULL  END  ELSE NULL  END  AS TABLE_TYPE, d.description AS REMARKS  FROM pg_catalog.pg_namespace n, pg_catalog.pg_class c  LEFT JOIN pg_catalog.pg_description d ON (c.oid = d.objoid AND d.objsubid = 0)  LEFT JOIN pg_catalog.pg_class dc ON (d.classoid=dc.oid AND dc.relname='pg_class')  LEFT JOIN pg_catalog.pg_namespace dn ON (dn.oid=dc.relnamespace AND dn.nspname='pg_catalog')  WHERE c.relnamespace = n.oid  AND " + SPIDatabaseMetaData.resolveSchemaPatternCondition("n.nspname", string2);
        String string6 = " ORDER BY TABLE_TYPE,TABLE_SCHEM,TABLE_NAME ";
        if (stringArray == null) {
            stringArray = s_defaultTableTypes;
        }
        if (string3 != null) {
            string5 = string5 + " AND c.relname LIKE '" + SPIDatabaseMetaData.escapeQuotes(string3) + "' ";
        }
        String string7 = string5;
        string7 = string7 + " AND (false ";
        for (int i = 0; i < stringArray.length; ++i) {
            HashMap hashMap = (HashMap)s_tableTypeClauses.get(stringArray[i]);
            if (hashMap == null) continue;
            String string8 = (String)hashMap.get(string4);
            string7 = string7 + " OR ( " + string8 + " ) ";
        }
        string7 = string7 + ") ";
        string7 = string7 + string6;
        return this.createMetaDataStatement().executeQuery(string7);
    }

    public ResultSet getSchemas() throws SQLException {
        String string = "SELECT nspname AS TABLE_SCHEM FROM pg_catalog.pg_namespace WHERE nspname <> 'pg_toast' AND nspname NOT LIKE 'pg\\\\_temp\\\\_%' ORDER BY TABLE_SCHEM";
        return this.createMetaDataStatement().executeQuery(string);
    }

    public ResultSet getCatalogs() throws SQLException {
        String string = "SELECT datname AS TABLE_CAT FROM pg_catalog.pg_database ORDER BY TABLE_CAT";
        return this.createMetaDataStatement().executeQuery(string);
    }

    public ResultSet getTableTypes() throws SQLException {
        String[] stringArray = s_tableTypeClauses.keySet().toArray(new String[s_tableTypeClauses.size()]);
        SPIDatabaseMetaData.sortStringArray(stringArray);
        ResultSetField[] resultSetFieldArray = new ResultSetField[1];
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        resultSetFieldArray[0] = new ResultSetField(new String("TABLE_TYPE"), TypeOid.VARCHAR, this.getMaxNameLength());
        for (int i = 0; i < stringArray.length; ++i) {
            Object[] objectArray = new Object[]{stringArray[i]};
            arrayList.add(objectArray);
        }
        return this.createSyntheticResultSet(resultSetFieldArray, arrayList);
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        ResultSetField[] resultSetFieldArray = new ResultSetField[]{new ResultSetField("TABLE_CAT", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("TABLE_SCHEM", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("TABLE_NAME", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("COLUMN_NAME", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("DATA_TYPE", TypeOid.INT2, 2), new ResultSetField("TYPE_NAME", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("COLUMN_SIZE", TypeOid.INT4, 4), new ResultSetField("BUFFER_LENGTH", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("DECIMAL_DIGITS", TypeOid.INT4, 4), new ResultSetField("NUM_PREC_RADIX", TypeOid.INT4, 4), new ResultSetField("NULLABLE", TypeOid.INT4, 4), new ResultSetField("REMARKS", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("COLUMN_DEF", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("SQL_DATA_TYPE", TypeOid.INT4, 4), new ResultSetField("SQL_DATETIME_SUB", TypeOid.INT4, 4), new ResultSetField("CHAR_OCTET_LENGTH", TypeOid.INT4, 4), new ResultSetField("ORDINAL_POSITION", TypeOid.INT4, 4), new ResultSetField("IS_NULLABLE", TypeOid.VARCHAR, this.getMaxNameLength())};
        String string5 = "SELECT n.nspname,c.relname,a.attname, a.atttypid as atttypid,a.attnotnull,a.atttypmod, a.attlen::int4 as attlen,a.attnum,def.adsrc,dsc.description  FROM pg_catalog.pg_namespace n  JOIN pg_catalog.pg_class c ON (c.relnamespace = n.oid)  JOIN pg_catalog.pg_attribute a ON (a.attrelid=c.oid)  LEFT JOIN pg_catalog.pg_attrdef def ON (a.attrelid=def.adrelid AND a.attnum = def.adnum)  LEFT JOIN pg_catalog.pg_description dsc ON (c.oid=dsc.objoid AND a.attnum = dsc.objsubid)  LEFT JOIN pg_catalog.pg_class dc ON (dc.oid=dsc.classoid AND dc.relname='pg_class')  LEFT JOIN pg_catalog.pg_namespace dn ON (dc.relnamespace=dn.oid AND dn.nspname='pg_catalog')  WHERE a.attnum > 0 AND NOT a.attisdropped  AND " + SPIDatabaseMetaData.resolveSchemaPatternCondition("n.nspname", string2);
        if (string3 != null && !"".equals(string3)) {
            string5 = string5 + " AND c.relname LIKE '" + SPIDatabaseMetaData.escapeQuotes(string3) + "' ";
        }
        if (string4 != null && !"".equals(string4)) {
            string5 = string5 + " AND a.attname LIKE '" + SPIDatabaseMetaData.escapeQuotes(string4) + "' ";
        }
        string5 = string5 + " ORDER BY nspname,relname,attnum ";
        ResultSet resultSet = this.m_connection.createStatement().executeQuery(string5);
        while (resultSet.next()) {
            int n;
            Object[] objectArray = new Object[18];
            Oid oid = (Oid)resultSet.getObject("atttypid");
            objectArray[0] = null;
            objectArray[1] = resultSet.getString("nspname");
            objectArray[2] = resultSet.getString("relname");
            objectArray[3] = resultSet.getString("attname");
            objectArray[4] = new Short((short)this.m_connection.getSQLType(oid));
            String string6 = this.m_connection.getPGType(oid);
            objectArray[5] = this.m_connection.getPGType(oid);
            String string7 = resultSet.getString("adsrc");
            if (string7 != null) {
                if (string6.equals("int4")) {
                    if (string7.indexOf("nextval(") != -1) {
                        objectArray[5] = "serial";
                    }
                } else if (string6.equals("int8") && string7.indexOf("nextval(") != -1) {
                    objectArray[5] = "bigserial";
                }
            }
            objectArray[8] = new Integer(0);
            if (string6.equals("bpchar") || string6.equals("varchar")) {
                n = resultSet.getInt("atttypmod");
                objectArray[6] = new Integer(n != -1 ? n - 4 : 0);
            } else if (string6.equals("numeric") || string6.equals("decimal")) {
                n = resultSet.getInt("atttypmod") - 4;
                objectArray[6] = new Integer(n >> 16 & 0xFFFF);
                objectArray[8] = new Integer(n & 0xFFFF);
                objectArray[9] = new Integer(10);
            } else if (string6.equals("bit") || string6.equals("varbit")) {
                objectArray[6] = resultSet.getObject("atttypmod");
                objectArray[9] = new Integer(2);
            } else {
                objectArray[6] = resultSet.getObject("attlen");
                objectArray[9] = new Integer(10);
            }
            objectArray[7] = null;
            objectArray[10] = new Integer(resultSet.getBoolean("attnotnull") ? 0 : 1);
            objectArray[11] = resultSet.getString("description");
            objectArray[12] = resultSet.getString("adsrc");
            objectArray[13] = null;
            objectArray[14] = null;
            objectArray[15] = objectArray[6];
            objectArray[16] = new Integer(resultSet.getInt("attnum"));
            objectArray[17] = resultSet.getBoolean("attnotnull") ? "NO" : "YES";
            arrayList.add(objectArray);
        }
        resultSet.close();
        return this.createSyntheticResultSet(resultSetFieldArray, arrayList);
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        ResultSetField[] resultSetFieldArray = new ResultSetField[8];
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        if (string3 == null) {
            string3 = "%";
        }
        if (string4 == null) {
            string4 = "%";
        }
        resultSetFieldArray[0] = new ResultSetField("TABLE_CAT", TypeOid.VARCHAR, this.getMaxNameLength());
        resultSetFieldArray[1] = new ResultSetField("TABLE_SCHEM", TypeOid.VARCHAR, this.getMaxNameLength());
        resultSetFieldArray[2] = new ResultSetField("TABLE_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        resultSetFieldArray[3] = new ResultSetField("COLUMN_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        resultSetFieldArray[4] = new ResultSetField("GRANTOR", TypeOid.VARCHAR, this.getMaxNameLength());
        resultSetFieldArray[5] = new ResultSetField("GRANTEE", TypeOid.VARCHAR, this.getMaxNameLength());
        resultSetFieldArray[6] = new ResultSetField("PRIVILEGE", TypeOid.VARCHAR, this.getMaxNameLength());
        resultSetFieldArray[7] = new ResultSetField("IS_GRANTABLE", TypeOid.VARCHAR, this.getMaxNameLength());
        String string5 = "SELECT n.nspname,c.relname,u.usename,c.relacl,a.attname  FROM pg_catalog.pg_namespace n, pg_catalog.pg_class c, pg_catalog.pg_user u, pg_catalog.pg_attribute a  WHERE c.relnamespace = n.oid  AND u.usesysid = c.relowner  AND c.oid = a.attrelid  AND c.relkind = 'r'  AND a.attnum > 0 AND NOT a.attisdropped  AND " + SPIDatabaseMetaData.resolveSchemaCondition("n.nspname", string2);
        string5 = string5 + " AND c.relname = '" + SPIDatabaseMetaData.escapeQuotes(string3) + "' ";
        if (string4 != null && !"".equals(string4)) {
            string5 = string5 + " AND a.attname LIKE '" + SPIDatabaseMetaData.escapeQuotes(string4) + "' ";
        }
        string5 = string5 + " ORDER BY attname ";
        ResultSet resultSet = this.m_connection.createStatement().executeQuery(string5);
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        HashMap hashMap = null;
        String[] stringArray = null;
        while (resultSet.next()) {
            string6 = resultSet.getString("nspname");
            string7 = resultSet.getString("relname");
            string8 = resultSet.getString("attname");
            string9 = resultSet.getString("usename");
            string10 = resultSet.getString("relacl");
            hashMap = this.parseACL(string10, string9);
            stringArray = hashMap.keySet().toArray(new String[hashMap.size()]);
            SPIDatabaseMetaData.sortStringArray(stringArray);
            for (int i = 0; i < stringArray.length; ++i) {
                ArrayList arrayList2 = (ArrayList)hashMap.get(stringArray[i]);
                for (int j = 0; j < arrayList2.size(); ++j) {
                    String string11 = (String)arrayList2.get(j);
                    String string12 = string9.equals(string11) ? "YES" : "NO";
                    Object[] objectArray = new Object[]{null, string6, string7, string8, string9, string11, stringArray[i], string12};
                    arrayList.add(objectArray);
                }
            }
        }
        resultSet.close();
        return this.createSyntheticResultSet(resultSetFieldArray, arrayList);
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        ResultSetField[] resultSetFieldArray = new ResultSetField[7];
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        resultSetFieldArray[0] = new ResultSetField("TABLE_CAT", TypeOid.VARCHAR, this.getMaxNameLength());
        resultSetFieldArray[1] = new ResultSetField("TABLE_SCHEM", TypeOid.VARCHAR, this.getMaxNameLength());
        resultSetFieldArray[2] = new ResultSetField("TABLE_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        resultSetFieldArray[3] = new ResultSetField("GRANTOR", TypeOid.VARCHAR, this.getMaxNameLength());
        resultSetFieldArray[4] = new ResultSetField("GRANTEE", TypeOid.VARCHAR, this.getMaxNameLength());
        resultSetFieldArray[5] = new ResultSetField("PRIVILEGE", TypeOid.VARCHAR, this.getMaxNameLength());
        resultSetFieldArray[6] = new ResultSetField("IS_GRANTABLE", TypeOid.VARCHAR, this.getMaxNameLength());
        String string4 = "SELECT n.nspname,c.relname,u.usename,c.relacl  FROM pg_catalog.pg_namespace n, pg_catalog.pg_class c, pg_catalog.pg_user u  WHERE c.relnamespace = n.oid  AND u.usesysid = c.relowner  AND c.relkind = 'r'  AND " + SPIDatabaseMetaData.resolveSchemaPatternCondition("n.nspname", string2);
        if (string3 != null && !"".equals(string3)) {
            string4 = string4 + " AND c.relname LIKE '" + SPIDatabaseMetaData.escapeQuotes(string3) + "' ";
        }
        string4 = string4 + " ORDER BY nspname, relname ";
        ResultSet resultSet = this.m_connection.createStatement().executeQuery(string4);
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        HashMap hashMap = null;
        String[] stringArray = null;
        while (resultSet.next()) {
            string5 = resultSet.getString("nspname");
            string6 = resultSet.getString("relname");
            string7 = resultSet.getString("usename");
            string8 = resultSet.getString("relacl");
            hashMap = this.parseACL(string8, string7);
            stringArray = hashMap.keySet().toArray(new String[hashMap.size()]);
            SPIDatabaseMetaData.sortStringArray(stringArray);
            for (int i = 0; i < stringArray.length; ++i) {
                ArrayList arrayList2 = (ArrayList)hashMap.get(stringArray[i]);
                for (int j = 0; j < arrayList2.size(); ++j) {
                    String string9 = (String)arrayList2.get(j);
                    String string10 = string7.equals(string9) ? "YES" : "NO";
                    Object[] objectArray = new Object[]{null, string5, string6, string7, string9, stringArray[i], string10};
                    arrayList.add(objectArray);
                }
            }
        }
        resultSet.close();
        return this.createSyntheticResultSet(resultSetFieldArray, arrayList);
    }

    private static void sortStringArray(String[] stringArray) {
        for (int i = 0; i < stringArray.length - 1; ++i) {
            for (int j = i + 1; j < stringArray.length; ++j) {
                if (stringArray[i].compareTo(stringArray[j]) <= 0) continue;
                String string = stringArray[i];
                stringArray[i] = stringArray[j];
                stringArray[j] = string;
            }
        }
    }

    private static ArrayList parseACLArray(String string) {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null || string.length() == 0) {
            return arrayList;
        }
        boolean bl = false;
        int n2 = 1;
        int n3 = 32;
        for (n = n2; n < string.length(); ++n) {
            char c = string.charAt(n);
            if (c == '\"' && n3 != 92) {
                bl = !bl;
            } else if (c == ',' && !bl) {
                arrayList.add(string.substring(n2, n));
                n2 = n + 1;
            }
            n3 = c;
        }
        arrayList.add(string.substring(n2, string.length() - 1));
        for (n = 0; n < arrayList.size(); ++n) {
            String string2 = (String)arrayList.get(n);
            if (!string2.startsWith("\"") || !string2.endsWith("\"")) continue;
            string2 = string2.substring(1, string2.length() - 1);
            arrayList.set(n, string2);
        }
        return arrayList;
    }

    private void addACLPrivileges(String string, HashMap hashMap) {
        int n = string.lastIndexOf("=");
        String string2 = string.substring(0, n);
        if (string2.length() == 0) {
            string2 = "PUBLIC";
        }
        String string3 = string.substring(n + 1);
        for (int i = 0; i < string3.length(); ++i) {
            String string4;
            char c = string3.charAt(i);
            switch (c) {
                case 'a': {
                    string4 = "INSERT";
                    break;
                }
                case 'r': {
                    string4 = "SELECT";
                    break;
                }
                case 'w': {
                    string4 = "UPDATE";
                    break;
                }
                case 'd': {
                    string4 = "DELETE";
                    break;
                }
                case 'R': {
                    string4 = "RULE";
                    break;
                }
                case 'x': {
                    string4 = "REFERENCES";
                    break;
                }
                case 't': {
                    string4 = "TRIGGER";
                    break;
                }
                case 'X': {
                    string4 = "EXECUTE";
                    break;
                }
                case 'U': {
                    string4 = "USAGE";
                    break;
                }
                case 'C': {
                    string4 = "CREATE";
                    break;
                }
                case 'T': {
                    string4 = "CREATE TEMP";
                    break;
                }
                default: {
                    string4 = "UNKNOWN";
                }
            }
            ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(string4);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
                hashMap.put(string4, arrayList);
            }
            arrayList.add(string2);
        }
    }

    protected HashMap parseACL(String string, String string2) {
        if (string == null || string == "") {
            string = "{" + string2 + "=arwdRxt}";
        }
        ArrayList arrayList = SPIDatabaseMetaData.parseACLArray(string);
        HashMap hashMap = new HashMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3 = (String)arrayList.get(i);
            this.addACLPrivileges(string3, hashMap);
        }
        return hashMap;
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        ResultSetField[] resultSetFieldArray = new ResultSetField[8];
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        resultSetFieldArray[0] = new ResultSetField("SCOPE", TypeOid.INT2, 2);
        resultSetFieldArray[1] = new ResultSetField("COLUMN_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        resultSetFieldArray[2] = new ResultSetField("DATA_TYPE", TypeOid.INT2, 2);
        resultSetFieldArray[3] = new ResultSetField("TYPE_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        resultSetFieldArray[4] = new ResultSetField("COLUMN_SIZE", TypeOid.INT4, 4);
        resultSetFieldArray[5] = new ResultSetField("BUFFER_LENGTH", TypeOid.INT4, 4);
        resultSetFieldArray[6] = new ResultSetField("DECIMAL_DIGITS", TypeOid.INT2, 2);
        resultSetFieldArray[7] = new ResultSetField("PSEUDO_COLUMN", TypeOid.INT2, 2);
        String string4 = "";
        String string5 = " FROM pg_catalog.pg_namespace n, pg_catalog.pg_class ct, pg_catalog.pg_class ci, pg_catalog.pg_attribute a, pg_catalog.pg_index i ";
        string4 = " AND ct.relnamespace = n.oid  AND " + SPIDatabaseMetaData.resolveSchemaCondition("n.nspname", string2);
        String string6 = "SELECT a.attname, a.atttypid as atttypid " + string5 + " WHERE ct.oid=i.indrelid AND ci.oid=i.indexrelid " + " AND a.attrelid=ci.oid AND i.indisprimary " + " AND ct.relname = '" + SPIDatabaseMetaData.escapeQuotes(string3) + "' " + string4 + " ORDER BY a.attnum ";
        ResultSet resultSet = this.m_connection.createStatement().executeQuery(string6);
        while (resultSet.next()) {
            Object[] objectArray = new Object[8];
            Oid oid = (Oid)resultSet.getObject("atttypid");
            objectArray[0] = new Short((short)n);
            objectArray[1] = resultSet.getString("attname");
            objectArray[2] = new Short((short)this.m_connection.getSQLType(oid));
            objectArray[3] = this.m_connection.getPGType(oid);
            objectArray[4] = null;
            objectArray[5] = null;
            objectArray[6] = null;
            objectArray[7] = new Short(1);
            arrayList.add(objectArray);
        }
        return this.createSyntheticResultSet(resultSetFieldArray, arrayList);
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        ResultSetField[] resultSetFieldArray = new ResultSetField[8];
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        resultSetFieldArray[0] = new ResultSetField("SCOPE", TypeOid.INT2, 2);
        resultSetFieldArray[1] = new ResultSetField("COLUMN_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        resultSetFieldArray[2] = new ResultSetField("DATA_TYPE", TypeOid.INT2, 2);
        resultSetFieldArray[3] = new ResultSetField("TYPE_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        resultSetFieldArray[4] = new ResultSetField("COLUMN_SIZE", TypeOid.INT4, 4);
        resultSetFieldArray[5] = new ResultSetField("BUFFER_LENGTH", TypeOid.INT4, 4);
        resultSetFieldArray[6] = new ResultSetField("DECIMAL_DIGITS", TypeOid.INT2, 2);
        resultSetFieldArray[7] = new ResultSetField("PSEUDO_COLUMN", TypeOid.INT2, 2);
        Object[] objectArray = new Object[]{null, "ctid", new Short((short)this.m_connection.getSQLType("tid")), "tid", null, null, null, new Short(2)};
        arrayList.add(objectArray);
        return this.createSyntheticResultSet(resultSetFieldArray, arrayList);
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        String string4 = "";
        String string5 = "SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM, ";
        String string6 = " FROM pg_catalog.pg_namespace n, pg_catalog.pg_class ct, pg_catalog.pg_class ci, pg_catalog.pg_attribute a, pg_catalog.pg_index i ";
        string4 = " AND ct.relnamespace = n.oid AND " + SPIDatabaseMetaData.resolveSchemaCondition("n.nspname", string2);
        String string7 = string5 + " ct.relname AS TABLE_NAME, " + " a.attname AS COLUMN_NAME, " + " a.attnum::int2 AS KEY_SEQ, " + " ci.relname AS PK_NAME " + string6 + " WHERE ct.oid=i.indrelid AND ci.oid=i.indexrelid " + " AND a.attrelid=ci.oid AND i.indisprimary ";
        if (string3 != null && !"".equals(string3)) {
            string7 = string7 + " AND ct.relname = '" + SPIDatabaseMetaData.escapeQuotes(string3) + "' ";
        }
        string7 = string7 + string4 + " ORDER BY table_name, pk_name, key_seq";
        return this.createMetaDataStatement().executeQuery(string7);
    }

    protected ResultSet getImportedExportedKeys(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        ResultSetField[] resultSetFieldArray = new ResultSetField[]{new ResultSetField("PKTABLE_CAT", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("PKTABLE_SCHEM", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("PKTABLE_NAME", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("PKCOLUMN_NAME", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("FKTABLE_CAT", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("FKTABLE_SCHEM", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("FKTABLE_NAME", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("FKCOLUMN_NAME", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("KEY_SEQ", TypeOid.INT2, 2), new ResultSetField("UPDATE_RULE", TypeOid.INT2, 2), new ResultSetField("DELETE_RULE", TypeOid.INT2, 2), new ResultSetField("FK_NAME", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("PK_NAME", TypeOid.VARCHAR, this.getMaxNameLength()), new ResultSetField("DEFERRABILITY", TypeOid.INT2, 2)};
        String string7 = "SELECT NULL::text AS PKTABLE_CAT, pkn.nspname AS PKTABLE_SCHEM, pkc.relname AS PKTABLE_NAME, pka.attname AS PKCOLUMN_NAME, NULL::text AS FKTABLE_CAT, fkn.nspname AS FKTABLE_SCHEM, fkc.relname AS FKTABLE_NAME, fka.attname AS FKCOLUMN_NAME, pos.n::int2 AS KEY_SEQ, CASE con.confupdtype  WHEN 'c' THEN 0 WHEN 'n' THEN 2 WHEN 'd' THEN 4 WHEN 'r' THEN 1 WHEN 'a' THEN 3 ELSE NULL END::int2 AS UPDATE_RULE, CASE con.confdeltype  WHEN 'c' THEN 0 WHEN 'n' THEN 2 WHEN 'd' THEN 4 WHEN 'r' THEN 1 WHEN 'a' THEN 3 ELSE NULL END::int2 AS DELETE_RULE, con.conname AS FK_NAME, pkic.relname AS PK_NAME, CASE  WHEN con.condeferrable AND con.condeferred THEN 5 WHEN con.condeferrable THEN 6 ELSE 7 END::int2 AS DEFERRABILITY  FROM  pg_catalog.pg_namespace pkn, pg_catalog.pg_class pkc, pg_catalog.pg_attribute pka,  pg_catalog.pg_namespace fkn, pg_catalog.pg_class fkc, pg_catalog.pg_attribute fka,  pg_catalog.pg_constraint con,  pg_catalog.generate_series(1, " + this.getMaxIndexKeys() + ") pos(n), " + " pg_catalog.pg_depend dep, pg_catalog.pg_class pkic " + " WHERE pkn.oid = pkc.relnamespace AND pkc.oid = pka.attrelid AND pka.attnum = con.confkey[pos.n] AND con.confrelid = pkc.oid " + " AND fkn.oid = fkc.relnamespace AND fkc.oid = fka.attrelid AND fka.attnum = con.conkey[pos.n] AND con.conrelid = fkc.oid " + " AND con.contype = 'f' AND con.oid = dep.objid AND pkic.oid = dep.refobjid AND pkic.relkind = 'i' AND dep.classid = 'pg_constraint'::regclass::oid AND dep.refclassid = 'pg_class'::regclass::oid " + " AND " + SPIDatabaseMetaData.resolveSchemaCondition("pkn.nspname", string2) + " AND " + SPIDatabaseMetaData.resolveSchemaCondition("fkn.nspname", string5);
        if (string3 != null && !"".equals(string3)) {
            string7 = string7 + " AND pkc.relname = '" + SPIDatabaseMetaData.escapeQuotes(string3) + "' ";
        }
        if (string6 != null && !"".equals(string6)) {
            string7 = string7 + " AND fkc.relname = '" + SPIDatabaseMetaData.escapeQuotes(string6) + "' ";
        }
        string7 = string3 != null ? string7 + " ORDER BY fkn.nspname,fkc.relname,pos.n" : string7 + " ORDER BY pkn.nspname,pkc.relname,pos.n";
        return this.createMetaDataStatement().executeQuery(string7);
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        return this.getImportedExportedKeys(null, null, null, string, string2, string3);
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        return this.getImportedExportedKeys(string, string2, string3, null, null, null);
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        return this.getImportedExportedKeys(string, string2, string3, string4, string5, string6);
    }

    public ResultSet getTypeInfo() throws SQLException {
        ResultSetField[] resultSetFieldArray = new ResultSetField[18];
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        resultSetFieldArray[0] = new ResultSetField("TYPE_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        resultSetFieldArray[1] = new ResultSetField("DATA_TYPE", TypeOid.INT2, 2);
        resultSetFieldArray[2] = new ResultSetField("PRECISION", TypeOid.INT4, 4);
        resultSetFieldArray[3] = new ResultSetField("LITERAL_PREFIX", TypeOid.VARCHAR, this.getMaxNameLength());
        resultSetFieldArray[4] = new ResultSetField("LITERAL_SUFFIX", TypeOid.VARCHAR, this.getMaxNameLength());
        resultSetFieldArray[5] = new ResultSetField("CREATE_PARAMS", TypeOid.VARCHAR, this.getMaxNameLength());
        resultSetFieldArray[6] = new ResultSetField("NULLABLE", TypeOid.INT2, 2);
        resultSetFieldArray[7] = new ResultSetField("CASE_SENSITIVE", TypeOid.BOOL, 1);
        resultSetFieldArray[8] = new ResultSetField("SEARCHABLE", TypeOid.INT2, 2);
        resultSetFieldArray[9] = new ResultSetField("UNSIGNED_ATTRIBUTE", TypeOid.BOOL, 1);
        resultSetFieldArray[10] = new ResultSetField("FIXED_PREC_SCALE", TypeOid.BOOL, 1);
        resultSetFieldArray[11] = new ResultSetField("AUTO_INCREMENT", TypeOid.BOOL, 1);
        resultSetFieldArray[12] = new ResultSetField("LOCAL_TYPE_NAME", TypeOid.VARCHAR, this.getMaxNameLength());
        resultSetFieldArray[13] = new ResultSetField("MINIMUM_SCALE", TypeOid.INT2, 2);
        resultSetFieldArray[14] = new ResultSetField("MAXIMUM_SCALE", TypeOid.INT2, 2);
        resultSetFieldArray[15] = new ResultSetField("SQL_DATA_TYPE", TypeOid.INT4, 4);
        resultSetFieldArray[16] = new ResultSetField("SQL_DATETIME_SUB", TypeOid.INT4, 4);
        resultSetFieldArray[17] = new ResultSetField("NUM_PREC_RADIX", TypeOid.INT4, 4);
        String string = "SELECT typname FROM pg_catalog.pg_type where typrelid = 0";
        ResultSet resultSet = this.m_connection.createStatement().executeQuery(string);
        Integer n = new Integer(9);
        Integer n2 = new Integer(10);
        Short s = new Short(0);
        Short s2 = new Short(3);
        String string2 = null;
        while (resultSet.next()) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[18];
            string2 = resultSet.getString(1);
            objectArray2[0] = string2;
            objectArray2[1] = new Short((short)this.m_connection.getSQLType(string2));
            objectArray2[2] = n;
            objectArray2[6] = s;
            objectArray2[7] = Boolean.FALSE;
            objectArray2[8] = s2;
            objectArray2[9] = Boolean.FALSE;
            objectArray2[10] = Boolean.FALSE;
            objectArray2[11] = Boolean.FALSE;
            objectArray2[17] = n2;
            arrayList.add(objectArray2);
            if (string2.equals("int4")) {
                objectArray = (Object[])objectArray2.clone();
                objectArray[0] = "serial";
                objectArray[11] = Boolean.TRUE;
                arrayList.add(objectArray);
                continue;
            }
            if (!string2.equals("int8")) continue;
            objectArray = (Object[])objectArray2.clone();
            objectArray[0] = "bigserial";
            objectArray[11] = Boolean.TRUE;
            arrayList.add(objectArray);
        }
        resultSet.close();
        return this.createSyntheticResultSet(resultSetFieldArray, arrayList);
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        String string4 = "SELECT NULL AS TABLE_CAT, n.nspname AS TABLE_SCHEM, ";
        String string5 = " FROM pg_catalog.pg_namespace n, pg_catalog.pg_class ct, pg_catalog.pg_class ci, pg_catalog.pg_index i, pg_catalog.pg_attribute a, pg_catalog.pg_am am ";
        String string6 = " AND n.oid = ct.relnamespace  AND " + SPIDatabaseMetaData.resolveSchemaCondition("n.nspname", string2);
        String string7 = string4 + " ct.relname AS TABLE_NAME, NOT i.indisunique AS NON_UNIQUE, NULL AS INDEX_QUALIFIER, ci.relname AS INDEX_NAME, " + " CASE i.indisclustered " + " WHEN true THEN " + 1 + " ELSE CASE am.amname " + " WHEN 'hash' THEN " + 2 + " ELSE " + 3 + " END " + " END::int2 AS TYPE, " + " a.attnum::int2 AS ORDINAL_POSITION, " + " a.attname AS COLUMN_NAME, " + " NULL AS ASC_OR_DESC, " + " ci.reltuples AS CARDINALITY, " + " ci.relpages AS PAGES, " + " NULL AS FILTER_CONDITION " + string5 + " WHERE ct.oid=i.indrelid AND ci.oid=i.indexrelid AND a.attrelid=ci.oid AND ci.relam=am.oid " + string6 + " AND ct.relname = '" + SPIDatabaseMetaData.escapeQuotes(string3) + "' ";
        if (bl) {
            string7 = string7 + " AND i.indisunique ";
        }
        string7 = string7 + " ORDER BY NON_UNIQUE, TYPE, INDEX_NAME, ORDINAL_POSITION ";
        return this.createMetaDataStatement().executeQuery(string7);
    }

    public boolean supportsResultSetType(int n) throws SQLException {
        return n == 1003;
    }

    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        if (n != 1003) {
            return false;
        }
        return n2 == 1007;
    }

    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        return true;
    }

    public boolean ownDeletesAreVisible(int n) throws SQLException {
        return true;
    }

    public boolean ownInsertsAreVisible(int n) throws SQLException {
        return true;
    }

    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersDeletesAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean othersInsertsAreVisible(int n) throws SQLException {
        return false;
    }

    public boolean updatesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean deletesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean insertsAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        int n;
        String string4 = "select null as type_cat, n.nspname as type_schem, t.typname as type_name,  null as class_name, CASE WHEN t.typtype='c' then 2002 else 2001 end as data_type, pg_catalog.obj_description(t.oid, 'pg_type')  as remarks, CASE WHEN t.typtype = 'd' then  (select CASE";
        for (int i = 0; i < SPIConnection.JDBC3_TYPE_NAMES.length; ++i) {
            string4 = string4 + " when typname = '" + SPIConnection.JDBC_TYPE_NUMBERS[i] + "' then " + SPIConnection.JDBC_TYPE_NUMBERS[i];
        }
        string4 = string4 + " else 1111 end from pg_type where oid=t.typbasetype) else null end as base_type from pg_catalog.pg_type t, pg_catalog.pg_namespace n where t.typnamespace = n.oid and n.nspname != 'pg_catalog' and n.nspname != 'pg_toast'";
        String string5 = "";
        if (nArray != null) {
            string5 = string5 + " and (false ";
            block5: for (n = 0; n < nArray.length; ++n) {
                switch (nArray[n]) {
                    case 2002: {
                        string5 = string5 + " or t.typtype = 'c'";
                        continue block5;
                    }
                    case 2001: {
                        string5 = string5 + " or t.typtype = 'd'";
                    }
                }
            }
            string5 = string5 + " ) ";
        } else {
            string5 = string5 + " and t.typtype IN ('c','d') ";
        }
        if (string3 != null) {
            n = string3.indexOf(46);
            int n2 = string3.lastIndexOf(46);
            if (n != -1) {
                string2 = n != n2 ? string3.substring(n + 1, n2) : string3.substring(0, n);
                string3 = string3.substring(n2 + 1);
            }
            string5 = string5 + " and t.typname like '" + SPIDatabaseMetaData.escapeQuotes(string3) + "'";
        }
        if (string2 != null) {
            string5 = string5 + " and n.nspname like '" + SPIDatabaseMetaData.escapeQuotes(string2) + "'";
        }
        string4 = string4 + string5;
        string4 = string4 + " order by data_type, type_schem, type_name";
        ResultSet resultSet = this.createMetaDataStatement().executeQuery(string4);
        return resultSet;
    }

    public Connection getConnection() throws SQLException {
        return this.m_connection;
    }

    public boolean rowChangesAreDetected(int n) throws SQLException {
        return false;
    }

    public boolean rowChangesAreVisible(int n) throws SQLException {
        return false;
    }

    private Statement createMetaDataStatement() throws SQLException {
        return this.m_connection.createStatement(1003, 1007);
    }

    public boolean supportsSavepoints() throws SQLException {
        return this.getDatabaseMajorVersion() >= 8;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        throw new UnsupportedFeatureException("DatabaseMetaData.getSuperTypes");
    }

    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        throw new UnsupportedFeatureException("DatabaseMetaData.getSuperTables");
    }

    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        throw new UnsupportedFeatureException("getAttributes");
    }

    public boolean supportsResultSetHoldability(int n) throws SQLException {
        return true;
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        return this.m_connection.getVersionNumber()[0];
    }

    public int getDatabaseMinorVersion() throws SQLException {
        return this.m_connection.getVersionNumber()[1];
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    public int getSQLStateType() throws SQLException {
        return 2;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    private ResultSet createSyntheticResultSet(ResultSetField[] resultSetFieldArray, ArrayList arrayList) throws SQLException {
        return new SyntheticResultSet(resultSetFieldArray, arrayList);
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        s_tableTypeClauses.put("TABLE", hashMap);
        hashMap.put("SCHEMAS", "c.relkind = 'r' AND n.nspname NOT LIKE 'pg\\\\_%' AND n.nspname <> 'information_schema'");
        hashMap.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname NOT LIKE 'pg\\\\_%'");
        hashMap = new HashMap();
        s_tableTypeClauses.put("VIEW", hashMap);
        hashMap.put("SCHEMAS", "c.relkind = 'v' AND n.nspname <> 'pg_catalog' AND n.nspname <> 'information_schema'");
        hashMap.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname NOT LIKE 'pg\\\\_%'");
        hashMap = new HashMap();
        s_tableTypeClauses.put("INDEX", hashMap);
        hashMap.put("SCHEMAS", "c.relkind = 'i' AND n.nspname NOT LIKE 'pg\\\\_%' AND n.nspname <> 'information_schema'");
        hashMap.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname NOT LIKE 'pg\\\\_%'");
        hashMap = new HashMap();
        s_tableTypeClauses.put("SEQUENCE", hashMap);
        hashMap.put("SCHEMAS", "c.relkind = 'S'");
        hashMap.put("NOSCHEMAS", "c.relkind = 'S'");
        hashMap = new HashMap();
        s_tableTypeClauses.put("SYSTEM TABLE", hashMap);
        hashMap.put("SCHEMAS", "c.relkind = 'r' AND (n.nspname = 'pg_catalog' OR n.nspname = 'information_schema')");
        hashMap.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname LIKE 'pg\\\\_%' AND c.relname NOT LIKE 'pg\\\\_toast\\\\_%' AND c.relname NOT LIKE 'pg\\\\_temp\\\\_%'");
        hashMap = new HashMap();
        s_tableTypeClauses.put("SYSTEM TOAST TABLE", hashMap);
        hashMap.put("SCHEMAS", "c.relkind = 'r' AND n.nspname = 'pg_toast'");
        hashMap.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname LIKE 'pg\\\\_toast\\\\_%'");
        hashMap = new HashMap();
        s_tableTypeClauses.put("SYSTEM TOAST INDEX", hashMap);
        hashMap.put("SCHEMAS", "c.relkind = 'i' AND n.nspname = 'pg_toast'");
        hashMap.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname LIKE 'pg\\\\_toast\\\\_%'");
        hashMap = new HashMap();
        s_tableTypeClauses.put("SYSTEM VIEW", hashMap);
        hashMap.put("SCHEMAS", "c.relkind = 'v' AND (n.nspname = 'pg_catalog' OR n.nspname = 'information_schema') ");
        hashMap.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname LIKE 'pg\\\\_%'");
        hashMap = new HashMap();
        s_tableTypeClauses.put("SYSTEM INDEX", hashMap);
        hashMap.put("SCHEMAS", "c.relkind = 'i' AND (n.nspname = 'pg_catalog' OR n.nspname = 'information_schema') ");
        hashMap.put("NOSCHEMAS", "c.relkind = 'v' AND c.relname LIKE 'pg\\\\_%' AND c.relname NOT LIKE 'pg\\\\_toast\\\\_%' AND c.relname NOT LIKE 'pg\\\\_temp\\\\_%'");
        hashMap = new HashMap();
        s_tableTypeClauses.put("TEMPORARY TABLE", hashMap);
        hashMap.put("SCHEMAS", "c.relkind = 'r' AND n.nspname LIKE 'pg\\\\_temp\\\\_%' ");
        hashMap.put("NOSCHEMAS", "c.relkind = 'r' AND c.relname LIKE 'pg\\\\_temp\\\\_%' ");
        hashMap = new HashMap();
        s_tableTypeClauses.put("TEMPORARY INDEX", hashMap);
        hashMap.put("SCHEMAS", "c.relkind = 'i' AND n.nspname LIKE 'pg\\\\_temp\\\\_%' ");
        hashMap.put("NOSCHEMAS", "c.relkind = 'i' AND c.relname LIKE 'pg\\\\_temp\\\\_%' ");
        s_defaultTableTypes = new String[]{"TABLE", "VIEW", "INDEX", "SEQUENCE", "TEMPORARY TABLE"};
    }
}

