/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.jdbc.SPIConnection;
import org.postgresql.pljava.jdbc.TypeOid;

public abstract class AbstractResultSetMetaData
implements ResultSetMetaData {
    private Connection m_conn = null;

    public abstract int getColumnCount() throws SQLException;

    public abstract boolean isAutoIncrement(int var1) throws SQLException;

    public final boolean isCaseSensitive(int n) throws SQLException {
        this.checkColumnIndex(n);
        Oid oid = this.getOid(n);
        return oid.equals(TypeOid.TEXT) || oid.equals(TypeOid.BYTEA) || oid.equals(TypeOid.VARCHAR) || oid.equals(TypeOid.BPCHAR);
    }

    public final boolean isSearchable(int n) throws SQLException {
        this.checkColumnIndex(n);
        return true;
    }

    public final boolean isCurrency(int n) throws SQLException {
        this.checkColumnIndex(n);
        return false;
    }

    public final int isNullable(int n) throws SQLException {
        this.checkColumnIndex(n);
        return 2;
    }

    public final boolean isSigned(int n) throws SQLException {
        this.checkColumnIndex(n);
        Oid oid = this.getOid(n);
        return oid.equals(TypeOid.INT2) || oid.equals(TypeOid.INT4) || oid.equals(TypeOid.INT8) || oid.equals(TypeOid.FLOAT4) || oid.equals(TypeOid.FLOAT8);
    }

    public final int getColumnDisplaySize(int n) throws SQLException {
        this.checkColumnIndex(n);
        Oid oid = this.getOid(n);
        if (oid.equals(TypeOid.INT2)) {
            return 6;
        }
        if (oid.equals(TypeOid.INT4) || oid.equals(TypeOid.FLOAT4)) {
            return 11;
        }
        if (oid.equals(TypeOid.INT8) || oid.equals(TypeOid.NUMERIC) || oid.equals(TypeOid.FLOAT8) || oid.equals(TypeOid.OID)) {
            return 20;
        }
        if (oid.equals(TypeOid.BOOL)) {
            return 3;
        }
        if (oid.equals(TypeOid.DATE)) {
            return 13;
        }
        if (oid.equals(TypeOid.TIME)) {
            return 10;
        }
        if (oid.equals(TypeOid.TIMESTAMP) || oid.equals(TypeOid.TIMESTAMPTZ)) {
            return 25;
        }
        return this.getFieldLength(n);
    }

    public abstract String getColumnLabel(int var1) throws SQLException;

    public String getColumnName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return this.getColumnLabel(n);
    }

    public final String getSchemaName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return "";
    }

    public final int getPrecision(int n) throws SQLException {
        this.checkColumnIndex(n);
        Oid oid = this.getOid(n);
        if (oid.equals(TypeOid.INT2)) {
            return 5;
        }
        if (oid.equals(TypeOid.INT4)) {
            return 10;
        }
        if (oid.equals(TypeOid.INT8) || oid.equals(TypeOid.OID)) {
            return 20;
        }
        if (oid.equals(TypeOid.FLOAT4)) {
            return 8;
        }
        if (oid.equals(TypeOid.FLOAT8)) {
            return 16;
        }
        if (oid.equals(TypeOid.BOOL)) {
            return 1;
        }
        if (oid.equals(TypeOid.NUMERIC)) {
            return -1;
        }
        return 0;
    }

    public final int getScale(int n) throws SQLException {
        this.checkColumnIndex(n);
        Oid oid = this.getOid(n);
        if (oid.equals(TypeOid.FLOAT4)) {
            return 8;
        }
        if (oid.equals(TypeOid.FLOAT8)) {
            return 16;
        }
        if (oid.equals(TypeOid.NUMERIC)) {
            return -1;
        }
        return 0;
    }

    public final String getTableName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return "";
    }

    public final String getCatalogName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return "";
    }

    public final int getColumnType(int n) throws SQLException {
        this.checkColumnIndex(n);
        return ((SPIConnection)this.getDefaultConnection()).getSQLType(this.getOid(n));
    }

    public final String getColumnTypeName(int n) throws SQLException {
        this.checkColumnIndex(n);
        return ((SPIConnection)this.getDefaultConnection()).getPGType(this.getOid(n));
    }

    public final boolean isReadOnly(int n) throws SQLException {
        this.checkColumnIndex(n);
        return true;
    }

    public final boolean isWritable(int n) throws SQLException {
        this.checkColumnIndex(n);
        return false;
    }

    public final boolean isDefinitelyWritable(int n) throws SQLException {
        this.checkColumnIndex(n);
        return false;
    }

    public abstract String getColumnClassName(int var1) throws SQLException;

    protected abstract void checkColumnIndex(int var1) throws SQLException;

    protected abstract Oid getOid(int var1) throws SQLException;

    protected abstract int getFieldLength(int var1) throws SQLException;

    private Connection getDefaultConnection() throws SQLException {
        if (this.m_conn == null) {
            this.m_conn = DriverManager.getConnection("jdbc:default:connection");
        }
        return this.m_conn;
    }
}

