<?php // $Id: stats-convert.php,v 1.4 2001/05/07 06:48:25 ciaccia Exp $ - #phpAdsNew Revision: 1.6 #

/************************************************************************/
/* phpAdsNew 2                                                          */
/* ===========                                                          */
/*                                                                      */
/* Copyright (c) 2001 by Niels Leenheer                                 */
/* http://sourceforge.net/projects/phpadsnew                            */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/



// Include required files
require ("config.php");


// Security check
phpAds_checkAccess(phpAds_Admin);



/*********************************************************/
/* Build frameset                                        */
/*********************************************************/

if ($command == 'frame')
{
	echo "<html>";
	echo "<frameset rows='50,*' frameborder='no' border='0' framespacing='0'>";
	echo "<frame name='top' src='stats-convert.php?command=top' scrolling='no' marginwidth='0' marginheight='0' frameborder='no' noresize>";
	echo "<frame name='bottom' src='stats-convert.php?command=start' scrolling='yes' marginwidth='0' marginheight='0' frameboder='no'>";
	echo "</frameset>";
	echo "</html>";
}



/*********************************************************/
/* Build header                                          */
/*********************************************************/

if ($command == 'top')
{
	echo "<html><head>";
	echo "<link rel='stylesheet' href='interface.css'>";
	echo "</head>";
	
	echo "<body bgcolor='#000088'>";
	echo "<table width='100%' height='100%' cellpadding='0' cellspacing='0' border='0'>";
	echo "<tr><td><span class='phpAdsNew'>&nbsp;$phpAds_name</span></td></tr>";
	echo "</table>";
	echo "</body></html>";
}



/*********************************************************/
/* Build information and start button                    */
/*********************************************************/

if ($command == 'start')
{
	echo "<html><head>";
	echo "<link rel='stylesheet' href='interface.css'>";
	echo "</head><body>";
	echo "<table width='100%' cellpadding='0' cellspacing='0' border='0'>";
	echo "<tr><td height='25' colspan='3'>&nbsp;</td></tr>";
	
	echo "<tr><td><img src='images/spacer.gif' width='30'></td><td>";
	
	if ($phpAds_compact_stats)
	{
		$viewresult = db_query("SELECT COUNT(*) AS cnt FROM $phpAds_tbl_adviews");
		$viewrow = @pg_fetch_array($viewresult, 0);
		$verboseviews = $viewrow["cnt"];
		
		$clickresult = db_query("SELECT COUNT(*) AS cnt FROM $phpAds_tbl_adclicks");
		$clickrow = @pg_fetch_array($viewresult, 0);
		$verboseclicks = $clickrow["cnt"];
		
		if ($verboseviews > 0 || $verboseclicks > 0)
		{
			echo "You have enabled the compact statistics, but your old statistics are still 
				  in verbose format. As long as the verbose statistics aren't converted to compact format 
				  they will not be used while viewing these pages.<br>
				  <b>Before converting your statistics, make a backup of the database!</b><br><br>
  				  Do you want to convert your verbose statistics to the 
				  new compact format?
				 ";
			echo "<br><br>";
			echo "<a href='stats-convert.php?command=overview'><img src='images/go_blue.gif' border='0'>&nbsp;Start</a>";
		}
		else
		{
			echo "There is nothing to convert to compact stats";
		}
	}
	else
	{
		echo "You are using verbose stats, there is no need to convert anything";
	}
	
	echo "</td><td><img src='images/spacer.gif' width='30'></td></tr>";
	echo "</body></html>";
}



/*********************************************************/
/* Build overview and call to conversion routines        */
/*********************************************************/

if ($command == 'overview')
{
	if (!phpAds_convertTableExists())
	{
		// Setup a new conversion
		phpAds_convertTableCreate();
		
		$day = array();
		
		$overviewresult = @db_query("SELECT bannerid, count(*) as count, DATE_FORMAT(t_stamp::date, '$date_format') as date_f, DATE_FORMAT(t_stamp::date, 'YYYY-MM-DD') as date FROM $phpAds_tbl_adviews GROUP BY t_stamp::date, bannerid");
		for ($pgc = 0; $overviewrow = @pg_fetch_array($overviewresult, $pgc); $pgc++)
		{
			$day[$overviewrow['date']][$overviewrow['bannerid']]['views'] = $overviewrow['count'];
			$day[$overviewrow['date']][$overviewrow['bannerid']]['date_f'] = $overviewrow['date_f'];
		}
// echo "<pre>"; print_r($day); exit;
		
		$overviewresult = @db_query("SELECT bannerid, count(*) as count, DATE_FORMAT(t_stamp::date, '$date_format') as date_f, DATE_FORMAT(t_stamp::date, 'YYYY-MM-DD') as date FROM $phpAds_tbl_adclicks GROUP BY t_stamp::date, bannerid");
		for ($pgc = 0; $overviewrow = @pg_fetch_array($overviewresult); $pgc++)
		{
			$day[$overviewrow['date']][$overviewrow['bannerid']]['clicks'] = $overviewrow['count'];
			$day[$overviewrow['date']][$overviewrow['bannerid']]['date_f'] = $overviewrow['date_f'];
		}
		
		for (reset($day);$key=key($day);next($day))
		{
			$section_year = substr ($key, 0, 4);
			$section_month  = substr ($key, 5, 2);
			$section_day  = substr ($key, 8, 2);
			
			$begin_stamp = date ("Y-m-d 00:00:00", mktime(0, 0, 0, $section_month, $section_day, $section_year));
			$end_stamp = date ("Y-m-d 00:00:00", mktime(0, 0, 0, $section_month, $section_day, $section_year) + 86400);
			
			$banner = $day[$key];
			
			for (reset($banner);$bkey=key($banner);next($banner))
			{
				$records = 0;
				if (isset($banner[$bkey]['views'])) $records += $banner[$bkey]['views'];
				if (isset($banner[$bkey]['clicks'])) $records += $banner[$bkey]['clicks'];
				
				phpAds_convertAddTask($begin_stamp, $end_stamp, $records, $bkey);
			}
		}
	}
	
	
	
	// Build HTML Taskscheduler :-)
	$result = @db_query("SELECT begin_stamp, DATE_FORMAT(begin_stamp, '$date_format') as date_f, sum(records) as sum FROM phppgadsconv WHERE status='waiting' GROUP BY begin_stamp");
	
	echo "<html><head>";
	echo "<link rel='stylesheet' href='interface.css'>";
	?>
		<script language='JavaScript'>
		<!--
			function StartCleanup()
			{
				document.images.cleanup.src = 'stats-convert.php?command=cleanup';
			}
		//-->
		</script>
	<?
	echo "</head><body onLoad=\"StartCleanup();\">";
	echo "<table width='100%' cellpadding='0' cellspacing='0' border='0'>";
	
	for ($pgc = 0; $task = @pg_fetch_array($result, $pgc); $pgc++)
	{
		echo "<tr>";
		echo "<td height='25'>&nbsp;&nbsp;<img src='stats-convert.php?command=convert&id=".$task['begin_stamp']."' width='16' height='16'></td>";
		echo "<td>".$task['date_f']."</td>";
		echo "<td>".$task['sum']." records to convert...</td>";
		echo "</tr>";
		
		echo "<tr><td colspan='3'><img src='images/break-l.gif' width='100%' height='1'></td></tr>";
	}
	
	
	echo "<tr>";
	echo "<td height='25'>&nbsp;&nbsp;<img name='cleanup' src='images/spacer.gif' width='16' height='16'></td>";
	echo "<td>&nbsp;</td>";
	echo "<td>Cleaning up...</td>";
	echo "</tr>";
	
	echo "<tr><td colspan='3'><img src='images/break-l.gif' width='100%' height='1'></td></tr>";
	
	echo "</table>";
	echo "</body></html>";
}



/*********************************************************/
/* Convert verbose stats to compact stats                */
/*********************************************************/

if ($command == 'convert')
{
	// don't let the user interupt with this process!
	// timeout this script in 10 minutes for safety
	if (!get_cfg_var ('safe_mode'))
	{
		set_time_limit (600);
		ignore_user_abort(1);
	}
	
	$error = true;
	
	if (isset($id) && $id != '')
	{
		$result = @db_query("SELECT * FROM phppgadsconv WHERE begin_stamp='$id' AND status='waiting'");
		
		if (@pg_numrows($result) > 0)
		{
			for ($pgc = 0; $task = @pg_fetch_array($result, $pgc); $pgc++)
			{
				$views = 0;
				$clicks = 0;
				
				$begintime 	= $task['begin_stamp'];
				$endtime 	= $task['end_stamp'];
				$bannerID 	= $task['bannerid'];
				$id		 	= $task['conversionid'];
				
				//echo "<br><br>ID:$id BANNERID:$bannerID > $begintime - $endtime <br>";
				
				$day = substr($begintime, 0, 4)."-".substr($begintime, 5, 2)."-".substr($begintime, 8, 2);
				
				$countresult = @db_query("SELECT count(*) as count FROM $phpAds_tbl_adviews WHERE bannerID='$bannerID' AND t_stamp >= '$begintime' AND t_stamp < '$endtime'");
				if ($countrow = @pg_fetch_array($countresult, 0))
				{
					$views = $countrow['count'];
				}
				
				$countresult = @db_query("SELECT count(*) as count FROM $phpAds_tbl_adclicks WHERE bannerID='$bannerID' AND t_stamp >= '$begintime' AND t_stamp < '$endtime'"); 
				if ($countrow = @pg_fetch_array($countresult, 0))
				{
					$clicks = $countrow['count'];
				}
				
				//echo "CLICKS=$clicks VIEWS=$views <br>";
				
				if ($clicks > 0 || $views > 0)
				{
					$checkresult = @db_query("SELECT count(*) as count FROM $phpAds_tbl_adstats WHERE day='$day' AND bannerID='$bannerID'");
					$checkrow = @pg_fetch_array ($checkresult, 0);
					
					if (isset($checkrow['count']) && $checkrow['count'] > 0)
					{
						//echo "UPDATE $phpAds_tbl_adstats SET clicks=clicks+$clicks, views=views+$views WHERE day='$day' AND bannerID='$bannerID' <br>";
						$updateresult = @db_query("UPDATE $phpAds_tbl_adstats SET clicks=clicks+$clicks, views=views+$views WHERE day='$day' AND bannerID='$bannerID'");
						
						if (@pg_cmdtuples($updateresult) > 0)
						{
							phpAds_convertSetStatus ($id, 'finished');
							$error = false;
						}
						else
							phpAds_convertSetStatus ($id, 'error');
					}
					else
					{
						//echo "INSERT INTO $phpAds_tbl_adstats SET bannerID='$bannerID', day='$day', clicks=$clicks, views=$views <br>";
						$updateresult = @db_query("INSERT INTO $phpAds_tbl_adstats (bannerID, day, clicks, views) VALUES('$bannerID', '$day', $clicks, $views)");
						
						if (@pg_cmdtuples($updateresult) > 0)
						{
							phpAds_convertSetStatus ($id, 'finished');
							$error = false;
						}
						else
							phpAds_convertSetStatus ($id, 'error');
					}
				}
			}
		}
	}
	
	
	if ($error)
	{
		header ("Content-type: image/gif");
		include ("../nocache.inc.php");
		$image = @fopen ('images/delete.gif', 'r');
		fpassthru ($image);
		fclose ($image);
	}
	else
	{
		header ("Content-type: image/gif");
		include ("../nocache.inc.php");
		$image = @fopen ('images/save.gif', 'r');
		fpassthru ($image);
		fclose ($image);
	}
	
	//echo "$error <br>";
}



/*********************************************************/
/* Cleanup mess                                          */
/*********************************************************/

if ($command == 'cleanup')
{
	if (!get_cfg_var ('safe_mode'))
	{
		set_time_limit (600);
		ignore_user_abort(1);
	}
	
	$error = true;
	$status = array();
	
//	db_query("BEGIN");
	
	$result = @db_query("select status, count(*) as count from phppgadsconv group by status");
	for ($pgc = 0; $row = @pg_fetch_array($result, $pgc); $pgc++)
	{
		$status[$row['status']] = $row['count'];
	}
	
	if (sizeof($status) == 1 && isset ($status['finished']))
	{
		// Only one type of status and status = finished
		// Clean up whole table
		@db_query("delete from $phpAds_tbl_adviews");
		phpAds_convertTableDrop();
		$error = false;
	}
	elseif (sizeof($status) == 2 && isset ($status['finished']) && isset ($status['error']))
	{
		$result = @db_query("select * from phppgadsconv where status='error'");
		
		$where = "";
		
		for ($pgc = 0; $error = @pg_fetch_array($result, $pgc); $pgc++)
		{
			$begintime 	= $error['begin_stamp'];
			$endtime 	= $error['end_stamp'];
			$bannerID 	= $error['bannerid'];
			
			if ($where == "")
			{
				$where .= "(bannerID='$bannerID' AND t_stamp >= $begintime AND t_stamp < $endtime)";
			}
			else
			{
				$where .= " OR (bannerID='$bannerID' AND t_stamp >= $begintime AND t_stamp < $endtime)";
			}
		}
		
		if ($where != "")
			$where = "WHERE NOT ($where)";
		
		@db_query("DELETE FROM adviews $where");
		@db_query("DELETE FROM adclicks $where");
		
		$error = false;
	}
	
//	echo $error;

	if ($error)
	{
//		db_query("ROLLBACK");
		header ("Content-type: image/gif");
		include ("../nocache.inc.php");
		$image = @fopen ('images/delete.gif', 'r');
		fpassthru ($image);
		fclose ($image);
	}
	else
	{
//		db_query("END");
		header ("Content-type: image/gif");
		include ("../nocache.inc.php");
		$image = @fopen ('images/save.gif', 'r');
		fpassthru ($image);
		fclose ($image);
	}
}


function phpAds_convertTableExists()
{
	$available = false;
	$result = @db_query("SELECT * FROM pg_tables WHERE tablename = 'phppgadsconv'");
	
	return (pg_numrows($result) ? true : false);
}


function phpAds_convertTableCreate()
{
	$result = @db_query("
		CREATE TABLE phppgadsconv (
		   conversionid serial,
		   begin_stamp timestamp,
		   end_stamp timestamp,
		   status varchar(32) DEFAULT 'waiting',
		   records int4,
		   bannerid int8,
		   PRIMARY KEY (conversionid)
		)
	");
	
	echo pg_errormessage($GLOBALS["link"]);
}


function phpAds_convertTableDrop()
{
	$result = @db_query("DROP TABLE phppgadsconv");
	$result = @db_query("DROP SEQUENCE phppgadsconv_conversionid_seq");
}


function phpAds_convertAddTask($begin_stamp, $end_stamp, $records, $bannerID)
{
	$result = @db_query("
		INSERT INTO 
			phppgadsconv (begin_stamp, end_stamp, bannerID, records)
		VALUES ('$begin_stamp', '$end_stamp', '$bannerID', $records)
	");
}

function phpAds_convertSetStatus ($id, $status)
{
	$result = @db_query("
		UPDATE 
			phppgadsconv
		SET
		   	status = '$status'
		WHERE
			conversionid = $id
	");
}

?>
