SET autocommit TO 'on';

CREATE FUNCTION uuid_in(cstring)
RETURNS uuid
AS '$libdir/uuid'
LANGUAGE 'C';

CREATE FUNCTION uuid_out(uuid)
RETURNS cstring
AS '$libdir/uuid'
LANGUAGE 'C';

CREATE TYPE uuid (
	INTERNALLENGTH = 16,
	INPUT = uuid_in,
	OUTPUT = uuid_out
);

COMMENT ON TYPE uuid
  is 'UUID type for PostgreSQL';


--
--	The various boolean tests:
--

CREATE FUNCTION uuid_gt(uuid, uuid)
RETURNS bool
AS '$libdir/uuid'
LANGUAGE 'C';

CREATE FUNCTION uuid_lt(uuid, uuid)
RETURNS bool
AS '$libdir/uuid'
LANGUAGE 'C';

CREATE FUNCTION uuid_eq(uuid, uuid)
RETURNS bool
AS '$libdir/uuid'
LANGUAGE 'C';

CREATE FUNCTION uuid_ge(uuid, uuid)
RETURNS bool
AS '$libdir/uuid'
LANGUAGE 'C';

CREATE FUNCTION uuid_le(uuid, uuid)
RETURNS bool
AS '$libdir/uuid'
LANGUAGE 'C';

CREATE FUNCTION uuid_ne(uuid, uuid)
RETURNS bool
AS '$libdir/uuid'
LANGUAGE 'C';

--
--	Now the operators.  Note how some of the parameters to some
--	of the 'create operator' commands are commented out.  This
--	is because they reference as yet undefined operators, and
--	will be implicitly defined when those are, further down.
--

CREATE OPERATOR < (
	LEFTARG = uuid,
	RIGHTARG = uuid,
	NEGATOR = >=,
	PROCEDURE = uuid_lt
);

CREATE OPERATOR <= (
	LEFTARG = uuid,
	RIGHTARG = uuid,
	NEGATOR = >,
	PROCEDURE = uuid_le
);

CREATE OPERATOR = (
	LEFTARG = uuid,
	RIGHTARG = uuid,
	COMMUTATOR = =,
	NEGATOR = <>,
	PROCEDURE = uuid_eq
);

CREATE OPERATOR >= (
	LEFTARG = uuid,
	RIGHTARG = uuid,
	NEGATOR = <,
	PROCEDURE = uuid_ge
);

CREATE OPERATOR > (
	LEFTARG = uuid,
	RIGHTARG = uuid,
	NEGATOR = <=,
	PROCEDURE = uuid_gt
);

CREATE OPERATOR <> (
	LEFTARG = uuid,
	RIGHTARG = uuid,
	NEGATOR = =,
	PROCEDURE = uuid_ne
);

-- Register 'uuid' create function
CREATE FUNCTION newid(integer)
RETURNS uuid
AS '$libdir/uuid'
CALLED ON NULL INPUT
LANGUAGE 'C';

CREATE FUNCTION newid() --default is create a time base uuid
RETURNS uuid
AS '$libdir/uuid', 'newid_time'
LANGUAGE 'C';

CREATE FUNCTION newid_random()
RETURNS uuid
AS '$libdir/uuid'
LANGUAGE 'C';

CREATE FUNCTION newid_time()
RETURNS uuid
AS '$libdir/uuid'
LANGUAGE 'C';

CREATE FUNCTION newid_nil()
RETURNS uuid
AS '$libdir/uuid'
LANGUAGE 'C';

-- Register 'uuid' comparison function
CREATE FUNCTION uuid_cmp(uuid, uuid)
RETURNS int2
AS '$libdir/uuid'
LANGUAGE c;

-------------------------------------------------
-- Create default operator class for 'uuid'    --
-- Needed to create index or primary key       --
-------------------------------------------------

CREATE OPERATOR CLASS uuid_ops
DEFAULT FOR TYPE uuid USING btree 
AS
        OPERATOR        1       < ,
        OPERATOR        2       <= ,
        OPERATOR        3       = ,
        OPERATOR        4       >= ,
        OPERATOR        5       > ,
        FUNCTION        1       uuid_cmp(uuid, uuid);

-- Register util function
CREATE FUNCTION uuid_type(uuid)
RETURNS int2
AS '$libdir/uuid', 'util_uuid_type'
LANGUAGE c;

CREATE FUNCTION uuid_variant(uuid)
RETURNS int2
AS '$libdir/uuid', 'util_uuid_variant'
LANGUAGE c;

CREATE FUNCTION uuid_timestamp(uuid)
RETURNS timestamp
AS '$libdir/uuid', 'util_uuid_timestamp'
LANGUAGE c;

--
--	eof
--
