//
//  PgSQLListener.m
//  PostgresSQL
//
//  Created by Pascal on Sun Dec 15 2002.
//  Copyright (c) 2002 P3 Consulting. All rights reserved.
//

#import "PgSQLListener.h"
#import "PgSQLNotification.h"

extern NSString *PostgreSQLNotification;

@implementation PgSQLListener

+(id)newPgSQLListener:(const char *)inTableName notify:(id)inToNotify userInfo:(NSMutableDictionary *)inUserInfo 
{
		//	inToNotify must implement the PgSQLNotification protocol
		NSAssert( [inToNotify respondsToSelector:@selector(pgSQLNotify:)],@"PostgreSQL Framework: toNotify object doesn't respond to pgSQLNotify selector." )	;

		return [[[PgSQLListener alloc] initWithCondition:inTableName notify:inToNotify userInfo:inUserInfo] autorelease]	;
}

-(id)initWithCondition:(const char *)inTableName notify:inToNotify userInfo:(NSMutableDictionary *)inUserInfo
{
		self = [super init]	;
		condition = [[NSString stringWithCString:inTableName] retain]	;
		toBeNotified = [inToNotify retain]	;
		userInfo = [inUserInfo retain]	;

		[[NSNotificationCenter defaultCenter] 
			addObserver:toBeNotified
			selector:@selector(pgSQLNotify:)
			name:PostgreSQLNotification
			object:nil]	;

		return self	;
}

-(NSString *)getCondition;
{
		return [NSString stringWithString:condition]	;
}

-(id)toBeNotified
{
		return toBeNotified	;
}

-(void)setToBeNotified:(id)inToBeNotified;
{
		toBeNotified = inToBeNotified	;
}

-(NSMutableDictionary *)userInfo
{
		return userInfo	;
}

-(void)dealloc
{
		[condition release]		;
		[toBeNotified release]	;
		[userInfo release]		;
		[super dealloc]			;
}

@end
