
# $Id: Makefile.PL,v 1.19 2002/11/25 20:56:11 bmomjian Exp $

use ExtUtils::MakeMaker;
use Config;
use strict;

my $OBJ_EXT=".o";
my $MAN3EXT=".3";

print "Configuring Pg\n";
print "Remember to actually read the README file !\n";

my $POSTGRES_INCLUDE;
my $POSTGRES_LIB;

if ((!$ENV{POSTGRES_INCLUDE} or !$ENV{POSTGRES_LIB}) and !$ENV{POSTGRES_HOME}) {
#    die "please set environment variables POSTGRES_INCLUDE and POSTGRES_LIB !\n";
    require App::Info::RDBMS::PostgreSQL;
    require App::Info::Handler::Prompt;
    my $p = App::Info::Handler::Prompt->new;
    my $pg = App::Info::RDBMS::PostgreSQL->new(on_unknown => $p, on_confirm => $p);
    $POSTGRES_INCLUDE = $pg->inc_dir;
    $POSTGRES_LIB     = $pg->lib_dir;
} elsif ((!$ENV{POSTGRES_INCLUDE} or !$ENV{POSTGRES_LIB}) and $ENV{POSTGRES_HOME}) {
    $POSTGRES_INCLUDE = "$ENV{POSTGRES_HOME}/include";
    $POSTGRES_LIB     = "$ENV{POSTGRES_HOME}/lib";
} else {
    $POSTGRES_INCLUDE = "$ENV{POSTGRES_INCLUDE}";
    $POSTGRES_LIB     = "$ENV{POSTGRES_LIB}";
}

my $os = $^O;
print "OS: $os\n";

my %opts = (
    NAME         => 'Pg',
    VERSION_FROM => "Pg.pm",
    INC          => "-I$POSTGRES_INCLUDE",
    OBJECT       => "Pg\$(OBJ_EXT)",
    LIBS         => ["-L$POSTGRES_LIB -lpq"],
    AUTHOR       => 'http://gborg.postgresql.org/project/pgperl/projdisplay.php',
    ABSTRACT     => 'PostgreSQL database native Perl driver',
);

if ($os eq 'hpux') {
    my $osvers = $Config{osvers};
    if ($osvers < 10) {
        print "Warning: Forced to build static not dynamic on $os $osvers.\a\n";
        $opts{LINKTYPE} = 'static';
    }
}

if ($Config{dlsrc} =~ /dl_none/) {
    $opts{LINKTYPE} = 'static';
}

WriteMakefile(%opts);

exit(0);

# end of Makefile.PL
