<?
/* signup.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi <pratesi@telug.it> */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include("../application.inc.php");
if (!isset($usertype)) { $usertype = "pf"; }

/* form has been submitted, try to create the new user account */
if (match_referer() && isset($HTTP_POST_VARS) && !isset($from_menu)) {
	$frm = $HTTP_POST_VARS;
	$errormsg = validate_form($frm, $errors, $usertype);

	if (empty($errormsg)) {
		insert_user($frm, $usertype);

		$DOC_TITLE = $Signup_Successful;
		include("$CFG->templatedir"."header.ihtml");
		include("templates/".$SESSION["lang"]."/signup_success.ihtml");
		include("$CFG->templatedir"."footer.ihtml");
		die;
	}

	if ($HTTP_POST_VARS["hiddencountry"] == "it")
		$country = "it";
}

$DOC_TITLE = $Signup;
include("$CFG->templatedir"."header.ihtml");
include("$CFG->templatedir"."form_header.ihtml");
if (empty($errormsg)) {	// we are loading the form for the first time
	$frm["acceptadvert"] = 1;
}
include("templates/signup_form-".$usertype.".ihtml");
include("$CFG->templatedir"."footer.ihtml");

/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function validate_form(&$frm, &$errors, $usertype) {
/* validate the signup form, and return the error messages in a string.  if
 * the string is empty, then there are no errors */

	global $CFG, $SESSION;
	include ($CFG->global);

	$errors = new Object;
	$msg = "";

	validate_username($frm["username"], &$errors, &$msg);
	if ($frm["password"] == $frm["passwordconfirm"]) {
		validate_password($frm["password"], &$errors, &$msg);
	} else {
		$errors->password = true;
		$msg .= "<li>".$passwords_do_not_match;
	}
	if ($usertype == "pf") {
		validate_firstname($frm["firstname"], &$errors, &$msg);
		validate_lastname($frm["lastname"], &$errors, &$msg);
		if ($frm["hiddencountry"] == "it") {
			validate_fiscalcode($frm["fiscalcode"], &$errors, &$msg);
		}
	} else if ($usertype == "az") {
		validate_ragionesociale($frm["firstname"], &$errors, &$msg);
		validate_partitaiva($frm["fiscalcode"], &$errors, &$msg);
	}
	validate_address($frm["address"], &$errors, &$msg);
	validate_number($frm["number"], &$errors, &$msg);
	validate_city($frm["city"], &$errors, &$msg);
	validate_country($frm["country"], &$errors, &$msg);
	validate_zip_code($frm["zip_code"], &$errors, &$msg);
	validate_phone($frm["phone"], &$errors, &$msg);
	validate_fax($frm["fax"], &$errors, &$msg);
	validate_mobilephone($frm["mobilephone"], &$errors, &$msg);
	validate_email($frm["email"], &$errors, &$msg);
	validate_notes($frm["notes"], &$errors, &$msg);

	if (username_exists($frm["username"])) {
		$errors->username = true;
		$msg = "<li>" . $the_username . " <b>" . ov($frm["username"]) ."</b> " . $already_exists . $msg;

	} /* elseif (email_exists($frm["email"])) {
		$errors->email = true;
		$msg .= "<li>" . $the_email_address . " <b>" . ov($frm["email"]) ."</b> " . $already_exists;
	} */

	return $msg;
}

function insert_user(&$frm, $usertype) {
/* add the new user into the database */

	global $CFG, $SESSION, $myday, $mymonth;

	$date = $myday[date("w")] . date(" j") . "-" . date("n") . "-" . date("Y H:i:s");
	$fromip = getenv("REMOTE_ADDR");

	$qid = db_query("
	INSERT INTO users (
		username
		,password
		,usertype
		,firstname
		,lastname
		,fiscalcode
		,address
		,number
		,city
		,country
		,zip_code
		,phone
		,fax
		,mobilephone
		,email
		,authdata
		,acceptadvert
		,notes
		,date
		,fromip
	) VALUES (
		 '$frm[username]'
		,'$frm[password]'
		,'$usertype'
		,'$frm[firstname]'
		,'$frm[lastname]'
		,'$frm[fiscalcode]'
		,'$frm[address]'
		,'$frm[number]'
		,'$frm[city]'
		,'$frm[country]'
		,'$frm[zip_code]'
		,'$frm[phone]'
		,'$frm[fax]'
		,'$frm[mobilephone]'
		,'$frm[email]'
		,'$frm[authdata]'
		,'$frm[acceptadvert]'
		,'$frm[notes]'
		,'$date'
		,'$fromip'
	)");
}

?>
