<?

/* (c) 2000 Fabio Molinari <fabio.m@mclink.it>
 * (c) 2000, 2001 Marco Pratesi <pratesi@telug.it>
 * (c) 2000 Oleg V. Kalashnikov <oleg@ok.gnu.zp.ua>
 * (c) 2000 Ying Zhang <ying@zippydesign.com>
 */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include("../application.inc.php");
global $CFG, $ME;
global $SESSION;
global $weightunity;
include ($CFG->global);

$DOC_TITLE = $AdvancedSearch;
include("$CFG->templatedir"."header.ihtml");

/* Form has been submitted, let's go searching. */

if (match_referer() && !isset($from_menu)) {
	if (!isset($page_number)) {
		$page_number = 1;
		if ($product_name_min == ""
		 && $product_name_max == ""
		 && $product_name_in == ""
		 && $brand_id == ""
		 && $description_min == ""
		 && $description_max == ""
		 && $name_in == ""
		 && $price_min == ""
		 && $price_max == ""
		 && $discount_min == ""
		 && $discount_max == ""
		 && $discqty_min == ""
		 && $discqty_max == ""
		 && $weight_min == ""
		 && $weight_max == "") {
			$errormsg->emptyform = true;
		} else {
			$SESSION["product_name_min"] = $product_name_min;
			$SESSION["product_name_max"] = $product_name_max;
			$SESSION["product_name_in"] = $product_name_in;
			$SESSION["brand_id"] = $brand_id;
			$SESSION["prod_concatenation"] = $prod_concatenation;
			$SESSION["prod_case_sensitive"] = $prod_case_sensitive;
			$SESSION["description_min"] = $description_min;
			$SESSION["description_max"] = $description_max;
			$SESSION["name_in"] = $name_in;
			$SESSION["desc_concatenation"] = $desc_concatenation;
			$SESSION["desc_case_sensitive"] = $desc_case_sensitive;
			$SESSION["price_min"] = $price_min;
			$SESSION["price_max"] = $price_max;
			$SESSION["discount_min"] = $discount_min;
			$SESSION["discount_max"] = $discount_max;
			$SESSION["discqty_min"] = $discqty_min;
			$SESSION["discqty_max"] = $discqty_max;
			$SESSION["weight_min"] = $weight_min;
			$SESSION["weight_max"] = $weight_max;
			$errormsg = validate_form($SESSION, $errors);
		}
		if (empty($errormsg)) {
			$qid_p = advanced_find_products(&$SESSION);
			$SESSION["numr"] = db_num_rows($qid_p);
			for ($i=0; $i<$SESSION["numr"]; $i++) {
				$SESSION["searchres"][$i] = db_fetch_array($qid_p, $i);
			}
		}
	}
	if (empty($errormsg)) {
		$SESSION["goback"]["request_uri"] = $REQUEST_URI;
		$SESSION["goback"]["query_string"] = $QUERY_STRING;
		if ($SESSION["numr"] > $SESSION["max_results"]) {
			include("templates/".$SESSION["lang"]."/too_many_results.ihtml");
		} else if ($SESSION["numr"] > $SESSION["products_per_page"]) {
			$first = ($page_number-1)*$SESSION["products_per_page"];
			$last = $SESSION["numr"] < $page_number*$SESSION["products_per_page"] ? $SESSION["numr"]-1 : $page_number*$SESSION["products_per_page"]-1;
			$num_pages = $SESSION["numr"] / $SESSION["products_per_page"];
			if (!($num_pages == (integer) $num_pages)) {
				$num_pages = (integer) $num_pages + 1;
			}
			include("templates/search_results.ihtml");
		} else {
			$first = 0;
			$last = $SESSION["numr"] - 1;
			include("templates/search_results.ihtml");
		}
		include("$CFG->templatedir"."footer.ihtml");
		die;
	}
}

if ($SESSION["brand_used"]) {
	$qid = db_query("SELECT id, name FROM brands");
	$SESSION["brands"] = array();
	$numr = db_num_rows($qid);
	$SESSION["numbrands"] = $numr;
	for ($i=0; $i<$numr; $i++) {
		$brand = db_fetch_object($qid, $i);
		$SESSION["brand"][$i]["id"] = $brand->id;
		$SESSION["brand"][$i]["name"] = $brand->name;
	}
}
include("templates/advanced_search_form.ihtml");
include("$CFG->templatedir"."footer.ihtml");


/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function validate_form(&$frm, &$errors) {
/* validate the form, and return the error messages in a string.  if
 * the string is empty, then there are no errors */

	global $CFG, $SESSION;
	include ($CFG->global);

	$errors = new Object;
	$errormsg = "";

	if(!empty($frm["product_name_min"])) {
		validate_product_name($frm["product_name_min"], &$errors, &$errormsg);
		if ($errors->product_name) $errors->product_name_min = true;
	}
	if(!empty($frm["product_name_max"])) {
		validate_product_name($frm["product_name_max"], &$errors, &$errormsg);
		if ($errors->product_name) $errors->product_name_max = true;
	}
	if(!empty($frm["description_min"])) {
		validate_product_description($frm["description_min"], &$errors, &$errormsg);
		if ($errors->product_description) $errors->description_min = true;
	}
	if(!empty($frm["description_max"])) {
		validate_product_description($frm["description_max"], &$errors, &$errormsg);
		if ($errors->product_description) $errors->description_max = true;
	}
	if(!empty($frm["price_min"])) {
		validate_price($frm["price_min"], &$errors, &$errormsg);
		if ($errors->price) $errors->price_min = true;
	}
	if(!empty($frm["price_max"])) {
		validate_price($frm["price_max"], &$errors, &$errormsg);
		if ($errors->price) $errors->price_max = true;
	}
//	if(!empty($frm["discount_min"]) || !empty($frm["discqty_min"])) {
//		validate_discount($frm["discount_min"], $frm["discqty_min"], &$errors, &$errormsg);
//		if ($errors->discount) $errors->discount_min = true;
//		if ($errors->discqty) $errors->discqty_min = true;
//	}
//	if(!empty($frm["discount_max"]) || !empty($frm["discqty_max"])) {
//		validate_discount($frm["discount_max"], $frm["discqty_max"], &$errors, &$errormsg);
//		if ($errors->discount) $errors->discount_max = true;
//		if ($errors->discqty) $errors->discqty_max = true;
//	}
	if(!empty($frm["discount_min"])) {
		validate_searched_discount($frm["discount_min"], &$errors, &$errormsg);
		if ($errors->discount) $errors->discount_min = true;
	}
	if(!empty($frm["discount_max"])) {
		validate_searched_discount($frm["discount_max"], &$errors, &$errormsg);
		if ($errors->discount) $errors->discount_max = true;
	}
	if(!empty($frm["discqty_min"])) {
		validate_searched_discqty($frm["discount_min"], &$errors, &$errormsg);
		if ($errors->discqty) $errors->discqty_min = true;
	}
	if(!empty($frm["discqty_max"])) {
		validate_searched_discqty($frm["discount_max"], &$errors, &$errormsg);
		if ($errors->discqty) $errors->discqty_max = true;
	}
	if(!empty($frm["weight_min"])) {
		validate_weight($frm["weight_min"], &$errors, &$errormsg);
		if ($errors->weight) $errors->weight_min = true;
	}
	if(!empty($frm["weight_max"])) {
		validate_weight($frm["weight_max"], &$errors, &$errormsg);
		if ($errors->weight) $errors->weight_max = true;
	}

	return $errormsg;
}

?>
