/*
	log.h

	The Log class implements asynchronous message logging using the process
	security credentials. The clients of the class may have impersonated less-
	privileged users and thus may not have sufficient access to the log files.

	Project: pgjobs
	Author: Zlatko Michailov
	Created:  1-Oct-2003
	Updated:  2-Oct-2003
	Updated:  6-Oct-2003
	Updated:  5-May-2004

	This file is provided as is, with no warranty. Use at your own risk.

	Copyright (c) 2003-2004, Zlatko Michailov

*/



#ifndef __LOG_H__
#define __LOG_H__



//--------------------------------------------------------------------------------

#include <string>
#include "../../../msdk/include/msdk.h"
#include "defs.h"


using namespace std;
using namespace msdk;



//--------------------------------------------------------------------------------
// Log Message:
// This class is used internally by class Log. It is defined separately for
// clarity of the source code.

// Advance declaration
class Log;



class LogMessage : public Message
{
	friend class Log;


// Data members
protected:
	const char*		Agent;
	const char*		Status;
	const tm*		Timestamp;
	const char*		Text;


// Constructors
public:
	LogMessage( int command, const char* agent, const char* status = 0, const char* text = 0 );
	LogMessage( const Message& message );
};



//--------------------------------------------------------------------------------
// Class Log exposes a public synchronous method to generate and post a LogMessage
// whilst the processing of the message is asynchronous.

class Log : public Thread
{
public:
	bool InitAgent( const char* agent );
	bool Record( const char* agent, const char* status, const char* text );


protected:
	bool GetLogOutput( const LogMessage& logMsg, string& logFilePath, string& line );
	bool RecordInternal( const LogMessage& logMsg );


// Overridables
protected:
	void ProcessMessage( const Message& message );


// Self test
public:
	void SelfTest( ostream& out );

};



#endif	// __LOG_H__


