/*
	config-test.cpp

	The Config class implements all the functionality related to manipulating
	the pgjobs configuration settings. This file is built in both the agent
	and the configuration tool.

	This is testing code for the Config class.

	Project: pgjobs
	Author: Zlatko Michailov
	Created: 26-Jul-2003
	Updated: 27-Jul-2003
	Updated:  2-Aug-2003
	Updated:  3-Aug-2003

	This file is provided as is, with no warranty. Use at your own risk.

	Copyright (c) 2003, Zlatko Michailov

*/



//--------------------------------------------------------------------------------

#include "config.h"

using namespace std;



//--------------------------------------------------------------------------------
// Self test

#ifdef _DEBUG

void Config::SelfTest( ostream& out )
{
	SelfTestSeq( out );
	SelfTestPublic( out );
	SelfTestId( out );
	SelfTestRow( out );
	SelfTestColumn( out );
	SelfTestReadWrite( out );
	SelfTestRead( out );
}



void Config::SelfTestRead( ostream& out )
{
	bool ok;
	string err;
	string line;

	out << endl << "READ TEST:" << endl;

	ok = Open( false, err );
	out << "O: ";
	if ( !ok )
	{
		out << " err=" << err;
	}
	out << endl;

	while ( ok = ReadLine( line, err ) )
	{
		out << "R: " << line;
		if ( !ok )
		{
			out << " err=" << err;
		}
		out << endl;
	}

	Close();
}



void Config::SelfTestReadWrite( ostream& out )
{
	bool ok;
	string err;
	string line;

	out << endl << "READ/WRITE TEST:" << endl;

	ok = Open( true, err );
	out << "O: ";
	if ( !ok )
   	{
   		out << " err=" << err;
   	}
   	out << endl;

	while ( ok = ReadLine( line, err ) )
	{
		out << "R: " << line;
		if ( !ok )
		{
			out << " err=" << err;
		}
		out << endl;

		if ( line == "123" )
		{
			ok = WriteLine( "456", err );
			out << "W: 456";
			if ( !ok )
    		{
    			out << " err=" << err;
    		}
			out << endl;
		}
		else if ( line == "456" )
		{
			ok = WriteLine( "123", err );
			out << "W: 123";
			if ( !ok )
    		{
    			out << " err=" << err;
    		}
			out << endl;
		}
		else
		{
			ok = WriteLine( line, err );
			out << "W: " << line << endl;
		}
	}

	Close();
}



void Config::SelfTestColumn( ostream& out )
{
	bool ok;
	string err;
	string row;

	out << endl << "COLUMN TEST:" << endl;

	row = "dbagent1=col1|col2|col3";
	out << row << endl;

	for ( int i = 1; i <= 3; i++ )
	{
		string col;

		ok = GetCol( row, i, col, err );
		out << "G" << i << ": " << col;
   		if ( !ok )
   		{
   			out << " err=" << err;
   		}
   		out << endl;

		col = "xxx ";
		col[3] = ( char )( '0' + i );
		ok = SetCol( row, i, col, err );
		out << "S" << i << ": " << col;
   		if ( !ok )
   		{
   			out << " err=" << err;
   		}
   		out << endl;

		col.clear();
		ok = GetCol( row, i, col, err );
		out << "G" << i << ": " << col;
   		if ( !ok )
   		{
   			out << " err=" << err;
   		}
   		out << endl;
	}

    out << row << endl;
}



void Config::SelfTestRow( ostream& out )
{
	bool ok;
	string err;
	string row;

	out << endl << "ROW TEST:" << endl;

	row.clear();
	ok = GetRow( "system", row, err );
	out << "G: system: " << row;
	if ( !ok )
   	{
   		out << " err=" << err;
   	}
   	out << endl;

	row.clear();
	ok = GetRow( "master", row, err );
	out << "G: master: " << row;
	if ( !ok )
   	{
   		out << " err=" << err;
   	}
   	out << endl;

	row.clear();
	ok = GetRow( "1", row, err );
	out << "G: 1: " << row;
	if ( !ok )
   	{
   		out << " err=" << err;
   	}
   	out << endl;

	row.clear();
	ok = GetRow( "200", row, err );
	out << "G: 200: " << row;
	if ( !ok )
   	{
   		out << " err=" << err;
   	}
   	out << endl;

	row.clear();
	ok = GetRow( "654321", row, err );
	out << "G: 654321: " << row;
	if ( !ok )
   	{
   		out << " err=" << err;
   	}
   	out << endl;

	row.clear();
	ok = SetRow( "69", "69=NEW|123|NEW|4", err );
	out << "S: 69";
	if ( !ok )
   	{
   		out << " err=" << err;
   	}
   	out << endl;

	row.clear();
	ok = GetRow( "69", row, err );
	out << "G: 69: " << row;
	if ( !ok )
   	{
   		out << " err=" << err;
   	}
   	out << endl;

	row.clear();
	ok = SetRow( "69", "69=UPDATED|456|UPDATED|3", err );
	out << "S: 69";
	if ( !ok )
   	{
   		out << " err=" << err;
   	}
   	out << endl;

	row.clear();
	ok = GetRow( "69", row, err );
	out << "G: 69: " << row;
	if ( !ok )
   	{
   		out << " err=" << err;
   	}
   	out << endl;

	row.clear();
	ok = SetRow( "69", string(), err );
	out << "S: 69";
	if ( !ok )
   	{
   		out << " err=" << err;
   	}
   	out << endl;

	row.clear();
	ok = GetRow( "69", row, err );
	out << "G: 69: " << row;
	if ( !ok )
   	{
   		out << " err=" << err;
   	}
   	out << endl;
}



void Config::SelfTestId( ostream& out )
{
	bool ok;
	string err;
	string dbid;

	out << endl << "DBID TEST:" << endl;

	dbid.clear();
	ok = NextDbId( dbid, err );
	out << "N: " << dbid;
	if ( !ok )
   	{
   		out << " err=" << err;
   	}
   	out << endl;

	dbid.clear();
	ok = FindDbId( DbRef( "first" ), dbid, err );
	out << "F: first=" << dbid;
	if ( !ok )
   	{
   		out << " err=" << err;
   	}
   	out << endl;

	dbid.clear();
	ok = FindDbId( DbRef( "second", Default, "12345" ), dbid, err );
	out << "F: second=" << dbid;
	if ( !ok )
   	{
   		out << " err=" << err;
   	}
   	out << endl;

	dbid.clear();
	ok = FindDbId( DbRef( "third", "michailov2" ), dbid, err );
	out << "F: third=" << dbid;
	if ( !ok )
   	{
   		out << " err=" << err;
   	}
   	out << endl;

	dbid.clear();
	ok = FindDbId( DbRef( __empty ), dbid, err );
	out << "F: empty=" << dbid;
	if ( !ok )
   	{
   		out << " err=" << err;
   	}
   	out << endl;
}



void Config::SelfTestPublic( ostream& out )
{
	bool ok;
	string err;
	string row;
	string col;

	out << endl << "PUBLIC TEST:" << endl;

	row.clear();
	ok = EnableDb( DbRef( "enabled-1" ), err );
	out << "E: enabled-1";
	if ( !ok )
   	{
   		out << " err=" << err;
   	}
   	out << endl;

	row.clear();
	ok = GetDb( DbRef( "enabled-1" ), row, err );
	out << "G: enabled-1: " << row;
	if ( !ok )
   	{
   		out << " err=" << err;
   	}
   	out << endl;

	col = "xxx";
	ok = SetCol( row, 8, col, err );
	out << "SC 8: "<< col;
	if ( !ok )
	{
		out << " err=" << err;
	}
	out << endl;

	ok = SetDb( DbRef( "enabled-1" ), row, err );
	out << "S: enabled-1";
	if ( !ok )
   	{
   		out << " err=" << err;
   	}
   	out << endl;

	row.clear();
	ok = GetDb( DbRef( "enabled-1" ), row, err );
	out << "G: enabled-1: " << row;
	if ( !ok )
   	{
   		out << " err=" << err;
   	}
   	out << endl;

	row.clear();
	ok = DisableDb( DbRef( "enabled-1" ), err );
	out << "D: enabled-1";
	if ( !ok )
   	{
   		out << " err=" << err;
   	}
   	out << endl;

	row.clear();
	ok = GetDb( DbRef( "enabled-1" ), row, err );
	out << "G: enabled-1: (missing)" << row;
	if ( !ok )
   	{
   		out << " err=" << err;
   	}
   	out << endl;

	row.clear();
	ok = GetMaster( row, err );
	out << "G: master: " << row;
	if ( !ok )
   	{
   		out << " err=" << err;
   	}
   	out << endl;

	col = "xxx";
	ok = SetCol( row, 2, col, err );
	out << "SC 2: "<< col;
	if ( !ok )
	{
		out << " err=" << err;
	}
	out << endl;

	ok = SetMaster( row, err );
	out << "S: master";
	if ( !ok )
   	{
   		out << " err=" << err;
   	}
   	out << endl;

	row.clear();
	ok = GetMaster( row, err );
	out << "G: master: " << row;
	if ( !ok )
   	{
   		out << " err=" << err;
   	}
   	out << endl;

	row.erase( row.length() - 4, 4 );
	ok = SetMaster( row, err );
	out << "S: master";
	if ( !ok )
   	{
   		out << " err=" << err;
   	}
   	out << endl;

	row.clear();
	ok = GetMaster( row, err );
	out << "G: master: " << row;
	if ( !ok )
   	{
   		out << " err=" << err;
   	}
   	out << endl;
}



void Config::SelfTestSeq( ostream& out )
{
	bool			ok;
	string			err;
	StreamPosition	pos = 0;
	DbInfo			dbInfo;

	out << endl << "SEQENTIAL TEST:" << endl;

	ok = SeqGetDb( pos, dbInfo );
	while ( ok )
	{
		out << "\t" << dbInfo.ID << endl
			<< "\t" << dbInfo.Host << endl
			<< "\t" << dbInfo.Port << endl
			<< "\t" << dbInfo.Database << endl
			<< "\t" << dbInfo.LogLevel << endl
			<< "\t" << dbInfo.User << endl
			<< "\t" << dbInfo.Notification << endl
			<< "\t" << dbInfo.Recipient << endl
			<< endl;

		ok = SeqGetDb( pos, dbInfo );
	}

}



#else

void Config::SelfTest( ostream& )
{
}

void Config::SelfTestRead( ostream& )
{
}

void Config::SelfTestReadWrite( ostream& )
{
}

void Config::SelfTestColumn( ostream& )
{
}

void Config::SelfTestRow( ostream& )
{
}

void Config::SelfTestId( ostream& )
{
}

void Config::SelfTestPublic( ostream& )
{
}

#endif




