/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "viewitempopup.h"
#include "viewlistviewitem.h"
#include "../common/commentform.h"
#include "../../utils/debugger.h"

	/**
	 * Constructor
	 */
	ViewItemPopup::ViewItemPopup(QWidget *pqoParent, ViewListViewItem *poViewListViewItem)
		: QPopupMenu(pqoParent)
	{
		m_poViewListViewItem = poViewListViewItem;	// keep a reference to the view item
		
		insertItem("View/Edit Comment", this, SLOT(editComment()));				

	} // end constructor

	/**
	 * Used to get a reference to the view item that this popup was generated from.
	 */
	ViewListViewItem * ViewItemPopup::getViewListViewItem() const
	{
		return m_poViewListViewItem;
	} // end getViewListViewItem
	
	/**
	 * This slot is called by the popup menu itself when edit comment is selected.
	 */
	void ViewItemPopup::editComment()
	{
		// bring up edit comment form
		CommentForm *poCommentForm = new CommentForm(this, *((m_poViewListViewItem->getDBMasterManager())->getDBConnection()), CommentForm::ViewComment);
		poCommentForm->setObjectName(m_poViewListViewItem->getViewName());		
		poCommentForm->setComment(m_poViewListViewItem->getViewComment().c_str());
		poCommentForm->show();				
	} // end editComment

