/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef FUNCTIONGROUPITEMPOPUP_H
#define FUNCTIONGROUPITEMPOPUP_H

#include <qpopupmenu.h>
#include <qstring.h>
#include "functiongrouplistviewitem.h"

/**
 * This popup menu is fired when a user right clicks on a Function group item in the list viewer.
 */
class FunctionGroupItemPopup: public QPopupMenu
{
	Q_OBJECT
	
protected:
	FunctionGroupListViewItem * m_poFunctionGroupItem;	
	
public:
	/**
	 * Constructor
	 */
	FunctionGroupItemPopup(QWidget *pqoParent, FunctionGroupListViewItem *poFunctionGroupItem);

	/**
	 * Used to access the Function group list view item.
	 */
	FunctionGroupListViewItem * getFunctionGroupListViewItem() const;
	
protected slots:	
	/**
 	 * This slot is called by the popup menu itself when it needs to refresh the Function list.
   */	
	void refreshListOfFunctions();
		
};


#endif

