/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef DATABASELISTVIEWITEM_H
#define DATABASELISTVIEWITEM_H

#include "baselistviewitem.h"
#include "../dataaccess/dbconnection.h"
#include "../dataaccess/dbmastermanager.h"
#include "../exceptions/dbconnectionexception.h"

/**
 * This list view item is used to represent a database item.
 */
class DatabaseListViewItem: public BaseListViewItem
{
protected:
	// database connection object
	DBConnection m_oDBConnection;
	DBMasterManager m_oDBMasterMgr;
	string m_strDatabaseName;
	string m_strUserName;
	string m_strPassword;
	bool m_bPasswordEntered;
			
public:
	
	/**
 	 * Constructor
   */		
	DatabaseListViewItem(QListViewItem *pqoListViewItem);
	DatabaseListViewItem(QListViewItem *pqoListViewItem, QListViewItem *pqoAfterItem);	

	/**
	 * This method is used to set the database name.
	 */
	void setDatabaseName(const string &rstrDatabaseName);

	/**
	 * This method is used to get the database name.
	 */
	const string & getDatabaseName() const;

	/**
	 * This method is used to set the user name for the connection.
	 */
	void setUserName(const string &rstrUserName);

	/**
	 * This method is used to get the user name.
	 */
	const string & getUserName() const;

	/**
	 * This method is used to set the password for the connection.
	 */
	void setPassword(const string &rstrPassword);

	/**
	 * This method is used to get the password.
	 */
	const string & getPassword() const;

	/**
	 * This method is used to indicate that the user has entered their password.
	 * n.b. that when the user saves the database configuration file, the passwords
	 * are not saved hence each time the program is opened and used again it must
	 * prompt the user for the password.
	 */
	void setPasswordEntered(bool bPasswordEntered);

	/**
	 * This method is used to see if the password has been entered.
	 */
	bool isPasswordEntered() const;

	/**
	 * This method is used to create the connection to the database.
	 */
	void connect() throw (DBConnectionException);

	/**
 	 * Displays the right pressed menu for this item.
   */			    	
	virtual void showRightPressedMenu(const QPoint & rqoLocation, int nColumn);
	
	/**
 	 * Used to update the description.
   */			    	
	virtual void updateDescription();
	
	/**
 	 * Used to traverse all children and warn them to prepare their own children.
	 * Overloads the default implementation. Need to connect to database before
	 * grand children are initialised.
   */			    						
	virtual void initGrandChildren();
		
	/**
 	 * Used to create all the first level children of the current item.
   */			    						
	virtual void initChildren();
				
};


#endif

