/*
 * TreeInfo.java
 *
 * Created on 31 de julio de 2002, 10:59
 */

package components.treeObjects;
import pgclibrary.objects.*;
import pgclibrary.dataaccess.*;
import java.util.*;
import javax.swing.tree.*;
import javax.swing.*;
import java.sql.*;

/**
 *
 * @author  nestor
 */
public abstract class TreeInfo extends java.lang.Object {
    private ImageIcon icon = new ImageIcon(getClass().getResource("/images/shim.gif"));
    protected Vector errors = new Vector();
    private Vector properties = null;
    private TreeInfo owner = null;
    
    /** Creates a new instance of TreeInfo */
    public TreeInfo(TreeInfo _owner) {
        owner = _owner;
    }
    
    public abstract void rebuildProperties();
    public abstract Object getOID();
    
    public boolean validate(){
        errors = new Vector();
        if (Database.getMainConnection() == null){
            errors.add("No initializations parameters defined.");
            errors.add("See the connection parameters.");
        } else{
            if(!Database.getMainConnection().isConnected()){
                errors.add("The connection is not initialized.");
                errors.add("See the connection parameters.");
            }
        }
        return (errors.size() == 0);
    }
    
    public void refreshProperties(){
        properties = null;
    }
    public Vector getProperties(){
        if(properties == null){
            rebuildProperties();
        }
        return properties;
    }
    public int getPropertyIndex(TreeInfo _prop){
        Vector props = getProperties();
        int retorno = -1;
        if(_prop != null){
            for(int i= 0; (i< props.size()) && (retorno<0); i++){
                TreeInfo obj = (TreeInfo) props.get(i);
                if(_prop.equals(obj)){
                    retorno = i;
                }
            }
        }
        return retorno;
    }
    public void addProperty(TreeInfo _prop){
        if(_prop != null){
            if(properties == null){
                properties = new Vector();
            }
            properties.add(_prop);
        }
    }
    public void removeProperty(TreeInfo _prop){
        if(_prop != null){
            int idx = getPropertyIndex(_prop);
            if(idx >= 0){
                properties.remove(idx);
            }
        }
    }
    public void removeAllProperties(){
        properties = new Vector();
    }
    
    // SET AND GET METHODS
    public int getSize(){
        return getProperties().size();
    }
    public boolean isInitialized(){
        return (properties != null);
    }
    
    public boolean equals(Object _obj){
        boolean retorno = false;
        if (_obj.getClass() == this.getClass()){
            TreeInfo obj = (TreeInfo) _obj;
            if(obj.getOID() == this.getOID()){
                retorno = true;
            }
        }
        return retorno;
    }
    
    public ImageIcon getIcon(){
        return icon;
    }
    protected void setIcon(ImageIcon _icon){
        icon = _icon;
    }
    protected void setIcon(String _icon){
        icon = new ImageIcon(getClass().getResource(_icon));
    }
    
    public Vector getErrors(){
        return errors;
    }
    public String getErrorString(){
        StringBuffer retorno = new StringBuffer();
        for(int i=0; i<errors.size(); i++){
            retorno.append((String) errors.get(i));
            retorno.append("\n");
        }
        return retorno.toString();
    }
    
    public TreeInfo getOwner(){
        return owner;
    }
    
    public MainConnection getConnection(){
        return Database.getMainConnection();
    }
}
