/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.dataaccess;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import pgclibrary.dataaccess.DatabaseQuerys;
import pgclibrary.dataaccess.MainConnection;

public class DatabaseQuerys_7_1
extends DatabaseQuerys {
    protected MainConnection connection = null;
    private static Logger logger = Logger.getLogger(class$pgclibrary$dataaccess$DatabaseQuerys == null ? (class$pgclibrary$dataaccess$DatabaseQuerys = DatabaseQuerys_7_1.class$("pgclibrary.dataaccess.DatabaseQuerys")) : class$pgclibrary$dataaccess$DatabaseQuerys);
    static /* synthetic */ Class class$pgclibrary$dataaccess$DatabaseQuerys;

    public DatabaseQuerys_7_1(MainConnection mainConnection) {
        this.connection = mainConnection;
    }

    public ResultSet getGroups(String string) {
        ResultSet resultSet = null;
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("select  groname as group_name,  grolist as user_list  from pg_group where groname=? ");
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            logger.info("getGroups " + string);
            this.connection.getConnection().clearWarnings();
        }
        catch (SQLException sQLException) {
            logger.debug("Error getting groups", sQLException);
        }
        return resultSet;
    }

    public ResultSet getTableColumn(String string, String string2) {
        ResultSet resultSet = null;
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("select   attname as column_name,  attnum as column_number,  attnotnull as column_notnull,  typname as type_name,  case when pg_attribute.attlen > 0 then pg_attribute.attlen          when pg_attribute.atttypmod > 0 then pg_attribute.atttypmod-4                else -1 end as column_size,  adsrc as default_value  from pg_class, pg_type, pg_attribute left join pg_attrdef  on pg_attribute.attrelid = pg_attrdef.adrelid and pg_attribute.attnum = pg_attrdef.adnum  where pg_attribute.attrelid=pg_class.oid and pg_type.oid = atttypid  and pg_class.relname=? and pg_attribute.attname=? ");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            resultSet = preparedStatement.executeQuery();
            logger.info("getTableColumn " + string + " column " + string2);
            this.connection.getConnection().clearWarnings();
        }
        catch (SQLException sQLException) {
            logger.debug("Error getting columns", sQLException);
        }
        return resultSet;
    }

    public String getColumnDescription(String string, String string2) {
        String string3 = "";
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("select  obj_description(pg_attribute.oid) as description  from pg_attribute, pg_class  where pg_class.oid = pg_attribute.attrelid and relname=? and attname=? ");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet != null && resultSet.next() && (string3 = resultSet.getString("description")) == null) {
                string3 = "";
            }
            resultSet.close();
            preparedStatement.close();
            logger.info("getTableColumnDescription " + string + " column " + string2);
            this.connection.getConnection().clearWarnings();
        }
        catch (SQLException sQLException) {
            logger.debug("Error getting column description", sQLException);
        }
        return string3;
    }

    public ResultSet getAttributeType(String string) {
        ResultSet resultSet = null;
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("select  oid, typname as type_name, typlen as type_size   from pg_type where typname = ?");
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            logger.info("getAttributeType " + string);
            this.connection.getConnection().clearWarnings();
        }
        catch (SQLException sQLException) {
            logger.debug("Error getting attribute type", sQLException);
        }
        return resultSet;
    }

    public ResultSet getDatabases(String string) {
        ResultSet resultSet = null;
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("select  datname as database_name, usename as  database_dba,   datistemplate as database_template, datallowconn as database_allowconn  from pg_database, pg_user where pg_user.usesysid = datdba  and datname=?");
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            logger.info("Get Databases " + string);
            this.connection.getConnection().clearWarnings();
        }
        catch (SQLException sQLException) {
            logger.debug("Sql Error", sQLException);
        }
        return resultSet;
    }

    public ResultSet getUser(String string) {
        ResultSet resultSet = null;
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("select  usename as user_name, usesysid as user_sysid,  usecreatedb as user_dbcreator, valuntil as user_limitdate  from pg_user where usename=?");
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            logger.info("getUser " + string);
            this.connection.getConnection().clearWarnings();
        }
        catch (SQLException sQLException) {
            logger.debug("Sql Error", sQLException);
        }
        return resultSet;
    }

    public ResultSet getUser(long l) {
        ResultSet resultSet = null;
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("select  usename as user_name, usesysid as user_sysid,  usecreatedb as user_dbcreator, valuntil as user_limitdate  from pg_user where usesysid=?");
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            logger.info("getUser " + l);
            this.connection.getConnection().clearWarnings();
        }
        catch (SQLException sQLException) {
            logger.debug("Sql Error", sQLException);
        }
        return resultSet;
    }

    public ResultSet getIndex(String string) {
        ResultSet resultSet = null;
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("select  relname as index_name, indisclustered as index_cluster,  indisunique as index_unique,  indisprimary as index_primary  from pg_index, pg_class  where pg_class.oid = indexrelid and relname = ? ");
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            logger.info("getIndex " + string);
            this.connection.getConnection().clearWarnings();
        }
        catch (SQLException sQLException) {
            logger.debug("Sql Error", sQLException);
        }
        return resultSet;
    }

    public ResultSet getColumnNames(String string) {
        ResultSet resultSet = null;
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("select  attname as column_name  from pg_attribute, pg_class  where pg_attribute.attrelid=pg_class.oid and attnum > 0      and pg_class.relname=? ");
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            logger.info("getColumnNames " + string);
            this.connection.getConnection().clearWarnings();
        }
        catch (SQLException sQLException) {
            logger.debug("Sql Error", sQLException);
        }
        return resultSet;
    }

    public String getTableDescription(String string) {
        String string2 = new String();
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("select  obj_description(oid) as description  from pg_class where relname=? ");
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet != null && resultSet.next() && resultSet.getString("description") != null) {
                string2 = resultSet.getString("description");
            }
            resultSet.close();
            preparedStatement.close();
            logger.info("getDescription " + string);
            this.connection.getConnection().clearWarnings();
        }
        catch (SQLException sQLException) {
            logger.debug("Sql Error", sQLException);
        }
        return string2;
    }

    public ResultSet getView(String string) {
        ResultSet resultSet = null;
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("select  usename as view_owner, relname as view_name,  definition as view_definition  from pg_views, pg_class, pg_user   where pg_class.relname = pg_views.viewname  and usesysid=relowner and viewname=?");
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            logger.info("getView " + string);
            this.connection.getConnection().clearWarnings();
        }
        catch (SQLException sQLException) {
            logger.debug("Sql Error", sQLException);
        }
        return resultSet;
    }

    public ResultSet getSequence(String string) {
        ResultSet resultSet = null;
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("select  sequence_name, usename as sequence_owner,   last_value, increment_by, max_value, min_value,  cache_value, is_cycled, is_called from " + string + " , pg_class, pg_user  " + " where sequence_name = relname and pg_user.usesysid = relowner");
            resultSet = preparedStatement.executeQuery();
            logger.info("getSequence " + string);
            this.connection.getConnection().clearWarnings();
        }
        catch (SQLException sQLException) {
            logger.debug("Sql Error", sQLException);
        }
        return resultSet;
    }

    public ResultSet getTable(String string) {
        ResultSet resultSet = null;
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("select  relname as table_name, relpages as table_pages,  usename as table_owner  from pg_class, pg_user  where pg_user.usesysid=relowner and relname=?");
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            logger.info("getTable " + string);
            this.connection.getConnection().clearWarnings();
        }
        catch (SQLException sQLException) {
            logger.debug("Sql Error", sQLException);
        }
        return resultSet;
    }

    public ResultSet getIndexNames(String string) {
        ResultSet resultSet = null;
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("select a.relname as index_name  from pg_index, pg_class a, pg_class b where a.oid = pg_index.indexrelid  and b.oid = pg_index.indrelid and b.relname =? ");
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            logger.info("getIndexNames " + string);
            this.connection.getConnection().clearWarnings();
        }
        catch (SQLException sQLException) {
            logger.debug("Sql Error", sQLException);
        }
        return resultSet;
    }

    public ResultSet getTableForeignKey(String string, String string2) {
        ResultSet resultSet = null;
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("select  tgenabled as fk_enabled, tgconstrname as fk_name,  tgdeferrable as fk_deferrable, tgconstrname as fk_name,  b.relname as fk_table, tgnargs as fk_argnum,  tgargs as fk_arguments ,   (select proname from pg_trigger a, pg_proc      where a.tgconstrname = pg_trigger.tgconstrname and tgtype=9      and pg_proc.oid = a.tgfoid) as del_proc,  (select proname from pg_trigger a, pg_proc      where a.tgconstrname= pg_trigger.tgconstrname and tgtype=17      and pg_proc.oid = a.tgfoid) as upd_proc  from pg_trigger, pg_class a, pg_class b   where tgisconstraint = true and tgtype=21      and tgrelid = a.oid and tgconstrrelid = b.oid      and a.relname = ? and tgconstrname=? ");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            resultSet = preparedStatement.executeQuery();
            logger.info("getTableForeignKey " + string + " keyName " + string2);
            this.connection.getConnection().clearWarnings();
        }
        catch (SQLException sQLException) {
            logger.debug("Sql Error", sQLException);
        }
        return resultSet;
    }

    public ResultSet getTableForeignKeyNames(String string) {
        ResultSet resultSet = null;
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("select  tgconstrname as fk_name   from pg_trigger, pg_class  \twhere tgisconstraint = true and tgtype=21  and tgrelid = pg_class.oid and pg_class.relname = ? ");
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            logger.info("getTableForeignKeyNames " + string);
            this.connection.getConnection().clearWarnings();
        }
        catch (SQLException sQLException) {
            logger.debug("Sql Error", sQLException);
        }
        return resultSet;
    }

    public ResultSet getViewNames() {
        ResultSet resultSet = null;
        try {
            resultSet = this.connection.getStatement().executeQuery("select  relname as view_name from pg_class  where relkind='v' order by relname");
            logger.info("getViewNames");
            this.connection.getConnection().clearWarnings();
        }
        catch (SQLException sQLException) {
            logger.debug("Sql Error", sQLException);
        }
        return resultSet;
    }

    public ResultSet getSequenceNames() {
        ResultSet resultSet = null;
        try {
            resultSet = this.connection.getStatement().executeQuery("select  relname as sequence_name from pg_class  where relkind='S' order by relname");
            logger.info("getSequenceNames");
            this.connection.getConnection().clearWarnings();
        }
        catch (SQLException sQLException) {
            logger.debug("Sql Error", sQLException);
        }
        return resultSet;
    }

    public ResultSet getUserNames() {
        ResultSet resultSet = null;
        try {
            resultSet = this.connection.getStatement().executeQuery("select  usename as user_name from pg_user order by usename");
            logger.info("getUserNames");
            this.connection.getConnection().clearWarnings();
        }
        catch (SQLException sQLException) {
            logger.debug("Sql Error", sQLException);
        }
        return resultSet;
    }

    public ResultSet getGroupNames() {
        ResultSet resultSet = null;
        try {
            resultSet = this.connection.getStatement().executeQuery("select  groname as group_name from pg_group  order by groname");
            logger.info("getGroupNames");
            this.connection.getConnection().clearWarnings();
        }
        catch (SQLException sQLException) {
            logger.debug("Sql Error", sQLException);
        }
        return resultSet;
    }

    public ResultSet getDatabaseNames() {
        ResultSet resultSet = null;
        try {
            resultSet = this.connection.getStatement().executeQuery("select  datname as database_name from pg_database order by datname");
            logger.info("getDatabaseNames");
            this.connection.getConnection().clearWarnings();
        }
        catch (SQLException sQLException) {
            logger.debug("Sql Error", sQLException);
        }
        return resultSet;
    }

    public ResultSet getTableNames() {
        ResultSet resultSet = null;
        try {
            resultSet = this.connection.getStatement().executeQuery("select  relname as table_name from pg_class  where relkind='r' order by relname");
            logger.info("getTableNames");
            this.connection.getConnection().clearWarnings();
        }
        catch (SQLException sQLException) {
            logger.debug("Sql Error", sQLException);
        }
        return resultSet;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

