/*
 * Decompiled with CFR 0.152.
 */
package components;

import components.SQLTable;
import java.awt.Component;
import java.awt.FontMetrics;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import pgclibrary.dataaccess.dataSource;

public class SQLTableModel
extends AbstractTableModel {
    private SQLTable table = null;
    private dataSource data = null;
    private int column_count = -1;

    public SQLTableModel(SQLTable sQLTable) {
        this.table = sQLTable;
    }

    public int getColumnCount() {
        int n = 0;
        if (this.isValid()) {
            n = this.data.getColumnCount();
            if (this.column_count > 0 && this.column_count <= n) {
                n = this.column_count;
            }
        }
        return n;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public int getRowCount() {
        int n = 0;
        if (this.isValid()) {
            n = this.data.getRowCount();
        }
        return n;
    }

    public Object getValueAt(int n, int n2) {
        String string = new String();
        if (this.isValid()) {
            this.data.moveToRecord(n + 1);
            string = this.data.getElementAt(n2 + 1);
        }
        return string;
    }

    public String getColumnName(int n) {
        String string = new String();
        if (this.isValid()) {
            string = (String)this.data.getColumnNames().get(n);
        }
        return string;
    }

    public void showColumns(int n) {
        this.column_count = n;
    }

    public void setDataSource(dataSource dataSource2) {
        if (this.data != null) {
            this.data.close();
        }
        this.data = dataSource2;
        this.refresh();
    }

    private void refresh() {
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
        if (this.data != null) {
            FontMetrics fontMetrics = ((Component)this.table).getFontMetrics(this.table.getFont());
            int n = fontMetrics.charWidth('O');
            int n2 = 0;
            while (n2 < this.data.getColumnCount()) {
                TableColumn tableColumn = this.table.getColumnModel().getColumn(n2);
                int n3 = this.data.getColumnSize(n2 + 1);
                if (n3 > 30) {
                    n3 = 30;
                }
                tableColumn.setPreferredWidth(n3 * n);
                ++n2;
            }
        }
    }

    public dataSource getDataSource() {
        return this.data;
    }

    private boolean isValid() {
        return this.data != null;
    }
}

