/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.dataaccess;

import java.util.AbstractCollection;
import java.util.ArrayList;

public abstract class dataSource {
    public static final int MAX_COLUMN_SIZE = 100;
    public static final int MIN_COLUMN_SIZE = 7;
    public static final int DEFAULT_COLUMN_SIZE = 12;
    private ArrayList columnNames = new ArrayList();
    private int rowNum = 0;
    private boolean filtered = false;
    private int rec_begin;
    private int rec_end;

    public abstract void close();

    public abstract void goTop();

    public void moveToRecord(int _record) {
        if (_record < this.getRowNum()) {
            this.goTop();
        }
        while (this.getRowNum() < _record) {
            this.next();
        }
    }

    public abstract boolean next();

    public abstract boolean eof();

    public abstract int getColumnCount();

    public int getColumnSize(String _col) {
        if (_col != null) {
            return this.getColumnSize(this.columnNames.indexOf(_col.toUpperCase()) + 1);
        }
        return 10;
    }

    public abstract int getColumnSize(int var1);

    protected int validateColumnSize(int _size) {
        if (_size > 100) {
            _size = 100;
        } else if (_size < 1) {
            _size = 12;
        } else if (_size < 7) {
            _size = 7;
        }
        return _size;
    }

    public abstract String getElementAt(int var1);

    public abstract int getRowCount();

    public void setDataFilterRecord(int _rec_begin, int _rec_end) {
        this.filtered = true;
        this.rec_begin = _rec_begin;
        this.rec_end = _rec_end;
    }

    public int getRowBegin() {
        return this.rec_begin;
    }

    public int getRowEnd() {
        return this.rec_end;
    }

    public void clearFilters() {
        if (this.isFiltered()) {
            this.filtered = false;
        }
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public int getRowNum() {
        return this.rowNum;
    }

    protected void setRowNum(int _rowNum) {
        if (_rowNum < 0) {
            _rowNum = 0;
        }
        this.rowNum = _rowNum;
    }

    public String getElementAt(String _col) {
        if (_col != null) {
            return this.getElementAt(this.columnNames.indexOf(_col.toUpperCase()) + 1);
        }
        return "null";
    }

    public int getIntAt(String _col) {
        int retorno = 0;
        try {
            retorno = Integer.parseInt(this.getElementAt(_col));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retorno;
    }

    public int getIntAt(int _col) {
        int retorno = 0;
        try {
            retorno = Integer.parseInt(this.getElementAt(_col));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retorno;
    }

    public double getDoubleAt(String _col) {
        double retorno = 0.0;
        try {
            retorno = Double.parseDouble(this.getElementAt(_col));
        }
        catch (Exception e) {
            // empty catch block
        }
        return retorno;
    }

    public double getDoubleAt(int _col) {
        double retorno = 0.0;
        try {
            retorno = Double.parseDouble(this.getElementAt(_col));
        }
        catch (Exception e) {
            // empty catch block
        }
        return retorno;
    }

    public void setColumnNames(ArrayList _columnNames) {
        this.columnNames.clear();
        if (_columnNames != null) {
            int i = 0;
            while (i < _columnNames.size()) {
                this.columnNames.add(_columnNames.get(i));
                ++i;
            }
        }
    }

    public ArrayList getColumnNames() {
        return this.columnNames;
    }

    public void addColumnName(String _columnName) {
        if (_columnName != null && this.columnNames.indexOf(_columnName) < 0) {
            this.columnNames.add(_columnName.toUpperCase());
        }
    }

    public void removeColumnName(String _columnName) {
        if (_columnName != null) {
            ((AbstractCollection)this.columnNames).remove(_columnName);
        }
    }

    public boolean find(int _column, String _value) {
        boolean retorno = false;
        this.goTop();
        while (!retorno && this.next()) {
            retorno = this.getElementAt(_column).equals(_value);
        }
        return retorno;
    }
}

