/*
 * ViewList.java
 *
 * Created on 31 de julio de 2002, 10:58
 */

package pgclibrary.treeObjects;
import pgclibrary.objects.*;
import java.sql.*;
import java.util.*;
import pgclibrary.dataaccess.*;

/**
 *
 * @author  nestor
 */
public class ViewList extends TreeInfo {
    
    /** Creates a new instance of ViewList */
    public ViewList(RootElement source) {
        super(source);
        setIcon("/images/view.gif");
    }
    
    public void rebuildProperties() {
        removeAllProperties();
        try{
            PreparedStatement prep = getConnection().prepareStatement("SELECT RELNAME FROM PG_CLASS WHERE RELKIND='v' ORDER BY RELNAME");
            ResultSet rs = prep.executeQuery();
            while(rs.next()){
                addProperty(new Element(this, new View(getDatabase(), rs.getString("RELNAME")))); 
            }
            rs.close();
            prep.close();
        } catch (SQLException e){
        }
    }
    
    public Object getOID() {
        return toString();
    }
    
    public String toString(){
        return "Views";
    }
    
    public Database getDatabase(){
        return ((RootElement) getOwner()).getDatabase();
    }
}

