/*
 * UserList.java
 *
 * Created on 31 de julio de 2002, 10:59
 */

package pgclibrary.treeObjects;
import pgclibrary.objects.*;
import java.sql.*;
import java.util.*;
import pgclibrary.dataaccess.*;

/**
 *
 * @author  nestor
 */
public class UserList extends TreeInfo {
    
    /** Creates a new instance of UserList */
    public UserList(RootElement source) {
        super(source);
        setIcon("/images/user.png");
    }
    
    public void rebuildProperties() {
        removeAllProperties();
        try{
            PreparedStatement prep = getConnection().prepareStatement("SELECT * FROM PG_USER ORDER BY USENAME");
            ResultSet rs = prep.executeQuery();
            while(rs.next()){
                addProperty(new Element(this, new User(getDatabase(), rs.getLong("USESYSID"))));
            }
            rs.close();
            prep.close();
        } catch (SQLException e){
        }
    }
    
    public Object getOID() {
        return toString();
    }
    
    public String toString(){
        return "Users";
    }
    
    public Database getDatabase(){
        return ((RootElement) getOwner()).getDatabase();
    }
}
