/*
 * dataSource.java
 *
 * Created on 14 de septiembre de 2001, 11:05
 */

package pgclibrary.dataaccess;
import java.util.*;

/** Es un origen de datos que se emplea en la generaci\u00f3n de graficos, tablas y
 * reportes.
 * Es una clase abstracta que proporciona de la interfaz para su estandarizaci\u00f3n.
 *
 * @author NMarsollier
 * @version
 */
public abstract class dataSource extends java.lang.Object {
    public static final int MAX_COLUMN_SIZE = 100;
    public static final int MIN_COLUMN_SIZE = 7;
    public static final int DEFAULT_COLUMN_SIZE = 12;
    
    
    private ArrayList columnNames = new ArrayList();
    private int rowNum=0;
    private boolean filtered = false;
    private int rec_begin;
    private int rec_end;
    
    /** Creates new dataSource */
    public dataSource() {
    }
    
    /** Cierra el objeto correctamente limpiando los datos.
     * @return Devuelve false si se ha llegado al ultimo registro.
     */
    public abstract void close();
    
    /** Se mueve el puntero de datos a la primer fila de informacion.
     */
    public abstract void goTop();

    /** Se mueve el puntero de datos a la primer fila de informacion.
     */
    public void moveToRecord(int _record) {
        if(_record < getRowNum()){
            goTop();
        }
        while(getRowNum() < _record){
            next();
        }
    }
    
    /** Mueve el puntero de datos al siguiente registro.
     * @return Devuelve false si se ha llegado al ultimo registro.
     */
    public abstract boolean next();
    
    /** Determina si se ha llegado la ultima fila.
     * @return true si se ha llegado al final
     */
    public abstract boolean eof();
    
    /** Cantidad de columnas.
     * @return
     */
    public abstract int getColumnCount();
    

    public int getColumnSize(String _col){
        if(_col != null){
            return getColumnSize(columnNames.indexOf(_col.toUpperCase())+1);
        } else {
            return 10;
        }
    }
    public abstract int getColumnSize(int _col);
    
    protected int validateColumnSize(int _size){
        if(_size > MAX_COLUMN_SIZE){
            _size = MAX_COLUMN_SIZE;
        } else if(_size < 1){
            _size = DEFAULT_COLUMN_SIZE;
        } else if(_size < MIN_COLUMN_SIZE){
            _size = MIN_COLUMN_SIZE;
        }
        return _size;
    }
    
    /** Deveuelve el elemento que se encuentra en la posicion especificada.
     * @param _col Numero de columna
     * @return Valor contenido
     */
    public abstract String getElementAt(int _col);
    
    /** Devuelve la cantidad de registros de la consulta total, sin filtros
     */
    public abstract int getRowCount();
    
    /** Filtra la consulta en base a los numeros de registros que se pasan
     *  solamente muestra los registros entre esos rangos
     */
    public void setDataFilterRecord(int _rec_begin, int _rec_end){
        filtered = true;
        rec_begin = _rec_begin;
        rec_end = _rec_end;
    }
    
    /**
     *  Util solo cuando se utilizan filtros de datos.
     *  Devuelve el numero de la primer fila de datos.
     */
    public int getRowBegin(){
        return rec_begin;
    }
    /**
     *  Util solo cuando se utilizan filtros de datos.
     *  Devuelve el numero de la ultima fila de datos.
     */
    public int getRowEnd(){
        return rec_end;
    }
    /** Elimina cualquier filtro returnregistros
     */
    public void clearFilters(){
        if(isFiltered()){
            filtered = false;
        }
    }
    
    /** Devuelve true si se ha aplicado un filtro de registros
     */
    public boolean isFiltered(){
        return filtered;
    }
    
    /** Deveulve el numero de la fila actual
     * @return
     */
    public int getRowNum(){
        return rowNum;
    }
    protected void setRowNum(int _rowNum){
        if(_rowNum < 0){
            _rowNum = 0;
        }
        rowNum = _rowNum;
    }
    
    /** Devueleve el elemento que se encuentra en la columna especificada
     * @param _col Nombre de la columna
     * @return Elemento contenido
     */
    public String getElementAt(String _col){
        if(_col != null){
            return getElementAt(columnNames.indexOf(_col.toUpperCase())+1);
        } else {
            return "null";
        }
    }
    
    public int getIntAt(String _col) {
        int retorno = 0;
        try {
            retorno = Integer.parseInt(getElementAt(_col));
        } catch (Exception e) {}
        return retorno;
    }
    public int getIntAt(int _col) {
        int retorno = 0;
        try {
            retorno = Integer.parseInt(getElementAt(_col));
        } catch (Exception e) {}
        return retorno;
    }
    
    public double getDoubleAt(String _col) {
        double retorno = 0;
        try {
            retorno = Double.parseDouble(getElementAt(_col));
        } catch (Exception e) {}
        return retorno;
    }
    public double getDoubleAt(int _col) {
        double retorno = 0;
        try {
            retorno = Double.parseDouble(getElementAt(_col));
        } catch (Exception e) {}
        return retorno;
    }
    
    /** Establece el nombre de todas las columnas del origen de datos.
     * Esta especificaci\u00f3n no siempre esta permitida .
     * @param _columnNames
     */
    public void setColumnNames(ArrayList _columnNames){
        columnNames.clear();
        if(_columnNames!=null){
            for(int i=0; i<_columnNames.size(); i++){
                columnNames.add(_columnNames.get(i));
            }
        }
    }
    /** Devuelve el nombre de las columnas.
     * @return
     */
    public ArrayList getColumnNames(){
        return columnNames;
    }
    /** Agrega un nombre de columna al origen de datos.
     * Este metodo no siempre esta permitido.
     * @param _columnName
     */
    public void addColumnName(String _columnName){
        if((_columnName != null) && (columnNames.indexOf(_columnName)<0)){
            columnNames.add(_columnName.toUpperCase());
        }
    }
    /** Elimina un nombre de columna del listado.
     * @param _columnName
     */
    public void removeColumnName(String _columnName){
        if(_columnName != null){
            columnNames.remove(_columnName);
        }
    }
    
    /** Busca en la columna int el valor String.
     * Cuando lo encuentra se posiciona en ese registro.
     * Comienza a buscar siempre desde el principio.
     * @param _column Columna que se busca.
     *
     * @param _value Valor buscado
     * @return true si se encontro algo.
     */
    public boolean find(int _column, String _value){
        boolean retorno = false;
        goTop();
        while(!retorno && next()){
            retorno = getElementAt(_column).equals(_value);
        }
        return retorno;
    }
    
}
