/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.utilities;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public class Utilities {
    public static final String FORMAT_DATE = "MM/dd/yyyy";
    public static final String FORMAT_DATETIME = "MM/dd/yyyy HH:mm:ss";
    public static final String FORMAT_TIME = "HH:mm:ss";

    private Utilities() {
    }

    public static double round(double _number, int _num_decimals) {
        int __decimals = 1;
        int i = 0;
        while (i < _num_decimals) {
            __decimals = 10;
            ++i;
        }
        return (long)(_number * (double)__decimals) / (long)__decimals;
    }

    public static String replaceAll(String _cadena, String _caracterBuscado, String _cadenaReemplazo) {
        int pos = _cadena.indexOf(_caracterBuscado);
        while (pos >= 0) {
            _cadena = _cadena.substring(0, pos) + _cadenaReemplazo + _cadena.substring(pos + _caracterBuscado.length(), _cadena.length());
            pos = _cadena.indexOf(_caracterBuscado);
        }
        return _cadena;
    }

    private static StringBuffer replaceAll(StringBuffer _cadena, char _caracterBuscado, String _cadenaReemplazo) {
        int pos = _cadena.toString().indexOf(_caracterBuscado);
        while (pos >= 0) {
            _cadena = _cadena.replace(pos, pos + 1, _cadenaReemplazo);
            pos = _cadena.toString().indexOf(_caracterBuscado);
        }
        return _cadena;
    }

    public static String formatBoolean(boolean _value) {
        if (_value) {
            return "YES";
        }
        return "NO";
    }

    public static boolean parseBoolean(String _value) {
        return _value != null && !_value.equals("0") && !_value.toUpperCase().equals("YES");
    }

    public static String formatDecimal(double numero, String _pattern) {
        DecimalFormat pesosFormat = new DecimalFormat("#######0.00");
        return pesosFormat.format(numero);
    }

    public static String formatDecimal(double numero) {
        return Utilities.formatDecimal(numero, "#######0.00");
    }

    public static String formatDate(Date fecha) {
        return Utilities.formatDate(fecha, "dd/MM/yyyy");
    }

    public static String formatDate(Date fecha, String pattern) {
        String retorno = new String();
        try {
            if (fecha != null && pattern != null) {
                SimpleDateFormat template = new SimpleDateFormat(pattern);
                retorno = template.format(fecha);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retorno;
    }

    public static Date parseDate(String fecha) {
        return Utilities.parseDate(fecha, "dd/MM/yyyy");
    }

    public static Date parseDate(String fecha, String pattern) {
        Date retorno = new Date();
        try {
            if (fecha != null && pattern != null) {
                SimpleDateFormat template = new SimpleDateFormat(pattern);
                retorno = template.parse(fecha);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retorno;
    }

    public static Date roundDate(Date _fecha) {
        GregorianCalendar tmp = new GregorianCalendar();
        tmp.setTime(_fecha);
        tmp.set(14, 0);
        return tmp.getTime();
    }

    public static String parseError(Vector _errors) {
        StringBuffer retorno = new StringBuffer();
        if (_errors != null) {
            int i = 0;
            while (i < _errors.size()) {
                retorno.append(_errors.get(i).toString());
                retorno.append("\n");
                ++i;
            }
        }
        return retorno.toString();
    }
}

