package components.database;
import components.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import pgclibrary.objects.*;
import pgclibrary.dataaccess.*;
import java.awt.*;
import pgclibrary.utilities.*;

/**
 *
 * @author  nestor
 */
public class DatabasePanel extends JTabbedPane {
    Database database_object = null;
    
    JTextField oid = new JTextField(20);
    JTextField name = new JTextField(20);
    JTextField owner = new JTextField(20);
    JTextField encoding = new JTextField(20);
    JTextField location = new JTextField(20);
    JTextField template = new JTextField(20);
    JTextField istemplate = new JTextField(20);
    JTextField allowconn = new JTextField(20);
    
    JTextArea sql = new JTextArea();
    
    /** Creates a new instance of DatabasePanel */
    public DatabasePanel() {
        initPanel();
        setPreferredSize(this.getMinimumSize());
    }
    
    public void setDatabase(Database _database_object){
        database_object = _database_object;
        refreshProperties();
    }
    
    private void initPanel(){
        setBorder(new EmptyBorder(10,10,10,10));
        insertDefaultTab();
    }
    
    public void refreshProperties(){
        refreshDefaultPanel();
    }
    
    private void insertDefaultTab() {
        oid.setEditable(false);
        name.setEditable(false);
        owner.setEditable(false);
        encoding.setEditable(false);
        location.setEditable(false);
        template.setEditable(false);
        istemplate.setEditable(false);
        allowconn.setEditable(false);
        
        JSplitPane panel = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
        panel.setOneTouchExpandable(true);
        panel.setResizeWeight(0.5);
        
        sql.setEditable(false);
        panel.setBottomComponent(new JScrollPane(sql));
        
        JPanel general_panel = new JPanel();
        general_panel.setLayout(new BoxLayout(general_panel, BoxLayout.Y_AXIS));
        general_panel.add(SUtilities.getHorPanel("Database ID :", oid));
        general_panel.add(SUtilities.getHorPanel("Database Name :", name));
        general_panel.add(SUtilities.getHorPanel("Is Template :", istemplate));
        general_panel.add(SUtilities.getHorPanel("Allow Connections :", allowconn));
        general_panel.add(SUtilities.getHorPanel("Encoding :", encoding));
        general_panel.add(SUtilities.getHorPanel("Location :", location));
        general_panel.add(SUtilities.getHorPanel("Template :", template));
        general_panel.add(SUtilities.getHorPanel("Database DBA :", owner));
        
        panel.setTopComponent(SUtilities.centerComponent(general_panel));
        addTab("General", panel);
    }
    
    private void refreshDefaultPanel(){
        oid.setText(String.valueOf(database_object.getOID()));
        name.setText(database_object.getName());
        owner.setText(database_object.getCreator().getName());
        istemplate.setText(Utilities.formatBoolean(database_object.isTemplate()));
        allowconn.setText(Utilities.formatBoolean(database_object.allowConnections()));
        sql.setText(database_object.getInsertSQL());
        encoding.setText(database_object.getEncoding());
        location.setText(database_object.getLocation());
        template.setText(database_object.getTemplate());
        
        repaint();
    }
}


