/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.objects;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import pgclibrary.dataaccess.dataSource;
import pgclibrary.dataaccess.dataSourceVector;
import pgclibrary.objects.DBObject;
import pgclibrary.objects.TableColumn;
import pgclibrary.objects.User;
import pgclibrary.utilities.Utilities;

public class View
extends DBObject {
    private String definition = new String();
    private Vector columns = null;
    private String description = null;

    public View(DBObject owner, long oid) {
        super(owner);
        this.search(oid);
    }

    public View(DBObject owner) {
        super(owner);
    }

    public String getDeleteSQL() {
        StringBuffer retorno = new StringBuffer();
        retorno.append("DROP VIEW ");
        retorno.append(this.getName());
        retorno.append(";\n ");
        return retorno.toString();
    }

    public String getInsertSQL() {
        return this.getDefinition();
    }

    public String getUpdateSQL() {
        return new String();
    }

    public boolean search(long _oid) {
        boolean retorno = false;
        try {
            this.initialize();
            PreparedStatement prep = this.getConnection().prepareStatement("SELECT OID, * FROM PG_CLASS WHERE OID=?");
            prep.setLong(1, _oid);
            ResultSet rs = prep.executeQuery();
            if (rs.next()) {
                this.setName(rs.getString("RELNAME"));
                this.setOID(rs.getLong("OID"));
                this.setCreator(new User(this, rs.getLong("RELOWNER")));
                PreparedStatement prep1 = this.getConnection().prepareStatement("SELECT * FROM PG_VIEWS WHERE VIEWNAME=?");
                prep1.setString(1, this.getName());
                ResultSet rs1 = prep1.executeQuery();
                if (rs1.next()) {
                    this.setDefinition(rs1.getString("DEFINITION"));
                    retorno = true;
                }
                rs1.close();
                prep1.close();
                retorno = true;
            }
            rs.close();
            prep.close();
        }
        catch (SQLException e) {
            // empty catch block
        }
        return retorno;
    }

    public void initialize() {
        super.initialize();
        this.definition = new String();
        this.columns = null;
        this.description = null;
    }

    public dataSource getColumnsTable() {
        dataSourceVector dsve = new dataSourceVector();
        dsve.addColumnName("Col #");
        dsve.addColumnName("Name");
        dsve.addColumnName("Type");
        dsve.addColumnName("Size");
        dsve.addColumnName("Nulls");
        dsve.addColumnName("Default");
        dsve.addColumnName("Description");
        dsve.addColumnSize(10);
        dsve.addColumnSize(20);
        dsve.addColumnSize(15);
        dsve.addColumnSize(5);
        dsve.addColumnSize(5);
        dsve.addColumnSize(30);
        dsve.addColumnSize(30);
        Vector temp = this.getColumns();
        int i = 0;
        while (i < temp.size()) {
            TableColumn tc = (TableColumn)temp.get(i);
            Vector<String> elem = new Vector<String>();
            elem.add(String.valueOf(tc.getColumnNumber()));
            elem.add(tc.getName());
            elem.add(tc.getColumnType().getName());
            elem.add(String.valueOf(tc.getSize()));
            elem.add(Utilities.formatBoolean(tc.allowNulls()));
            elem.add(tc.getDefaultValue());
            elem.add(tc.getDescription());
            dsve.addElement(elem);
            ++i;
        }
        return dsve;
    }

    private void setDefinition(String _definition) {
        this.definition = _definition != null ? _definition : new String();
    }

    private String getDefinition() {
        return this.definition;
    }

    public Vector getColumns() {
        if (this.columns == null) {
            this.columns = new Vector();
            try {
                PreparedStatement prep = this.getConnection().prepareStatement("select *  from pg_attribute where ATTRELID = ?  and attnum > 0 order by attnum");
                prep.setLong(1, this.getOID());
                ResultSet rs = prep.executeQuery();
                while (rs.next()) {
                    this.columns.add(new TableColumn(this, rs.getLong("ATTNUM")));
                }
                rs.close();
                prep.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.columns;
    }

    public String getDescription() {
        if (this.description == null) {
            try {
                PreparedStatement prep;
                if (this.getConnection().getDatabaseVersion() < 7.2) {
                    prep = this.getConnection().prepareStatement("select obj_description(oid) as DESCRIPTION from pg_class where oid=? ");
                    prep.setLong(1, this.getOID());
                } else {
                    prep = this.getConnection().prepareStatement("select obj_description(oid, relname) as DESCRIPTION from pg_class where oid=? ");
                    prep.setLong(1, this.getOID());
                    prep.setString(2, this.getName());
                }
                ResultSet rs = prep.executeQuery();
                if (rs.next()) {
                    this.setDescription(rs.getString("DESCRIPTION"));
                } else {
                    this.setDescription(new String());
                }
                rs.close();
                prep.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.description;
    }

    public void setDescription(String _description) {
        this.description = _description != null ? _description : new String();
    }

    public void refresh() {
        this.search(this.getOID());
    }
}

