package components.group;
import components.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import pgclibrary.objects.*;
import pgclibrary.dataaccess.*;
import java.awt.*;
import pgclibrary.utilities.*;

/**
 *
 * @author  nestor
 */
public class GroupPanel extends JTabbedPane {
    Group group_object = null;
    
    JTextField oid = new JTextField(20);
    JTextField name = new JTextField(20);
    JTextArea description = new JTextArea(3, 20);
    
    UsersPanel user_panel = new UsersPanel();

    JTextArea sql = new JTextArea();
    
    /** Creates a new instance of DatabasePanel */
    public GroupPanel() {
        initPanel();
        setPreferredSize(this.getMinimumSize());
    }
    
    public void setGroup(Group _group_object){
        group_object = _group_object;
        refreshProperties();
    }
    
    private void initPanel(){
        setBorder(new EmptyBorder(10,10,10,10));
        insertDefaultTab();
        addTab("Users", user_panel);
        addChangeListener(new ChangeListener(){
                public void stateChanged(ChangeEvent e){
                    refreshProperties();
                }
            }
        );
    }
    
    public void refreshProperties(){
        switch(this.getSelectedIndex()){
            case 0:
                refreshDefaultPanel();
                break;
            case 1:
                user_panel.refresh(group_object);
                break;
        }
    }
    
    private void insertDefaultTab() {
        oid.setEditable(false);
        name.setEditable(false);
        description.setEditable(false);
        description.setBorder(oid.getBorder());
        description.setBackground(oid.getBackground());
        description.setLineWrap(true);
        JScrollPane dpane = new JScrollPane(description);
        dpane.setPreferredSize(description.getPreferredSize());
        
        JSplitPane panel = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
        panel.setOneTouchExpandable(true);
        panel.setResizeWeight(0.5);
        
        sql.setEditable(false);
        panel.setBottomComponent(new JScrollPane(sql));
        
        JPanel general_panel = new JPanel();
        general_panel.setLayout(new BoxLayout(general_panel, BoxLayout.Y_AXIS));
        general_panel.add(SUtilities.getHorPanel("Group ID :", oid));
        general_panel.add(SUtilities.getHorPanel("Group Name :", name));
        general_panel.add(SUtilities.getHorPanel("Description :",dpane));
        
        panel.setTopComponent(SUtilities.centerComponent(general_panel));
        addTab("General", panel);
    }
    
    private void refreshDefaultPanel(){
        oid.setText(String.valueOf(group_object.getOID()));
        name.setText(group_object.getName());
        sql.setText(group_object.getInsertSQL());
        description.setText(group_object.getDescription());
        repaint();
    }
}


