/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.objects;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import pgclibrary.dataaccess.MainConnection;
import pgclibrary.objects.User;

public abstract class DBObject {
    private DBObject owner = null;
    private User creator = null;
    private String name = new String();
    private long oid = -1L;
    private String description = null;

    public DBObject(DBObject _owner) {
        this.setOwner(_owner);
    }

    public abstract String getInsertSQL();

    public abstract String getDeleteSQL();

    public abstract String getUpdateSQL();

    public abstract boolean search(long var1);

    protected void initialize() {
        this.name = new String();
        this.oid = -1L;
        this.description = null;
    }

    public void refresh() {
        if (this.oid > 0L) {
            this.search(this.oid);
        }
    }

    public DBObject getOwner() {
        return this.owner;
    }

    protected void setOwner(DBObject _owner) {
        this.owner = _owner;
    }

    protected void setCreator(User _creator) {
        this.creator = _creator;
    }

    public User getCreator() {
        return this.creator;
    }

    protected void setOID(long _oid) {
        this.oid = _oid;
    }

    public long getOID() {
        return this.oid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String _name) {
        this.name = _name != null ? _name : new String();
    }

    public String getDescription() {
        if (this.description == null) {
            try {
                PreparedStatement prep = this.getConnection().prepareStatement("select * from pg_description where OBJOID = ?");
                prep.setLong(1, this.getOID());
                ResultSet rs = prep.executeQuery();
                if (rs.next()) {
                    this.setDescription(rs.getString("DESCRIPTION"));
                } else {
                    this.setDescription(new String());
                }
                rs.close();
                prep.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.description;
    }

    public void setDescription(String _description) {
        this.description = _description != null ? _description : new String();
    }

    public MainConnection getConnection() {
        return this.getOwner().getConnection();
    }
}

