#!/bin/sh
# the next line calls 
#     tclsh "$0" "$@"
# where - "$0" is the filename of the script being executed, i.e. install.tcl
#       - "$@" stands for all arguments with which the script was called
# The backslash at the end of this comment makes the next line a continuation
# of the comment for tclsh, but not for sh. So, the next line is only
# executed in 'sh', not in 'tclsh' \
exec tclsh "$0" "$@"

package provide install_pfm 1.1.1

package require Tk

namespace eval install {

    variable API "pgintcl 2.1.0"
    variable TRE "Tclkit"
    variable apiHelp
    variable treHelp
    variable dirHelp
    variable pathList
    variable launchDir {~/bin}
    global env

    set apiHelp "pgintcl 2.1.0 requires postgreSQL 7.4 or higher.\n"
    set apiHelp "$apiHelp\npgintcl 1.5.0 requires postgreSQL 6.4 or higher.\n"
    set apiHelp "$apiHelp\nPgtcl has better performance, but is not included"
    set apiHelp "$apiHelp\nin this distribution.\n"
    set apiHelp "$apiHelp\nIf you want to use Pgtcl, you have to download it from\n"
    set apiHelp "$apiHelp\nhttp://gborg.postgresql.org/project/pgtclng/projdisplay.php\n"
    set apiHelp "$apiHelp\nPgtcl cannot be used when pfm runs under the Tclkit."

    set treHelp "If Tcl/Tk version 8.4 is installed on your system,"
    set treHelp "$treHelp\nyou can run pfm in the Tcl/Tk runtime environenment.\n"
    set treHelp "$treHelp\nYou can verify the presence of Tcl/Tk as follows.\n"
    set treHelp "$treHelp\nFrom the command prompt type 'tclsh'."
    set treHelp "$treHelp\nYou should get a '%' prompt.\n"
    set treHelp "$treHelp\nTo see the version, type 'info tclversion'"
    set treHelp "$treHelp\nat the '%' prompt. You should get 8.4.\n"
    set treHelp "$treHelp\nThen type 'package require Tk"
    set treHelp "$treHelp\nYou should get 8.4 and an empty window titled 'tclsh'\n"
    set treHelp "$treHelp\nElse, you can use the Tclkit included in the"
    set treHelp "$treHelp\npfm distribution.\n"
    set treHelp "$treHelp\nUsing the Tclkit excludes the use of Pgtcl."

    set dirHelp "Where do you want to install the pfm launch script?"
    set dirHelp "$dirHelp\nPreferrably take one from PATH."

    set pathList [split $env(PATH) :]

    proc initRootWindow { } {
	variable apiHelp
	variable treHelp
	variable dirHelp
	variable pathList
	variable launchDir

	wm title . "Install pfm"
	wm geometry . 700x500
	frame .api -relief sunken -borderwidth 2
	frame .tre -relief sunken -borderwidth 2
	frame .launch -relief sunken -borderwidth 2
	frame .buttons -relief sunken -borderwidth 2
	place .api -x 0 -y 0 -relwidth 1 -relheight 0.30
	place .tre -x 0 -y 0 -rely 0.30 -relwidth 1 -relheight 0.30
	place .launch -x 0 -y 0 -rely 0.60 -relwidth 1 -relheight 0.30
	place .buttons -x 0 -y 0 -rely 0.90 -relwidth 1 -relheight 0.10


	################################################################
	# Interface with postgreSQL                                    #
	################################################################

	label .api.title -text "Interface with postgreSQL"
	place .api.title -x 0 -y 5 -relx 0.5 -anchor n
	frame .api.buttons -relief sunken -borderwidth 2
	place .api.buttons -x 0 -y 30 -relwidth 0.2 -relheight 1 -height -30
 	radiobutton .api.buttons.rb201 -variable ::install::API -value "pgintcl 2.1.0" \
 	    -text "pgintcl 2.1.0" -anchor w -command {
		.tre.buttons.rbkit configure -state normal
	    }
 	radiobutton .api.buttons.rb150 -variable ::install::API -value "pgintcl 1.5.0" \
	    -text "pgintcl 1.5.0" -anchor w -command {
		.tre.buttons.rbkit configure -state normal
	    }
 	radiobutton .api.buttons.rbpgtcl -variable ::install::API -value "Pgtcl" \
	    -text "Pgtcl" -anchor w -command {
		.tre.buttons.rbkit configure -state disabled
	    } -state disabled
	grid .api.buttons.rb201 -column 0 -row 0 -sticky we
	grid .api.buttons.rb150 -column 0 -row 1 -sticky we
	grid .api.buttons.rbpgtcl -column 0 -row 2 -sticky we
	text .api.help -relief sunken -background white \
	    -yscrollcommand {.api.bar set}
	scrollbar .api.bar -orient vertical -command {.api.help yview} -width 10
	place .api.bar -x 0 -y 30 -relx 1 -relheight 1 -anchor ne -height -30
	place .api.help -x 0 -y 30 -relx 0.2 -relwidth 0.8 -relheight 1 \
	    -height -30 -width -10
	.api.help insert end $apiHelp

	################################################################
	# Tcl/Tk runtime environment                                   #
	################################################################

	label .tre.title -text "Tcl/Tk run time environment"
	place .tre.title -x 0 -y 5 -relx 0.5 -anchor n
	frame .tre.buttons -relief sunken -borderwidth 2
	place .tre.buttons -x 0 -y 30 -relwidth 0.2 -relheight 1 -height -30
 	radiobutton .tre.buttons.rbwish -variable ::install::TRE -value "Tcl/Tk" \
	    -text "Tcl/Tk" -anchor w -command {
		.api.buttons.rbpgtcl configure -state normal
	    }
	radiobutton .tre.buttons.rbkit -variable ::install::TRE -value "Tclkit" \
	    -text "Tclkit" -anchor w -command {
		.api.buttons.rbpgtcl configure -state disabled
	    }
	grid .tre.buttons.rbwish -column 0 -row 0 -sticky we
	grid .tre.buttons.rbkit -column 0 -row 1 -sticky we
	text .tre.help -relief sunken -background white \
	    -yscrollcommand {.tre.bar set}
	scrollbar .tre.bar -orient vertical -command {.tre.help yview} -width 10
	place .tre.bar -x 0 -y 30 -relx 1 -relheight 1 -anchor ne -height -30
	place .tre.help -x 0 -y 30 -relx 0.2 -relwidth 0.8 -relheight 1 \
	    -height -30 -width -10
	.tre.help insert end $treHelp

	################################################################
	# pfm launch script                                            #
	################################################################

	label .launch.title -text $dirHelp
	grid .launch.title -column 0 -columnspan 3 -row 0
	entry .launch.dir -width 40 -textvariable ::install::launchDir
	button .launch.path -text "PATH ..." -command ::install::cmdPath
	button .launch.other -text "Other ..." -command ::install::cmdOther
	grid .launch.dir -column 0 -row 1
	grid .launch.path -column 1 -row 1
	grid .launch.other -column 2 -row 1


	################################################################
	# Buttons                                                      #
	################################################################

	button .buttons.btnFinish -text Finish -command ::install::cmdFinish
	button .buttons.btnCancel -text Cancel -command exit
	place .buttons.btnCancel -x 0 -y 0 -relx 0.4 -rely 1 -anchor s
	place .buttons.btnFinish -x 0 -y 0 -relx 0.6 -rely 1 -anchor s
	return
    }

    proc cmdPath {} {
	variable pathList

	destroy .path
	toplevel .path -class Toplevel
	wm transient .path .
	set x [winfo pointerx .]
	set y [expr [winfo pointery .] - 200]
	wm geometry .path 200x300+$x+$y
	wm title .path "Install pfm - PATH"
	listbox .path.lsbox -listvariable ::install::pathList \
	    -yscrollcommand {.path.bar set}
	scrollbar .path.bar -orient vertical -command {.path.lsbox yview} -width 10
	place .path.lsbox -x 0 -y 0 -relwidth 1 -width -10 -relheight 1 -height -30
	place .path.bar -x 0 -y 0 -relheight 1 -height -30 -relx 1 -anchor ne
	button .path.btnOK -text OK -command ::install::cmdPathOK
	button .path.btnCancel -text Cancel -command {destroy .path}
	place .path.btnCancel -x 0 -y 0 -relx 0.3 -rely 1 -anchor s
	place .path.btnOK -x 0 -y 0 -relx 0.7 -rely 1 -anchor s
	return
    }

    proc cmdPathOK {} {
	variable launchDir
	variable pathList

	set launchDir [lindex $pathList [.path.lsbox curselection]]
	destroy .path
	return
    }

    proc cmdOther {} {
	variable launchDir

	set launchDir [tk_chooseDirectory -initialdir $launchDir \
			   -parent . -mustexist true]
	return
    }

    proc cmdFinish {} {
	variable launchDir
	variable API
	variable TRE
	
	set success true
	.buttons.btnFinish configure -state disabled
	.buttons.btnCancel configure -state disabled
	openLogWindow
	writeToLog "Interface to postgreSQL : $API\n\n"
	writeToLog "Run time environment : $TRE\n\n"
	writeToLog "Launch script will be installed in $launchDir\n\n"
	set pfmDir [pwd]
	if {![file exists $launchDir]} then {
	    if { [catch {file mkdir $launchDir} errMsg] } then {
		set success false
		bell
		writeToLog "ERROR : $errMsg\n\n"
	    } else {
		writeToLog "mkdir $launchDir\n\n"
	    }
	}
	set script "\#!/bin/sh"
	set script "$script\n# pfm launch script, generated by $pfmDir/install.tcl\n"
	switch $TRE {
	    "Tcl/Tk" {
		set script "$script\ntclsh [file join $pfmDir pfm.tcl] $pfmDir\n"
	    }
	    "Tclkit" {
		set script "$script\n[file join $pfmDir tclkit tclkit]"
		set script "$script [file join $pfmDir pfm.kit] $pfmDir\n"
	    }
	    default {
		set script {}
		set success false
		bell
		writeToLog "ERROR : Illegal value for TRE: $TRE\n\n"
	    }
	}
	if { ![string equal $script {}] } then {
	    set pfmName [file join $launchDir pfm]
	    if { [file exists $pfmName] } then {
		set backupName "$pfmName.bak"
		set backupRoot "$pfmName.bak"
		set n 0
		while { [file exists $backupName] } {
		    incr n
		    set backupName "$backupRoot$n"
		}
		file rename $pfmName $backupName
		writeToLog "$pfmName has been renamed to $backupName\n\n"
	    }
	    if { [catch {open $pfmName w} pfmFile] } then {
		set success false
		bell
		writeToLog "ERROR : $pfmFile\n\n"
	    } else {
		puts $pfmFile $script
		close $pfmFile
		file attributes $pfmName -permissions ugo+rx
		writeToLog "$pfmName has been written\n\n"
	    }
	}
	set pgintclLink [file join $pfmDir pgin.tcl]
	switch $API {
	    "pgintcl 2.1.0" {
		file delete $pgintclLink
		set pgtclTarget [file join $pfmDir "pgintcl-2.1.0" "pgin.tcl"]
		if { [catch {file link $pgintclLink $pgtclTarget} errMsg] } then {
		    set success false
		    bell
		    writeToLog "ERROR : $errMsg\n\n"
		} else {
		    writeToLog \
			"Symbolic link 'pgin.tcl' to\n$pgtclTarget\nhas been made in\n$pfmDir\n\n"
		}
	    }
	    "pgintcl 1.5.0" {
		file delete $pgintclLink
		set pgtclTarget [file join $pfmDir "pgintcl-1.5.0" "pgin.tcl"]
		if { [catch {file link $pgintclLink $pgtclTarget} errMsg] } then {
		    set success false
		    bell
		    writeToLog "ERROR : $errMsg\n\n"
		} else {
		    writeToLog \
			"Symbolic link 'pgin.tcl' to\n$pgtclTarget\nhas been made in\n$pfmDir\n\n"
		}
	    }
	    "Pgtcl" {
		file delete $pgintclLink
		writeToLog \
		    "Symbolic link 'pgin.tcl' has been removed from\n$pfmDir\n\n"
	    }
	    default {
		bell
		writeToLog "Illegal value for API : $API\n\n"
	    }
	}
	if { $success } then {
	    writeToLog "pfm install has been completed successfully\n\n"
	} else {
	    bell
	    writeToLog "pfm install has failed\n\n"
	}
	writeToLog "You can run the install program again at any time\n"
	writeToLog "to change the options you have selected.\n\n"
    }

    proc openLogWindow {} {

	toplevel .log
	set x [expr [winfo pointerx .] - 300]
	set y [expr [winfo pointery .] - 400]
	wm geometry .log 400x300+$x+$y
	wm transient .log .
	wm title .log "Install pfm - Log"
	text .log.txt -relief sunken -background white -yscrollcommand {.log.bar set}
	scrollbar .log.bar -orient vertical -command {.log.txt yview} -width 10
	place .log.txt -x 0 -y 0 -width -10 -relwidth 1 -height -30 -relheight 1
	place .log.bar -x 0 -y 0 -relx 1 -anchor ne -height -30 -relheight 1
	button .log.ok -text OK -command {exit}
	place .log.ok -x 0 -y 0 -relx 0.5 -rely 1 -anchor s
	return
    }

    proc writeToLog {message} {
	
	.log.txt insert end $message
	.log.txt see end
	return
    }

    initRootWindow

}