#include <iostream>

#include <pqxx/connection.h>
#include <pqxx/transaction.h>
#include <pqxx/result.h>

using namespace std;
using namespace pqxx;


int main()
{
  try
  {
    Connection C("");

    Transaction T(C, "sample1");

    Result R = T.Exec("SELECT tablename FROM pg_tables");


    // Process each successive result tuple using iterators, converting each
    // field to a type of our choice--in this case, a C++ string.
    for (Result::const_iterator c = R.begin(); c != R.end(); ++c)
    {
      // Read value of column 0 into a string N
      string N;
      c[0].to(N);

      cout << '\t' << c.num() << '\t' << N << endl;
    }

    cout << endl;

    // Now do the same thing using array indexing, reading each field as a raw
    // C string.
    for (Result::size_type i = 0; i < R.size(); ++i)
      cout << '\t' << i << '\t' << R[i][0].c_str() << endl;


    // Tell the transaction that it has been successful
    T.Commit();
  }
  catch (const exception &e)
  {
    cerr << "Exception: " << e.what() << endl;
    return 1;
  }

  return 0;
}


