/* project: PostgreSQL binding
 * title:   class implementation
 * author:  Alexander V. Diemand
 * date:    2002-02-04
 */
 
 /* $Id: main.m,v 1.1.1.1 2003/01/11 17:57:17 axeld Exp $ */
 

#include <Foundation/Foundation.h>

#include "PostgreSQL.oh"

static void usage(void);


int main(int argc, char **argv)
{
	if (argc != 5)
	{
		usage();
		return -1;
	}

        NSAutoreleasePool *pool = [NSAutoreleasePool new];

	NSString *p_host = [NSString stringWithCString: argv[1]];
	NSString *p_port = [NSString stringWithCString: argv[2]];
	NSString *p_db = [NSString stringWithCString: argv[3]];
	NSLog(@"connectTo: %@ at: %@ on: %@",p_host,p_port,p_db);
	id pq = [PostgreSQL connectTo: p_db
		                   on: p_host
		                   at: p_port];
	if ([pq query: [NSString stringWithCString: argv[4]]] == NO) {
		NSLog(@"error on query.");
		[pq disconnect];
		return -1;
	}

	unsigned long rows = [pq rows];
	int counter=0;
	for (counter=0; counter<rows; counter++) {
		NSLog(@"%d saw: %@\n",counter,[pq getRow: counter]);
	}

	[pq disconnect];

	[pool release];

	return 0;
}



static void usage (void) 
{
	printf("Usage: pqtest <host> <port> <database> <query>\n");
}

