/*
 * $Source: /usr/local/cvsroot/erserver/erserver/java/src/com/postgres/replic/tools/desc/DropTriggerDesc.java,v $
 * $Author: ronz $ $Revision: 1.2 $ $Date: 2004/03/09 17:13:44 $
 *
 */

package com.postgres.replic.tools.desc;

import com.postgres.replic.tools.*;
import java.sql.*;

public class DropTriggerDesc extends GeneratorDescriptor {

    private static final String DROP_TRIGGER_SQL = "SELECT cl.relname, tr.tgname " +
    "FROM pg_trigger AS tr, pg_class AS cl " +
    "WHERE tr.tgrelid=cl.oid and tr.tgname like '" +
        ToolKitConst.GLOBAL_PREFIX + "%'";


    public DropTriggerDesc(boolean print, Connection conn) throws Exception{
        this.print = print;
        if (conn == null ) {
            throw new Exception("SequenceDesc:: connection may not be null");
        }
        this.conn = conn;

    }

    private String getDropTrigger(String table, String trigger) {
        return "DROP TRIGGER " + trigger + " ON " + table + ";";
    }

    private String getTriggerName(String table, String column) {
        return ToolKitConst.GLOBAL_PREFIX + getFiller(table) + "_" + column;
    }

    public void printDropTrigger() {
        ResultSet rs = null;
        Statement stmt = null;
        String result = "";

        try {
            stmt = getConnection().createStatement();
            rs = stmt.executeQuery(DROP_TRIGGER_SQL);
            while (rs.next()) {
                System.out.println(getDropTrigger(rs.getString(1), rs.getString(2)));
            }
        } catch (Exception e) {
            System.out.println("JDBCSystem::printDropTrigger: " + e.toString());
        } finally {
            try {
                if (stmt != null) { stmt.close(); }
            } catch (Exception e) { }
        }
    }
}
